/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.BadButtonException;
import applet.CommandButtonListener;
import applet.ControlPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CommandButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Icon icon;
    private Icon pressed_icon = null;
    private int cmdId;
    private CommandButtonListener btnListener = null;
    private boolean hover;
    private boolean pressed;
    private Color bgColor = new Color(192, 192, 192);
    static int bwidth = 40;
    static int bheight = 40;
    Border noBorder = BorderFactory.createEmptyBorder();
    Border raisedBorder = BorderFactory.createRaisedBevelBorder();
    Border loweredBorder = BorderFactory.createLoweredBevelBorder();

    public CommandButton(int btnId, String label, Icon btnIcon, Icon pressedIcon) throws BadButtonException {
        this.icon = btnIcon;
        this.pressed_icon = pressedIcon;
        this.cmdId = btnId;
        this.setToolTipText(label);
        Dimension dim = new Dimension(bwidth, bheight);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        MouseListener listener = new MouseListener();
        this.addMouseListener(listener);
    }

    public void setListener(CommandButtonListener l) {
        this.btnListener = l;
    }

    public CommandButtonListener getListener() {
        return this.btnListener;
    }

    public void setActive() {
        ((ControlPanel)this.getParent()).setActiveButton(this);
    }

    public boolean getActive() {
        return ((ControlPanel)this.getParent()).getActiveButton() == this;
    }

    public void repaintAll() {
        this.repaint(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public boolean activateAction() {
        boolean res = false;
        if (this.btnListener != null && (res = this.btnListener.setModus(this.cmdId))) {
            this.setPressed(true);
        }
        return res;
    }

    public void cancelAction() {
        if (this.btnListener != null) {
            this.btnListener.resetModus();
        }
        this.setPressed(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.pressed) {
            if (this.pressed_icon != null) {
                this.pressed_icon.paintIcon(this, g, 5, 5);
            } else {
                this.icon.paintIcon(this, g, 5, 5);
            }
        } else {
            this.icon.paintIcon(this, g, 4, 4);
        }
    }

    protected void setHover(boolean state) {
        this.hover = state;
        if (this.hover) {
            if (this.pressed) {
                this.setBorder(this.loweredBorder);
            } else {
                this.setBorder(this.raisedBorder);
            }
        } else if (!this.pressed) {
            this.setBorder(this.noBorder);
        }
    }

    protected void setPressed(boolean state) {
        this.pressed = state;
        if (this.pressed) {
            this.setBorder(this.loweredBorder);
        } else if (this.hover) {
            this.setBorder(this.raisedBorder);
        } else {
            this.setBorder(this.noBorder);
        }
    }

    private boolean isAtOnceCmd() {
        return this.cmdId == 78 || this.cmdId == 79 || this.cmdId == 230 || this.cmdId == 104 || this.cmdId == 90;
    }

    private class MouseListener
    implements java.awt.event.MouseListener {
        private MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!CommandButton.this.isAtOnceCmd()) {
                CommandButton.this.setActive();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (((ControlPanel)CommandButton.this.getParent()).getActiveButton() == null) {
                CommandButton.this.setHover(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (((ControlPanel)CommandButton.this.getParent()).getActiveButton() == null) {
                CommandButton.this.setHover(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (CommandButton.this.isAtOnceCmd()) {
                CommandButton.this.setPressed(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (CommandButton.this.isAtOnceCmd()) {
                CommandButton.this.btnListener.startExecution(CommandButton.this.cmdId);
            }
        }
    }
}

