/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.BadButtonException;
import applet.CommandButton;
import applet.CommandButtonFactory;
import applet.Controller;
import applet.Logo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class ControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CommandButton activeButton;
    private HashMap<String, CommandButton> buttonMap = new HashMap();

    public ControlPanel(int width, int height, Iterator<String> buttonIds) {
        Dimension dim = new Dimension(width, height);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setLayout(new BoxLayout(this, 1));
        try {
            this.add(Box.createRigidArea(new Dimension(0, 4)));
            if (buttonIds != null) {
                this.loadButtons(buttonIds);
            }
        }
        catch (BadButtonException e) {
            System.err.println("Init button error: " + e.getMessage());
            e.printStackTrace();
        }
        this.addLogo();
        this.addMouseListener(new MyMouseListener());
    }

    public CommandButton getButton(String id) throws BadButtonException {
        CommandButton button = this.buttonMap.get(id);
        if (button == null) {
            throw new BadButtonException(id);
        }
        return button;
    }

    public CommandButton getActiveButton() {
        return this.activeButton;
    }

    public void setActiveButton(CommandButton button) {
        if (this.activeButton == button && button != null) {
            button.cancelAction();
            this.resetAllButtons();
        } else {
            if (this.activeButton != null && this.activeButton != button) {
                this.activeButton.cancelAction();
            }
            if (button == null) {
                CommandButton lastButton = this.activeButton;
                this.activeButton = null;
                if (lastButton != null) {
                    lastButton.repaintAll();
                }
            } else if (button.activateAction()) {
                if (this.activeButton == null) {
                    this.activeButton = button;
                    button.repaintAll();
                } else {
                    CommandButton lastButton = this.activeButton;
                    this.activeButton = button;
                    if (this.activeButton != lastButton) {
                        lastButton.setPressed(false);
                        lastButton.setHover(false);
                    }
                    lastButton.repaintAll();
                    this.activeButton.repaintAll();
                }
            } else {
                CommandButton lastButton = this.activeButton;
                this.activeButton = null;
                if (lastButton != null) {
                    lastButton.repaintAll();
                }
            }
        }
    }

    public void resetAllButtons() {
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.getComponent(i).getClass() == CommandButton.class) {
                CommandButton btn = (CommandButton)this.getComponent(i);
                btn.setHover(false);
                btn.setPressed(false);
            }
            ++i;
        }
        this.activeButton = null;
    }

    public void initButtons(Controller brains) {
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.getComponent(i).getClass() == CommandButton.class) {
                CommandButton btn = (CommandButton)this.getComponent(i);
                btn.setListener(brains);
            }
            ++i;
        }
    }

    public void reloadButtons(Iterator<String> btn_it, Controller brains) {
        try {
            this.deleteButtons();
            this.add(Box.createRigidArea(new Dimension(0, 4)));
            this.loadButtons(btn_it);
            this.addLogo();
            this.initButtons(brains);
            this.resetAllButtons();
        }
        catch (Exception e) {
            System.err.println("Init button error: " + e.getMessage());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void loadButtons(Iterator<String> buttonIds) throws BadButtonException {
        String id = null;
        while (buttonIds.hasNext()) {
            CommandButton cb;
            id = buttonIds.next();
            if (this.buttonMap.containsKey(id) || (cb = CommandButtonFactory.createButton(id)) == null) continue;
            this.add(cb);
            this.buttonMap.put(id, cb);
        }
    }

    private void deleteButtons() {
        int i = this.getComponentCount() - 1;
        LayoutManager designer = this.getLayout();
        while (i >= 0) {
            Component comp = this.getComponent(i);
            designer.removeLayoutComponent(comp);
            this.remove(comp);
            --i;
        }
        this.buttonMap.clear();
    }

    private void addLogo() {
        Logo logo = new Logo("logo_left");
        this.add(Box.createVerticalGlue());
        this.add(logo);
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ControlPanel.this.resetAllButtons();
        }
    }
}

