/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.AboutDialog;
import applet.BadParameterException;
import applet.ColorSettingsDialog;
import applet.CommandButtonListener;
import applet.DynaGeoJ;
import applet.EditNameDialog;
import applet.EditNumberDialog;
import applet.EditTermDialog;
import applet.EditTextBoxDialog;
import applet.EditVisibilityDialog;
import applet.GeoFileFilter;
import applet.InpItem;
import applet.InpItemList;
import applet.Messages;
import applet.Options;
import canvas.CoordsCanvas;
import canvas.FillMenu;
import canvas.LinesMenu;
import canvas.PointsMenu;
import canvas.PopupMenu;
import dgmath.MyMath;
import geoobj.GAngle;
import geoobj.GArc;
import geoobj.GArea;
import geoobj.GBisector;
import geoobj.GCircle;
import geoobj.GCircleWDR;
import geoobj.GConic;
import geoobj.GCurve;
import geoobj.GDoubleIntersection;
import geoobj.GEllipseF;
import geoobj.GEnvelope;
import geoobj.GGraph;
import geoobj.GHyperbelF;
import geoobj.GIntersectPoint;
import geoobj.GInversion;
import geoobj.GLine;
import geoobj.GLineObj;
import geoobj.GLineWDD;
import geoobj.GMappedCircle;
import geoobj.GMappedPoint;
import geoobj.GMappedRegPoly;
import geoobj.GMapping;
import geoobj.GMeasureAngle;
import geoobj.GMeasureArea;
import geoobj.GMeasureDistance;
import geoobj.GMidPoint;
import geoobj.GNumber;
import geoobj.GObjectName;
import geoobj.GOrigin;
import geoobj.GParabelF;
import geoobj.GParallelLine;
import geoobj.GPerpBisector;
import geoobj.GPerpendicular;
import geoobj.GPoint;
import geoobj.GPointLXL;
import geoobj.GPolygon;
import geoobj.GQuadIntersection;
import geoobj.GRay;
import geoobj.GRegPoly;
import geoobj.GSegment;
import geoobj.GSimiliarity;
import geoobj.GTerm;
import geoobj.GTextBox;
import geoobj.GTrace;
import geoobj.GVector;
import geoobj.GVertex;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.LocLineController;
import geoobj.RelationListIterator;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import xml.DynaGeoFileIO;
import xml.WindowData;

public class Controller
implements CommandButtonListener,
ActionListener,
ComponentListener,
MouseMotionListener,
MouseListener,
MouseWheelListener {
    private int fModus = 0;
    private int newLocLine = 0;
    private InpItemList inpList = new InpItemList();
    private DynaGeoJ mainWindow = null;
    private CoordsCanvas canvas = null;
    private GeoObjList drawing = null;
    private GeoObj mousedObj = null;
    private GeoObj popupObj = null;
    private GPoint generatorPt = null;
    private GLine generatorLn = null;
    private GTrace recordingTr = null;
    private PopupMenu popupMenu = null;
    private double lastMouseX = 0.0;
    private double lastMouseY = 0.0;
    private int lastPopupX = 0;
    private int lastPopupY = 0;
    private boolean fHasButtons = true;
    private int last_x;
    private int last_y;
    public KeyListener myKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 27: {
                    Controller.this.getMainWindow().reset2DragMode();
                    break;
                }
                case 71: {
                    try {
                        Controller.this.executeCmd();
                    }
                    catch (BadParameterException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                case 107: {
                    if (Controller.this.aniTimer == null || !Controller.this.aniTimer.isRunning()) break;
                    Controller controller = Controller.this;
                    controller.aniStep = controller.aniStep * 1.5;
                    break;
                }
                case 109: {
                    if (Controller.this.aniTimer == null || !Controller.this.aniTimer.isRunning()) break;
                    Controller controller = Controller.this;
                    controller.aniStep = controller.aniStep / 1.5;
                    break;
                }
                case 106: {
                    if (Controller.this.aniTimer == null || !Controller.this.aniTimer.isRunning()) break;
                    Controller.this.aniStep = -Controller.this.aniStep;
                }
            }
        }
    };
    public static final int cmd_Drag = 0;
    public static final int cmd_Move = 1;
    public static final int cmd_New = 101;
    public static final int cmd_Load = 102;
    public static final int cmd_SaveAs = 104;
    public static final int cmd_ZoomReset = 111;
    public static final int cmd_ZoomIn = 115;
    public static final int cmd_ZoomOut = 116;
    public static final int cmd_PCreate = 121;
    public static final int cmd_PointWDC = 42;
    public static final int cmd_PonLine = 109;
    public static final int cmd_SCreate = 122;
    public static final int cmd_GCreate = 123;
    public static final int cmd_Vector = 45;
    public static final int cmd_Strahl = 43;
    public static final int cmd_KCreate = 124;
    public static final int cmd_NCreate = 131;
    public static final int cmd_Schnitt = 132;
    public static final int cmd_Mitte = 133;
    public static final int cmd_MSenkr = 135;
    public static final int cmd_WHalb = 136;
    public static final int cmd_Parall = 137;
    public static final int cmd_Lot = 138;
    public static final int cmd_HideObj = 112;
    public static final int cmd_ShowAll = 118;
    public static final int cmd_DelObj = 114;
    public static final int cmd_NameObj = 113;
    public static final int cmd_Comment = 90;
    public static final int cmd_BindP2L = 152;
    public static final int cmd_ReleaseP = 153;
    public static final int cmd_MirrorAxisObj = 47;
    public static final int cmd_MirrorCentreObj = 49;
    public static final int cmd_MoveObj = 51;
    public static final int cmd_RotateObj = 53;
    public static final int cmd_StretchObj = 55;
    public static final int cmd_MirrorCircleObj = 56;
    public static final int cmd_MapObj = 58;
    public static final int cmd_MakeLocLine = 158;
    public static final int cmd_MeasureAngle = 155;
    public static final int cmd_MeasureDist = 156;
    public static final int cmd_MeasureSL = 89;
    public static final int cmd_MeasureArea = 159;
    public static final int cmd_NumberObj = 78;
    public static final int cmd_TermObj = 79;
    public static final int cmd_GRichtTerm = 139;
    public static final int cmd_MCreate = 129;
    public static final int cmd_Conic = 221;
    public static final int cmd_EllipseF = 222;
    public static final int cmd_ParabelF = 225;
    public static final int cmd_HyperbelF = 228;
    public static final int cmd_Graph = 230;
    public static final int cmd_ToggleVis = 112;
    public static final int cmd_EditColour = 61;
    public static final int cmd_EditLineStyle = 63;
    public static final int cmd_EditPointStyle = 62;
    public static final int cmd_EditPattern = 64;
    public static final int cmd_EditLocLineStyle = 69;
    public static final int cmd_EditLocLineCurve = 72;
    public static final int cmd_EditLocLineDyna = 70;
    public static final int cmd_EditLocLineAuto = 71;
    public static final int cmd_EditLocLineStnd = 75;
    public static final int cmd_EditTerm = 74;
    public static final int cmd_EditRange = 73;
    public static final int cmd_EditRadius = 65;
    public static final int cmd_EditAngle = 66;
    public static final int cmd_EditFunction = 76;
    public static final int cmd_EditCoords = 67;
    public static final int cmd_RunMakro = 145;
    public static final int cmd_CheckSol = 30;
    public static final int cmd_RunAnimaFD = 215;
    public static final int cmd_StopAnima = 216;
    public static final int cmd_MakeEnvelop = 235;
    public static final int cmd_ReloadDrawing = 512;
    public static final int cmd_RefreshDrawing = 513;
    public static final int cmd_About = 514;
    public static final int cmd_SetNewLineStyle = 1000;
    public static final int cmd_SetNewPointStyle = 1050;
    public static final int cmd_SetNewFillStyle = 1100;
    private Cursor pfeilCursor = null;
    private Cursor handCursor = null;
    private Cursor kreuzCursor = null;
    private Cursor kreukreiCursor = null;
    private Cursor zangeCursor = null;
    private boolean isMoveObjMode = false;
    private Timer aniTimer = null;
    private int aniDelay = 100;
    private double aniStep = 0.01;
    GMapping fLastMapping = null;

    public Controller(DynaGeoJ dynaGeoJ, int newMode) {
        this.mainWindow = dynaGeoJ;
        this.fModus = newMode;
        this.popupMenu = new PopupMenu(this);
    }

    public PopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public DynaGeoJ getMainWindow() {
        return this.mainWindow;
    }

    public void setHasButtons(boolean fHasButtons) {
        this.fHasButtons = fHasButtons;
    }

    public boolean hasButtons() {
        return this.fHasButtons;
    }

    public int getModus() {
        return this.fModus;
    }

    public int getExpectedType() {
        int res = this.inpList.getNextExpectedTypeMask();
        if (res == 0 && this.fModus == 0) {
            res = 1;
        }
        return res;
    }

    public void setActPopupObj(GeoObj apo, int ppx, int ppy) {
        this.popupObj = apo;
        this.lastPopupX = ppx;
        this.lastPopupY = ppy;
    }

    public void afterLoading(int wx, int wy, boolean hasCommands) {
        if (hasCommands) {
            this.mainWindow.resize(wx - 48, wy);
        } else {
            this.mainWindow.resize(wx, wy);
        }
    }

    public boolean registerInpObj(GeoObj obj, double mx, double my) {
        if (obj.isCompatibleTo(this.getExpectedType())) {
            this.inpList.registerNextInputObj(obj);
            this.lastMouseX = mx;
            this.lastMouseY = my;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeCmd() throws BadParameterException {
        boolean reset2dragmode;
        block72: {
            reset2dragmode = true;
            try {
                switch (this.fModus) {
                    case 1: {
                        if (this.popupObj != null) {
                            this.popupObj.moveBy(this.lastMouseX, this.lastMouseY, this.canvas);
                            return true;
                        }
                        break;
                    }
                    case 121: {
                        break;
                    }
                    case 109: {
                        GeoObj cl = this.inpList.get((int)0).go;
                        GPoint ngo = new GPoint(this.drawing, this.lastMouseX, this.lastMouseY, true);
                        this.drawing.insertGO(ngo);
                        ngo.bindToLine((GLineObj)cl);
                        this.drawing.fillDragList(ngo);
                        this.drawing.updateDraggedObjs(ngo, this.lastMouseX, this.lastMouseY);
                        break;
                    }
                    case 133: {
                        GeoObj ego = this.inpList.get((int)0).go;
                        if (ego instanceof GSegment) {
                            GMidPoint ngo = new GMidPoint(this.drawing, ego.getParent(0), ego.getParent(1), true);
                            this.drawing.insertGO(ngo);
                        } else {
                            if (this.inpList.size() < 2) {
                                this.inpList.add(new InpItem(2));
                                return true;
                            }
                            GMidPoint ngo = new GMidPoint(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                            this.drawing.insertGO(ngo);
                        }
                        break;
                    }
                    case 122: {
                        GSegment ngo = new GSegment(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 123: {
                        GLine ngo = new GLine(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 138: {
                        GPerpendicular ngo = new GPerpendicular(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 137: {
                        GParallelLine ngo = new GParallelLine(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 135: {
                        GPerpBisector ngo = new GPerpBisector(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 136: {
                        GBisector ngo = new GBisector(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, this.inpList.get((int)2).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 43: {
                        GRay ngo = new GRay(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 45: {
                        GVector ngo = new GVector(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 124: {
                        GCircle ngo = new GCircle(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 129: {
                        EditTermDialog erd = new EditTermDialog(this.getMainWindow().getContentPane(), 65, Messages.getString("Controller.title_radius"), this.popupObj, this.drawing);
                        String rs = erd.getResult(1);
                        if (rs.length() > 0) {
                            GCircleWDR ngo = new GCircleWDR(this.drawing, this.inpList.get((int)0).go, rs, true);
                            this.drawing.insertGO(ngo);
                        }
                        break;
                    }
                    case 230: {
                        EditTermDialog etd = new EditTermDialog(this.getMainWindow().getContentPane(), 230, Messages.getString("Controller.title_function"), null, this.drawing);
                        String t = etd.getResult(1);
                        if (t.length() > 0) {
                            GGraph ngo = new GGraph(this.drawing, t, true);
                            this.drawing.insertGO(ngo);
                        }
                        break;
                    }
                    case 139: {
                        EditTermDialog etd = new EditTermDialog(this.getMainWindow().getContentPane(), 139, Messages.getString("Controller.title_angle"), null, this.drawing);
                        String t = etd.getResult(1);
                        if (t.length() > 0) {
                            GLineWDD ngo = new GLineWDD(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, t, true);
                            this.drawing.insertGO(ngo);
                        }
                        break;
                    }
                    case 78: {
                        double[] numSpot = this.getFreeNumberSpot();
                        double[] iVals = new double[]{-3.0, 1.0, 5.0};
                        GNumber ngo = new GNumber(this.drawing, iVals, numSpot, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 79: {
                        EditTermDialog etd2 = new EditTermDialog(this.getMainWindow().getContentPane(), 79, Messages.getString("Controller.title_term"), null, this.drawing);
                        String s = etd2.getResult(1);
                        if (s.length() > 0) {
                            double[] numSpot2 = this.getFreeNumberSpot();
                            GTerm ngo = new GTerm(this.drawing, s, numSpot2, true);
                            ngo.setShowsName(etd2.getShowName());
                            ngo.setShowsTerm(etd2.getShowTerm());
                            ((GeoObj)ngo).updateParams(null, 0.0, 0.0);
                            this.drawing.insertGO(ngo);
                        }
                        break;
                    }
                    case 152: {
                        GPoint epo = (GPoint)this.inpList.get((int)0).go;
                        epo.bindToLine((GLineObj)this.inpList.get((int)1).go);
                        this.drawing.fillDragList(epo);
                        this.drawing.updateDraggedObjs(epo, this.lastMouseX, this.lastMouseY);
                        break;
                    }
                    case 153: {
                        GPoint po = (GPoint)this.inpList.get((int)0).go;
                        po.unbindFromLine();
                        this.drawing.fillDragList(po);
                        this.drawing.updateDraggedObjs(po, this.lastMouseX, this.lastMouseY);
                        break;
                    }
                    case 114: {
                        GeoObj obj2del = this.inpList.get((int)0).go;
                        this.drawing.deleteGO(obj2del);
                        break;
                    }
                    case 132: {
                        if (this.inpList.get((int)0).go.isCompatibleTo(32) || this.inpList.get((int)1).go.isCompatibleTo(32)) {
                            if (this.inpList.get((int)0).go.isCompatibleTo(32) && this.inpList.get((int)1).go.isCompatibleTo(32)) {
                                GPointLXL ngo = new GPointLXL(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                                this.drawing.insertGO(ngo);
                            } else {
                                GDoubleIntersection ngo = new GDoubleIntersection(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go);
                                GeoObj ego = this.drawing.insertGO(ngo);
                                this.addIntersectPoints(ego, 2);
                            }
                            break;
                        }
                        if (this.inpList.get((int)0).go.isCompatibleTo(8192) && this.inpList.get((int)1).go.isCompatibleTo(4096) || this.inpList.get((int)0).go.isCompatibleTo(4096) && this.inpList.get((int)1).go.isCompatibleTo(8192) || this.inpList.get((int)0).go.isCompatibleTo(8192) && this.inpList.get((int)1).go.isCompatibleTo(8192)) {
                            GQuadIntersection ngo = new GQuadIntersection(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go);
                            GeoObj ego = this.drawing.insertGO(ngo);
                            this.addIntersectPoints(ego, 4);
                        } else {
                            GDoubleIntersection ngo = new GDoubleIntersection(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go);
                            GeoObj ego = this.drawing.insertGO(ngo);
                            this.addIntersectPoints(ego, 2);
                        }
                        break;
                    }
                    case 156: {
                        GMeasureDistance ngo = this.inpList.get((int)1).go.isCompatibleTo(2) || this.inpList.get((int)1).go.isCompatibleTo(32) && this.inpList.get((int)0).go.isCompatibleTo(4096) ? new GMeasureDistance(this.drawing, this.inpList.get((int)1).go, this.inpList.get((int)0).go, true) : new GMeasureDistance(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 155: {
                        if (this.inpList.get((int)0).go.isCompatibleTo(262144)) {
                            GMeasureAngle ngo = new GMeasureAngle(this.drawing, this.inpList.get((int)0).go, true);
                            this.drawing.insertGO(ngo);
                        } else {
                            if (this.inpList.size() == 1) {
                                this.inpList.add(new InpItem(2));
                                this.inpList.add(new InpItem(2));
                                return true;
                            }
                            GeoObj ngo = new GAngle(this.drawing, this.inpList.get((int)0).go, this.inpList.get((int)1).go, this.inpList.get((int)2).go, false, true);
                            ngo = this.drawing.insertGO(ngo);
                            ngo = new GMeasureAngle(this.drawing, ngo, true);
                            this.drawing.insertGO(ngo);
                        }
                        break;
                    }
                    case 159: {
                        GeoObj ngo;
                        if (this.inpList.get((int)0).go.isCompatibleTo(0x100000)) {
                            ngo = new GMeasureArea(this.drawing, this.inpList.get((int)0).go, true);
                        } else {
                            ngo = new GArea(this.drawing, (GLineObj)this.inpList.get((int)0).go, true);
                            ngo = this.drawing.insertGO(ngo);
                            ngo = new GMeasureArea(this.drawing, ngo, true);
                        }
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 221: {
                        GeoObj[] pts = new GeoObj[5];
                        int i = 0;
                        while (true) {
                            if (i >= 5) {
                                GConic ngo = new GConic(this.drawing, pts, true);
                                this.drawing.insertGO(ngo);
                                break block72;
                            }
                            pts[i] = this.inpList.get((int)i).go;
                            ++i;
                        }
                    }
                    case 222: {
                        GeoObj[] pts3 = new GeoObj[]{this.inpList.get((int)0).go, this.inpList.get((int)1).go, this.inpList.get((int)2).go};
                        GEllipseF ngo = new GEllipseF(this.drawing, pts3, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 225: {
                        GeoObj[] pts2 = new GeoObj[]{this.inpList.get((int)0).go, this.inpList.get((int)1).go};
                        GParabelF ngo = new GParabelF(this.drawing, pts2, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 228: {
                        GeoObj[] pts3a = new GeoObj[]{this.inpList.get((int)0).go, this.inpList.get((int)1).go, this.inpList.get((int)2).go};
                        GHyperbelF ngo = new GHyperbelF(this.drawing, pts3a, true);
                        this.drawing.insertGO(ngo);
                        break;
                    }
                    case 158: 
                    case 235: {
                        reset2dragmode = false;
                        this.resetModus();
                        break;
                    }
                    case 131: {
                        if (this.inpList.objDoubleRegistered()) {
                            int n = this.inpList.size() - 2;
                            GeoObj ngo = new GSegment(this.drawing, this.inpList.get((int)n).go, this.inpList.get((int)0).go, true);
                            this.drawing.insertGO(ngo);
                            ngo = this.drawing.insertGO(new GPolygon(this.drawing, this.inpList));
                            this.drawing.insertGO(new GArea(this.drawing, (GLineObj)ngo, true));
                            break;
                        } else {
                            int n = this.inpList.size() - 1;
                            GSegment ngo = new GSegment(this.drawing, this.inpList.get((int)(n - 1)).go, this.inpList.get((int)n).go, true);
                            this.drawing.insertGO(ngo);
                            this.inpList.add(new InpItem(2));
                            return true;
                        }
                    }
                    case 47: {
                        this.makeMappedObj(1, this.inpList.get((int)0).go, this.inpList.get((int)1).go, null, true);
                        break;
                    }
                    case 49: {
                        this.makeMappedObj(2, this.inpList.get((int)0).go, this.inpList.get((int)1).go, null, true);
                        break;
                    }
                    case 51: {
                        this.makeMappedObj(3, this.inpList.get((int)0).go, this.inpList.get((int)1).go, null, true);
                        break;
                    }
                    case 53: {
                        this.makeMappedObj(4, this.inpList.get((int)0).go, this.inpList.get((int)1).go, this.inpList.get((int)2).go, true);
                        break;
                    }
                    case 55: {
                        this.makeMappedObj(7, this.inpList.get((int)0).go, this.inpList.get((int)1).go, this.inpList.get((int)2).go, true);
                        break;
                    }
                    case 56: {
                        this.makeMappedObj(20, this.inpList.get((int)0).go, this.inpList.get((int)1).go, null, true);
                        break;
                    }
                    case 58: {
                        this.makeMappedObj(0, this.inpList.get((int)0).go, null, null, false);
                        break;
                    }
                    case 90: {
                        EditTextBoxDialog etb_dlg = new EditTextBoxDialog(this.getMainWindow().getContentPane(), null);
                        String tb = etb_dlg.getResult(0);
                        if (tb.length() > 0) {
                            Rectangle r = etb_dlg.getTextRect();
                            Point2D.Double bounds = new Point2D.Double(Math.abs(this.canvas.screenToUserW(r.width)), Math.abs(this.canvas.screenToUserH(r.height)));
                            Point2D.Double pos = new Point2D.Double(this.canvas.screenToUserX(r.x), this.canvas.screenToUserY(r.y));
                            GTextBox ngo = new GTextBox(this.drawing, tb, pos, bounds);
                            this.drawing.insertGO(ngo);
                        }
                        break;
                    }
                    case 215: {
                        if (this.drawing.getAniSource() == null) break;
                        if (this.aniTimer == null) {
                            this.aniTimer = new Timer(215, this);
                            if (this.aniStep < 0.0) {
                                this.aniStep = -this.aniStep;
                            }
                        }
                        this.aniTimer.setDelay(this.aniDelay);
                        if (this.aniTimer.isRunning()) {
                            this.aniTimer.stop();
                            break;
                        } else {
                            ((LocLineController)((Object)this.drawing.getAniSource())).startAnimation();
                            this.aniTimer.start();
                            return true;
                        }
                    }
                    case 104: {
                        this.saveDrawingAs();
                        break;
                    }
                    default: {
                        throw new BadParameterException("fModus", "unknown value " + Integer.toString(this.fModus));
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainWindow, e.getMessage(), "Error", 0);
            }
        }
        if (!reset2dragmode) return true;
        this.mainWindow.reset2DragMode();
        return true;
    }

    private void checkPopup(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.getMainWindow().reset2DragMode();
            this.popupMenu.reset();
            if (this.mousedObj != null) {
                this.setActPopupObj(this.mousedObj, me.getX(), me.getY());
                this.mousedObj.addToContextMenu(this.popupMenu);
            } else {
                this.setActPopupObj(null, me.getX(), me.getY());
                this.drawing.addToContextMenu(this.popupMenu);
            }
            this.popupMenu.show(me.getComponent(), me.getX(), me.getY());
        }
    }

    private double[] getFreeNumberSpot() {
        double[] res = new double[]{0.0, 0.0, 0.0, 0.0};
        CoordsCanvas cc = this.getMainWindow().getCanvas();
        RelationListIterator it = this.drawing.iterator();
        Rectangle2D.Double new_rect = new Rectangle2D.Double(30.0, 20.0, 250.0, 33.0);
        Point2D.Double scr_pt = new Point2D.Double();
        Rectangle2D.Double ex_rect = new Rectangle2D.Double();
        while (it.hasNext()) {
            GeoObj go = it.next();
            if (!(go instanceof GNumber)) continue;
            cc.getScreenPtCoords(((GNumber)go).getx(0), ((GNumber)go).gety(0), scr_pt);
            ex_rect.setRect(scr_pt.x, scr_pt.y, ((GNumber)go).getWidth(), ((GNumber)go).getHeight());
            if (!new_rect.intersects(ex_rect)) continue;
            new_rect.setRect(new_rect.getX(), ex_rect.getY() + (double)((GNumber)go).getHeight() + 8.0, ((GNumber)go).getWidth(), ((GNumber)go).getHeight());
        }
        cc.getUserPtCoords(new_rect.getX(), new_rect.getMinY(), scr_pt);
        res[0] = scr_pt.x;
        res[1] = scr_pt.y;
        cc.getUserPtCoords(new_rect.getX() + new_rect.getWidth(), new_rect.getY() + new_rect.getHeight(), scr_pt);
        res[2] = scr_pt.x;
        res[3] = scr_pt.y;
        return res;
    }

    private void addIntersectPoints(GeoObj go, int cnt) {
        int i = 0;
        while (i < cnt) {
            GIntersectPoint no = new GIntersectPoint(this.drawing, go, i, true);
            this.drawing.insertGO(no);
            ++i;
        }
    }

    private void reloadDrawing() {
        try {
            this.mainWindow.readGeoFile();
            this.mainWindow.reloadButtons();
            this.mainWindow.invalidate();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void refreshDrawing() {
        if (this.canvas != null) {
            this.canvas.installSafeGraphic();
            this.drawing.updateAllObjs();
            this.drawing.drawAllObjs(this.canvas);
            this.canvas.revokeSafeGraphic();
        }
    }

    @Override
    public boolean setModus(int newMode) {
        boolean res = true;
        if (this.fModus == newMode) {
            return res;
        }
        if (this.fModus != 0) {
            this.resetModus();
        }
        if (this.fModus != newMode) {
            this.fModus = newMode;
            if (this.fModus == 0) {
                return res;
            }
            this.mainWindow.getCanvas().startBlinking();
        }
        try {
            switch (this.fModus) {
                case 1: 
                case 78: 
                case 79: 
                case 230: {
                    break;
                }
                case 90: 
                case 104: 
                case 215: {
                    res = this.executeCmd();
                    break;
                }
                case 121: {
                    this.inpList.add(new InpItem(0));
                    break;
                }
                case 109: {
                    this.inpList.add(new InpItem(16));
                    break;
                }
                case 153: {
                    this.inpList.add(new InpItem(4));
                    break;
                }
                case 155: {
                    this.inpList.add(new InpItem(262146));
                    break;
                }
                case 159: {
                    this.inpList.add(new InpItem(0x110000));
                    break;
                }
                case 114: {
                    this.inpList.add(new InpItem(-1));
                    break;
                }
                case 133: {
                    this.inpList.add(new InpItem(66));
                    break;
                }
                case 129: {
                    this.inpList.add(new InpItem(2));
                    break;
                }
                case 158: {
                    this.inpList.add(new InpItem(2));
                    break;
                }
                case 235: {
                    this.inpList.add(new InpItem(512));
                    break;
                }
                case 58: {
                    this.inpList.add(new InpItem(0x100012));
                    break;
                }
                case 43: 
                case 122: 
                case 123: 
                case 124: 
                case 131: 
                case 135: 
                case 139: {
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(2));
                    break;
                }
                case 45: {
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(130));
                    break;
                }
                case 137: 
                case 138: {
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(16));
                    break;
                }
                case 132: {
                    this.inpList.add(new InpItem(16));
                    this.inpList.add(new InpItem(16));
                    break;
                }
                case 156: {
                    this.inpList.add(new InpItem(4130));
                    this.inpList.add(new InpItem(4130));
                    break;
                }
                case 152: {
                    this.inpList.add(new InpItem(1));
                    this.inpList.add(new InpItem(16));
                    break;
                }
                case 225: {
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(16));
                    break;
                }
                case 47: {
                    this.inpList.add(new InpItem(0x100012));
                    this.inpList.add(new InpItem(32));
                    break;
                }
                case 49: {
                    this.inpList.add(new InpItem(0x100012));
                    this.inpList.add(new InpItem(2));
                    break;
                }
                case 56: {
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(4096));
                    break;
                }
                case 51: {
                    this.inpList.add(new InpItem(0x100012));
                    this.inpList.add(new InpItem(128));
                    break;
                }
                case 53: {
                    this.inpList.add(new InpItem(0x100012));
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(0x10040000));
                    break;
                }
                case 55: {
                    this.inpList.add(new InpItem(0x100012));
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(0x10000000));
                    break;
                }
                case 136: 
                case 222: 
                case 228: {
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(2));
                    break;
                }
                case 221: {
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(2));
                    this.inpList.add(new InpItem(2));
                    break;
                }
                default: {
                    throw new BadParameterException("fModus", "unknown value " + Integer.toString(this.fModus));
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainWindow, e.getMessage(), "Error", 0);
            this.mainWindow.reset2DragMode();
            res = false;
        }
        return res;
    }

    @Override
    public void startExecution(int cmdId) {
        try {
            this.fModus = cmdId;
            this.executeCmd();
        }
        catch (BadParameterException e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void resetModus() {
        this.canvas.stopBlinking();
        if (this.fModus == 158 && this.newLocLine == 0) {
            this.newLocLine = 1;
            this.generatorPt = (GPoint)this.inpList.get((int)0).go;
        }
        if (this.fModus == 235 && this.newLocLine == 0) {
            this.newLocLine = 1;
            this.generatorLn = (GLine)this.inpList.get((int)0).go;
        }
        if (this.aniTimer != null) {
            this.aniTimer.stop();
            this.aniTimer = null;
        }
        this.inpList.clear();
        this.popupObj = null;
        this.fModus = 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            this.handlePopupCmd(Integer.parseInt(((JMenuItem)e.getSource()).getActionCommand()));
        } else {
            this.handleAnimationCmd(0);
        }
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        boolean bzf_changed;
        System.out.println("Call to componentResized()");
        System.out.println("Original drawWin : ( " + new Integer(Options.ori_drawWin_width).toString() + " | " + new Integer(Options.ori_drawWin_height).toString() + " )");
        double act_drawWin_width = (double)this.getMainWindow().getWidth() * 1.0;
        if (this.hasButtons()) {
            act_drawWin_width -= 48.0;
        }
        double act_drawWin_height = (double)this.getMainWindow().getHeight() * 1.0;
        System.out.println("Actual drawWin : ( " + new Double(act_drawWin_width).toString() + " | " + new Double(act_drawWin_height).toString() + " )");
        double bzf_rel_change = act_drawWin_width / (double)Options.ori_drawWin_width;
        double cf = bzf_rel_change - 1.0;
        boolean bl = bzf_changed = Math.abs(cf - 1.0) > 0.01;
        if (bzf_changed && this.drawing != null && this.canvas != null) {
            WindowData windat = this.getMainWindow().windowdata;
            windat.zoom(act_drawWin_width, act_drawWin_height);
            this.canvas.setWindow(windat);
            this.drawing.resize(this.canvas);
            Options.ori_drawWin_width = (int)act_drawWin_width;
            Options.ori_drawWin_height = (int)act_drawWin_height;
            this.getMainWindow().invalidate();
            System.out.println("Zoomed with factor bzf = " + new Double(bzf_rel_change).toString());
        } else {
            System.out.println("No zoom performed!");
        }
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getButton() == 1) {
            int expType = this.getExpectedType();
            double umx = this.canvas.screenToUserX(me.getX());
            double umy = this.canvas.screenToUserY(me.getY());
            double minDist = this.canvas.screenToUserW(5);
            if (this.mousedObj == null) {
                this.mousedObj = this.drawing.getMousedObj(expType, umx, umy, minDist);
            }
            if (this.getModus() != 0) {
                if (this.mousedObj != null) {
                    this.registerInpObj(this.mousedObj, umx, umy);
                } else if ((expType & 2) == 2 || this.getModus() == 121) {
                    GPoint po = (GPoint)this.drawing.insertGO(new GPoint(this.drawing, umx, umy, true));
                    this.registerInpObj(po, umx, umy);
                }
                expType = this.getExpectedType();
                if (expType == 0) {
                    try {
                        this.executeCmd();
                    }
                    catch (BadParameterException e) {
                        System.err.println(e.getMessage());
                    }
                    this.canvas.setCursor(this.pfeilCursor);
                    this.canvas.repaint();
                }
            }
        }
        this.canvas.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.canvas.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.last_x = me.getX();
        this.last_y = me.getY();
        double umx = this.canvas.screenToUserX(this.last_x);
        double umy = this.canvas.screenToUserY(this.last_y);
        boolean bl = this.isMoveObjMode = this.mousedObj != null && (this.mousedObj.isCompatibleTo(0x1000000) || this.mousedObj.isCompatibleTo(0x10000000) && this.mousedObj.dist(umx, umy) < 0.0 || this.mousedObj instanceof GArea && ((GArea)this.mousedObj).canMoveFree());
        if (this.newLocLine == 1 && this.mousedObj != null) {
            if (this.generatorPt != null) {
                this.recordingTr = new GTrace(this.drawing, this.generatorPt, this.mousedObj);
            } else if (this.generatorLn != null) {
                this.recordingTr = new GEnvelope(this.drawing, this.generatorLn, this.mousedObj);
            }
            if (this.recordingTr != null) {
                this.drawing.insertGO(this.recordingTr);
                this.drawing.fillDragList(this.mousedObj);
                this.newLocLine = 2;
            } else {
                this.resetModus();
            }
        } else {
            if (this.mousedObj == null) {
                int expType = this.getExpectedType();
                double minDist = this.canvas.screenToUserW(5);
                this.mousedObj = this.drawing.getMousedObj(expType, umx, umy, minDist);
            }
            if (this.mousedObj != null && this.mousedObj.getClass() == GNumber.class && this.mousedObj.getShape() == 2) {
                GNumber numObj = (GNumber)this.mousedObj;
                if (Math.abs(numObj.getLastDist() + 1.0E-10) < 1.0E-12) {
                    numObj.incrementVal();
                } else if (Math.abs(numObj.getLastDist() + 2.0E-10) < 1.0E-12) {
                    numObj.decrementVal();
                }
                this.drawing.updateAllChildrenOf(numObj, umx, umy);
                this.canvas.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.getButton() == 3) {
            this.mousedObj = this.drawing.getContextObj(this.canvas.screenToUserX(me.getX()), this.canvas.screenToUserY(me.getY()), this.canvas.screenToUserW(5));
        }
        this.checkPopup(me);
        if (this.newLocLine == 2) {
            this.recordingTr.stopRecording(this.canvas);
            this.recordingTr = null;
            this.generatorPt = null;
            this.generatorLn = null;
            this.newLocLine = 0;
            this.canvas.repaint();
            this.mainWindow.reset2DragMode();
        }
        this.mousedObj = null;
        this.drawing.clearDragList();
        this.isMoveObjMode = false;
    }

    @Override
    public final void mouseDragged(MouseEvent me) {
        int last_dx = me.getX() - this.last_x;
        int last_dy = me.getY() - this.last_y;
        this.last_x = me.getX();
        this.last_y = me.getY();
        if (this.mousedObj == null && (me.getModifiers() & 1) != 0 || this.mousedObj != null && this.mousedObj.getClass().equals(GOrigin.class)) {
            this.canvas.moveScreenOri(last_dx, last_dy);
            this.drawing.resize(this.canvas);
        } else if (this.getModus() == 0 && this.mousedObj != null) {
            if (this.isMoveObjMode) {
                this.mousedObj.moveBy(this.canvas.screenToUserW(last_dx), this.canvas.screenToUserH(last_dy), this.canvas);
            } else {
                this.drawing.fillDragList(this.mousedObj);
                this.drawing.updateDraggedObjs(this.mousedObj, this.canvas.screenToUserX(this.last_x), this.canvas.screenToUserY(this.last_y));
            }
        }
        this.canvas.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        int expType = this.getExpectedType();
        double mx = this.canvas.screenToUserX(me.getX());
        double my = this.canvas.screenToUserY(me.getY());
        double min_d = this.canvas.screenToUserW(5);
        this.mousedObj = this.drawing.getMousedObj(expType, mx, my, min_d);
        if (this.mousedObj != null) {
            if (this.getModus() == 0) {
                if (this.mousedObj.getClass().equals(GOrigin.class)) {
                    this.canvas.setCursor(this.handCursor);
                } else if (this.mousedObj.getClass() == GNumber.class && this.mousedObj.getShape() == 2 && this.mousedObj.dist(mx, my) < 0.0) {
                    this.canvas.setCursor(this.pfeilCursor);
                } else {
                    this.canvas.setCursor(this.zangeCursor);
                }
            } else {
                this.canvas.setCursor(this.kreukreiCursor);
            }
        } else if (this.getModus() == 0) {
            if ((me.getModifiers() & 1) != 0) {
                this.canvas.setCursor(this.handCursor);
            } else {
                this.mousedObj = this.drawing.getMovableObj(mx, my);
                if (this.mousedObj != null) {
                    this.canvas.setCursor(this.handCursor);
                } else {
                    this.canvas.setCursor(this.pfeilCursor);
                }
            }
        } else {
            this.canvas.setCursor(this.kreuzCursor);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent me) {
        double zf = Math.pow(1.05, me.getWheelRotation());
        this.canvas.zoom(zf);
    }

    public void registerCursorsAndCanvas(CoordsCanvas coca) {
        this.canvas = coca;
        this.initCursors();
    }

    public Cursor getPfeilCursor() {
        return this.pfeilCursor;
    }

    public void registerObjList(GeoObjList objList) {
        this.drawing = objList;
    }

    private Cursor createMyCustomCursor(Point hotspot, String picfile, String cname) {
        ImageIcon img = new ImageIcon(CoordsCanvas.class.getClassLoader().getResource("graphics/cursors/" + picfile));
        Image curpic = img.getImage();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Cursor newCursor = tk.createCustomCursor(curpic, hotspot, cname);
        return newCursor;
    }

    private void initCursors() {
        this.handCursor = this.createMyCustomCursor(new Point(10, 2), "hand.png", "handCursor");
        this.zangeCursor = this.createMyCustomCursor(new Point(2, 15), "zange.png", "zangeCursor");
        this.kreuzCursor = this.createMyCustomCursor(new Point(15, 15), "kreuz.png", "kreuzCursor");
        this.kreukreiCursor = this.createMyCustomCursor(new Point(15, 15), "kreukrei.png", "kreukreiCursor");
        this.pfeilCursor = this.createMyCustomCursor(new Point(2, 0), "pfeil.png", "pfeilCursor");
    }

    private void saveDrawingAs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setFileFilter(new GeoFileFilter());
        int returnVal = chooser.showSaveDialog(this.mainWindow);
        if (returnVal == 0) {
            try {
                DynaGeoFileIO f = this.getMainWindow().getFileIO();
                f.updateWindowData(this.canvas);
                FileOutputStream fout = new FileOutputStream(chooser.getSelectedFile().getPath());
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                f.createDomDocFromObjects(this.drawing);
                f.writeDOMDataToFileStream(bout);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private void handlePopupCmd(int cmd) {
        boolean shouldReset = true;
        switch (cmd) {
            case 514: {
                AboutDialog.showAboutDlg(this.mainWindow);
                break;
            }
            case 112: {
                this.popupObj.setVisible(false);
                break;
            }
            case 118: {
                if (this.drawing.getVisGroups().getStaticCount() > 0) {
                    new EditVisibilityDialog(this.mainWindow, this.drawing);
                    this.refreshDrawing();
                    break;
                }
                String s = String.valueOf(Messages.getString("Controller.mess_10")) + Messages.getString("Controller.mess_11");
                int n = JOptionPane.showConfirmDialog(null, s, s, 0);
                if (n != 0) break;
                this.drawing.makeAllObjsVisible();
                break;
            }
            case 61: {
                new ColorSettingsDialog(this.popupObj);
                break;
            }
            case 62: {
                PointsMenu pm = new PointsMenu(this);
                pm.show(this.getMainWindow().getComponent(0), this.lastPopupX, this.lastPopupY);
                shouldReset = false;
                break;
            }
            case 63: {
                LinesMenu lm = new LinesMenu(this);
                lm.show(this.getMainWindow().getComponent(0), this.lastPopupX, this.lastPopupY);
                shouldReset = false;
                break;
            }
            case 64: {
                FillMenu fm = new FillMenu(this);
                fm.show(this.getMainWindow().getComponent(0), this.lastPopupX, this.lastPopupY);
                shouldReset = false;
                break;
            }
            case 113: {
                while (this.popupObj.getClass().equals(GArea.class) || this.popupObj.getClass().equals(GObjectName.class)) {
                    this.popupObj = this.popupObj.getParent(0);
                }
                new EditNameDialog(this.mainWindow, this.popupObj);
                break;
            }
            case 152: {
                this.fModus = 152;
                this.inpList.add(new InpItem(2, this.popupObj));
                this.inpList.add(new InpItem(16));
                shouldReset = false;
                break;
            }
            case 153: {
                ((GPoint)this.popupObj).unbindFromLine();
                break;
            }
            case 114: {
                this.fModus = 114;
                this.inpList.add(new InpItem(-1));
                shouldReset = false;
                break;
            }
            case 115: {
                this.mainWindow.getCanvas().zoom(MyMath.sqrt2);
                break;
            }
            case 116: {
                this.mainWindow.getCanvas().zoom(1.0 / MyMath.sqrt2);
                break;
            }
            case 65: {
                new EditTermDialog(this.getMainWindow().getContentPane(), 65, Messages.getString("Controller.title_editradius"), this.popupObj, this.drawing);
                break;
            }
            case 73: {
                new EditNumberDialog(this.getMainWindow().getContentPane(), Messages.getString("Controller.title_editnumber"), this.popupObj);
                break;
            }
            case 74: {
                new EditTermDialog(this.getMainWindow().getContentPane(), 74, Messages.getString("Controller.title_editterm"), this.popupObj, this.drawing);
                break;
            }
            case 76: {
                new EditTermDialog(this.getMainWindow().getContentPane(), 76, Messages.getString("Controller.title_editfunction"), this.popupObj, this.drawing);
                break;
            }
            case 67: {
                new EditTermDialog(this.getMainWindow().getContentPane(), 67, Messages.getString("Controller.title_editcoords"), this.popupObj, this.drawing);
                break;
            }
            case 90: {
                new EditTextBoxDialog(this.getMainWindow().getContentPane(), (GTextBox)this.popupObj);
                break;
            }
            case 512: {
                this.reloadDrawing();
                break;
            }
            case 513: {
                this.refreshDrawing();
                break;
            }
            case 104: {
                this.saveDrawingAs();
                break;
            }
            default: {
                if (cmd >= 1010 && cmd <= 1015) {
                    int new_ls = cmd - 1000;
                    ((GLineObj)this.popupObj).setLineStyle(new_ls);
                    break;
                }
                if (cmd >= 1080 && cmd <= 1089) {
                    int new_ps = cmd - 1050;
                    ((GPoint)this.popupObj).setPointStyle(new_ps);
                    break;
                }
                if (cmd >= 1100 && cmd <= 1108) {
                    int new_fs = cmd - 1100;
                    ((GArea)this.popupObj).setFillStyle(new_fs);
                    break;
                }
                JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(Messages.getString("Controller.mess_01")) + Integer.toString(cmd) + Messages.getString("Controller.mess_02"), Messages.getString("Controller.mess_03"), 0);
            }
        }
        if (shouldReset) {
            if (this.popupObj != null) {
                this.drawing.fillDragList(this.popupObj);
                this.drawing.updateDraggedObjs(null, 0.0, 0.0);
            }
            this.resetModus();
        }
    }

    private void handleAnimationCmd(int cmd) {
        double old_pos = ((LocLineController)((Object)this.drawing.getAniSource())).getLinePosition();
        double new_pos = old_pos + this.aniStep;
        LocLineController ll_ctrl = (LocLineController)((Object)this.drawing.getAniSource());
        if (ll_ctrl.setLinePosition(new_pos)) {
            this.drawing.fillDragList(this.drawing.getAniSource());
            this.drawing.updateDraggedObjs(null, 0.0, 0.0);
            this.getMainWindow().repaint();
        } else {
            this.getMainWindow().reset2DragMode();
        }
    }

    private GMapping getMappingWith(int map_Type, GeoObj defObj1, GeoObj defObj2) {
        GMapping res;
        if (map_Type == 3) {
            defObj1 = ((GVector)defObj1).getAncestorVector();
        }
        if ((res = this.drawing.getTransformationWith(map_Type, defObj1, defObj2)) == null) {
            res = map_Type == 20 ? (GMapping)this.drawing.insertGO(new GInversion(this.drawing, defObj1)) : (GMapping)this.drawing.insertGO(new GSimiliarity(this.drawing, map_Type, defObj1, defObj2));
        }
        return res;
    }

    private void showTrace(GPoint p1, GPoint p2) {
        GLineObj s = null;
        switch (this.fLastMapping.getMapType()) {
            case 1: 
            case 2: 
            case 7: 
            case 20: {
                s = (GLineObj)this.drawing.insertGO(new GSegment(this.drawing, p1, p2, false));
                break;
            }
            case 3: {
                s = (GLineObj)this.drawing.insertGO(new GVector(this.drawing, p1, p2, false));
                break;
            }
            case 4: {
                s = (GLineObj)this.drawing.insertGO(new GArc(this.drawing, p1, this.fLastMapping.getParent(0), p2, false, false));
            }
        }
        if (s != null) {
            s.setLineStyle(14);
            s.setVisible(true);
        }
    }

    private GPoint createMappedPoint(GPoint sourcePt, boolean withTraces) {
        GMappedPoint mappedPt = new GMappedPoint(this.drawing, sourcePt, this.fLastMapping, true);
        mappedPt = (GMappedPoint)this.drawing.insertGO(mappedPt);
        if (withTraces) {
            this.showTrace(sourcePt, mappedPt);
        }
        mappedPt.setVisible(true);
        return mappedPt;
    }

    private void createMappedStraightLine(GLine sourceLine, boolean withTraces) {
        if (this.fLastMapping.getMapType() != 20) {
            GPoint p1 = (GPoint)sourceLine.getParent(0);
            GPoint p2 = null;
            GeoObj p2v = sourceLine.getParent(1);
            if (p2v instanceof GPoint) {
                p2 = (GPoint)p2v;
            } else {
                GMapping a = (GMapping)this.drawing.insertGO(new GSimiliarity(this.drawing, 3, p2v, null));
                p2 = (GPoint)this.drawing.insertGO(new GMappedPoint(this.drawing, p1, a, false));
            }
            GPoint bp1 = (GPoint)this.drawing.insertGO(new GMappedPoint(this.drawing, p1, this.fLastMapping, p1.isVisible()));
            GPoint bp2 = (GPoint)this.drawing.insertGO(new GMappedPoint(this.drawing, p2, this.fLastMapping, p2.isVisible()));
            GLine bl = sourceLine instanceof GSegment ? (sourceLine instanceof GVector ? new GVector(this.drawing, bp1, bp2, true) : new GSegment(this.drawing, bp1, bp2, true)) : (sourceLine instanceof GPerpBisector ? new GPerpBisector(this.drawing, bp1, bp2, true) : new GLine(this.drawing, bp1, bp2, true));
            bl = (GLine)this.drawing.insertGO(bl);
            bl.setVisible(true);
            if (withTraces) {
                if (p1.isVisible() && bp1.isVisible()) {
                    this.showTrace(p1, bp1);
                }
                if (p2.isVisible() && bp2.isVisible()) {
                    this.showTrace(p2, bp2);
                }
            }
        } else {
            GMappedCircle mc = new GMappedCircle(this.drawing, sourceLine, this.fLastMapping, true);
            mc = (GMappedCircle)this.drawing.insertGO(mc);
            mc.setVisible(true);
        }
    }

    private void createMappedCircle(GCircle sourceLine, boolean withTraces) {
        GeoObj mc;
        if (this.fLastMapping.getMapType() <= 8) {
            if (sourceLine.getClass() == GCircle.class) {
                this.createMappedPoint((GPoint)sourceLine.getParent(0), withTraces);
                this.createMappedPoint((GPoint)sourceLine.getParent(1), withTraces);
                mc = new GMappedCircle(this.drawing, sourceLine, this.fLastMapping, true);
                mc = this.drawing.insertGO(mc);
            } else if (sourceLine.getClass() == GArc.class) {
                GPoint p1 = this.createMappedPoint((GPoint)sourceLine.getParent(0), withTraces);
                GPoint p2 = this.createMappedPoint((GPoint)sourceLine.getParent(1), withTraces);
                GPoint p3 = this.createMappedPoint((GPoint)sourceLine.getParent(2), withTraces);
                boolean revers = ((GArc)sourceLine).getReversed() ^ this.fLastMapping.isReversing();
                mc = this.drawing.insertGO(new GArc(this.drawing, p2, p1, p3, revers, true));
            } else {
                mc = new GMappedCircle(this.drawing, sourceLine, this.fLastMapping, true);
                mc = this.drawing.insertGO(mc);
            }
        } else {
            mc = this.fLastMapping.getMapType() == 20 ? this.drawing.insertGO(new GMappedCircle(this.drawing, sourceLine, this.fLastMapping, true)) : this.drawing.insertGO(new GMappedCircle(this.drawing, sourceLine, this.fLastMapping, true));
        }
        mc.setVisible(true);
    }

    private void createMappedPolygon(GPolygon sourceLine, boolean withTraces) {
        if (this.fLastMapping.getMapType() < 20) {
            if (sourceLine.getClass() == GPolygon.class) {
                int cnt = sourceLine.getParentCount();
                InpItemList mpList = new InpItemList();
                int i = 0;
                while (i < cnt) {
                    GPoint mp = this.createMappedPoint((GPoint)sourceLine.getParent(i), withTraces);
                    mpList.add(new InpItem(0, mp));
                    ++i;
                }
                mpList.add(mpList.get(0));
                i = 1;
                while (i <= cnt) {
                    this.drawing.insertGO(new GSegment(this.drawing, mpList.get((int)(i - 1)).go, mpList.get((int)i).go, true));
                    ++i;
                }
                GPolygon newpoly = (GPolygon)this.drawing.insertGO(new GPolygon(this.drawing, mpList));
                if (sourceLine.isFilled()) {
                    this.drawing.insertGO(new GArea(this.drawing, newpoly, true));
                }
            } else {
                int cnt = ((GRegPoly)sourceLine).getVCount();
                GMappedRegPoly newpoly = new GMappedRegPoly(this.drawing, (GRegPoly)sourceLine, this.fLastMapping);
                this.drawing.insertGO(newpoly);
                if (sourceLine.isFilled()) {
                    this.drawing.insertGO(new GArea(this.drawing, newpoly, true));
                }
                int i = 0;
                while (i < cnt) {
                    GVertex vp = new GVertex(this.drawing, newpoly, i, true);
                    this.drawing.insertGO(vp);
                    ++i;
                }
                i = 1;
                while (i <= cnt) {
                    this.drawing.insertGO(new GSegment(this.drawing, newpoly.getChild(i - 1), newpoly.getChild(i % cnt), true));
                    ++i;
                }
                if (withTraces) {
                    i = 0;
                    while (i < cnt) {
                        GSegment ns = new GSegment(this.drawing, sourceLine.getChild(i), newpoly.getChild(i), true);
                        ns.setLineStyle(14);
                        this.drawing.insertGO(ns);
                        ++i;
                    }
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(Messages.getString("Controller.mess_04")) + sourceLine.getName() + Messages.getString("Controller.mess_05") + Messages.getString("Controller.mess_06"), Messages.getString("Controller.mess_07"), 0);
        }
    }

    private void createMappedArea(GArea source, boolean withTraces) {
        if (source.getParentCount() == 1) {
            GLineObj edge = (GLineObj)source.getParent(0);
            if (edge instanceof GPolygon) {
                this.createMappedPolygon((GPolygon)edge, withTraces);
            } else if (edge instanceof GCircle) {
                this.createMappedCircle((GCircle)edge, withTraces);
            }
        } else {
            JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(Messages.getString("Controller.mess_04")) + source.getName() + Messages.getString("Controller.mess_09"), Messages.getString("Controller.mess_07"), 0);
        }
    }

    private void createMappedCurve(GCurve sourceLine, boolean withTraces) {
    }

    private void makeMappedObj(int map_Type, GeoObj oriObj, GeoObj mapDefObj1, GeoObj mapDefObj2, boolean withTraces) {
        if (map_Type >= 1 && map_Type <= 8 || map_Type == 20) {
            this.fLastMapping = this.getMappingWith(map_Type, mapDefObj1, mapDefObj2);
        }
        if (this.fLastMapping != null) {
            if (oriObj.isCompatibleTo(2)) {
                this.createMappedPoint((GPoint)oriObj, withTraces);
            } else if (oriObj.isCompatibleTo(32)) {
                this.createMappedStraightLine((GLine)oriObj, withTraces);
            } else if (oriObj.isCompatibleTo(4096)) {
                this.createMappedCircle((GCircle)oriObj, withTraces);
            } else if (oriObj.isCompatibleTo(131072)) {
                this.createMappedPolygon((GPolygon)oriObj, withTraces);
            } else if (oriObj.isCompatibleTo(0x100000)) {
                this.createMappedArea((GArea)oriObj, withTraces);
            } else if (oriObj.isCompatibleTo(40960)) {
                this.createMappedCurve((GCurve)oriObj, withTraces);
            } else {
                JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(Messages.getString("Controller.mess_04")) + oriObj.getName() + Messages.getString("Controller.mess_09"), Messages.getString("Controller.mess_07"), 0);
            }
        }
    }
}

