/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.BadParameterException;
import applet.ControlPanel;
import applet.Controller;
import applet.Options;
import canvas.CoordsCanvas;
import geoobj.GeoObjList;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import xml.DynaGeoFileIO;
import xml.HeaderData;
import xml.WindowData;

public class DynaGeoJ
extends JApplet
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final String APPLET_INFO_STRING = "DynaGeoJ applet, v 1.5.2.0, (c) Info-Kurse Oken 2005-2011 & Roland Mechling 2004-2014";
    private static final String[][] APPLET_PARAMETER_INFO = new String[][]{{"width", "int-string", "width of applet window, obligatory, internal"}, {"height", "int-string", "height of applet window, obligatory, internal"}, {"geofile", "url or path", "drawing to present, obligatory, external"}, {"language_id", "string", "NLS language id ('xx'), optional, external"}};
    private ControlPanel controlPanel;
    private Controller brains = new Controller(this, 0);
    private CoordsCanvas canvas = new CoordsCanvas(this.brains);
    private GeoObjList objects;
    private HeaderData headerdata;
    private DynaGeoFileIO fileIO;
    private String filename;
    public WindowData windowdata;

    @Override
    public void init() {
        System.out.println("Start DynaGeoJ.init().");
        Options.init(this);
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println("Warning: Unsupported Look and Feel: " + laf);
        }
        catch (Exception e) {
            System.err.println("Error loading " + laf + ": " + e);
        }
        Container cp = this.getContentPane();
        cp.setLayout(new BoxLayout(cp, 0));
        try {
            this.readGeoFile();
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception e_) {
            final Exception e = e_;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DynaGeoJ.this.createErrorGUI(e);
                    }
                });
            }
            catch (Exception e__) {
                System.err.println(e__.getMessage());
            }
        }
        System.out.println("Finished DynaGeoJApplet.init().");
    }

    @Override
    public void run() {
        this.createGUI();
    }

    @Override
    public String getAppletInfo() {
        return APPLET_INFO_STRING;
    }

    public Controller getBrains() {
        return this.brains;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public CoordsCanvas getCanvas() {
        return this.canvas;
    }

    public DynaGeoFileIO getFileIO() {
        return this.fileIO;
    }

    public void reloadButtons() {
        if (this.controlPanel != null) {
            this.controlPanel.reloadButtons(this.headerdata.getCommandIDs().iterator(), this.brains);
        }
    }

    public void reset2DragMode() {
        if (this.controlPanel != null) {
            this.controlPanel.resetAllButtons();
        }
        this.brains.resetModus();
        this.canvas.setCursor(this.brains.getPfeilCursor());
    }

    @Override
    public String[][] getParameterInfo() {
        return APPLET_PARAMETER_INFO;
    }

    public void readGeoFile() throws BadParameterException, MalformedURLException, IOException {
        URL url;
        this.filename = this.getParameter("geofile");
        if (this.filename == null) {
            throw new BadParameterException("geofile", "Parameter is empty");
        }
        if (this.filename.startsWith("http")) {
            url = new URL(this.filename);
        } else {
            StringBuilder path = new StringBuilder(this.getDocumentBase().toString());
            System.out.println("DocBasePath = " + path);
            int n = path.lastIndexOf("/");
            path.delete(n + 1, path.length());
            StringBuilder fname = new StringBuilder(this.filename);
            n = fname.lastIndexOf("\"");
            while (n >= 0) {
                fname.setCharAt(n, '/');
                n = fname.lastIndexOf("\"");
            }
            while (fname.toString().startsWith("/")) {
                fname.deleteCharAt(0);
            }
            path.append((CharSequence)fname);
            url = new URL(path.toString());
        }
        System.out.println("Try to load GEO file : " + url.toString());
        this.doLoadGeoFile(url);
        System.out.println("Successfully loaded GEO file.");
    }

    private void createGUI() {
        System.out.println("Started createGUI().");
        this.getRootPane().setDoubleBuffered(true);
        Container cp = this.getContentPane();
        this.brains.registerCursorsAndCanvas(this.canvas);
        if (this.headerdata != null && this.headerdata.getCommandIDs().size() > 0) {
            this.controlPanel = new ControlPanel(48, this.getHeight(), this.headerdata.getCommandIDs().iterator());
            cp.add(this.controlPanel);
            this.controlPanel.initButtons(this.brains);
        } else {
            this.brains.setHasButtons(false);
        }
        cp.add(this.canvas);
        this.addComponentListener(this.brains);
        System.out.println("Finished createGUI().");
    }

    private void createErrorGUI(Exception e) {
        e.printStackTrace();
        Container cp = this.getContentPane();
        cp.setLayout(new BoxLayout(cp, 1));
        JLabel hdrLbl = new JLabel("   An error occured [ " + e.getClass().getName() + " ] :");
        hdrLbl.setAlignmentX(0.0f);
        cp.add(hdrLbl);
        StringBuilder s = new StringBuilder(e.getMessage());
        int n = s.indexOf("(");
        if (n > 0) {
            String s1 = s.substring(0, n);
            String s2 = s.substring(n, s.length());
            cp.add(new JLabel("        \"" + s1));
            cp.add(new JLabel("         " + s2 + "\""));
        } else {
            cp.add(new JLabel("         " + s));
        }
        Throwable t = e.getCause();
        while (t != null) {
            cp.add(new JLabel("(Caused by " + this.composeExceptionDescription(t) + ")"));
            t = t.getCause();
        }
    }

    private String composeExceptionDescription(Throwable t) {
        return "\"" + t.getMessage() + "\"";
    }

    private boolean fileIsNewEnough(String ed_prog, String ed_vers) {
        boolean res = false;
        String[] vs = new String[4];
        vs = ed_vers.split("[.]");
        int[] vn = new int[4];
        int i = 0;
        while (i < vs.length) {
            vn[i] = Integer.parseInt(vs[i]);
            ++i;
        }
        if (ed_prog.equals("DynaGeoJ") && (vn[0] > 0 || vn[0] == 0 && vn[1] == 9 && vn[2] == 9 && vn[3] >= 7)) {
            res = true;
        } else if (ed_prog.contains("DynaGeo") && (vn[0] > 3 || vn[0] == 3 && vn[1] > 2 || vn[0] == 3 && vn[1] == 2 && vn[2] > 0 || vn[0] == 3 && vn[1] == 2 && vn[2] == 0 && vn[3] >= 240)) {
            res = true;
        }
        return res;
    }

    private void doLoadGeoFile(URL url) throws IOException, BadParameterException {
        double act_drawWin_width;
        this.objects = null;
        InputStream is = url.openStream();
        this.fileIO = new DynaGeoFileIO(is);
        this.headerdata = this.fileIO.getHeaderData();
        String hd_ed_vers = "0.0.0.0";
        if (this.headerdata != null && this.headerdata.getEditedVersion().length() > 0) {
            hd_ed_vers = this.headerdata.getEditedVersion();
        }
        if (this.fileIsNewEnough(this.headerdata.getEditedName(), hd_ed_vers)) {
            this.windowdata = this.fileIO.getWindowData();
            act_drawWin_width = (double)this.getWidth() * 1.0;
            if (this.getBrains().hasButtons()) {
                act_drawWin_width -= 48.0;
            }
        } else {
            System.out.println("This GEO file's version is \"" + hd_ed_vers + "\", " + "but the earliest version admitted is \"3.2.0.240\" !");
            throw new BadParameterException("geofile", "has wrong version " + hd_ed_vers + ", should have at least 3.2.0.240 !");
        }
        double act_drawWin_height = (double)this.getHeight() * 1.0;
        this.windowdata.zoom(act_drawWin_width, act_drawWin_height);
        System.out.println("Actual draw window =  ( " + new Double(act_drawWin_width).toString() + " | " + new Double(act_drawWin_height).toString() + " )");
        this.objects = this.fileIO.getObjectList();
        this.canvas.setWindow(this.windowdata);
        this.canvas.setObjectList(this.objects);
        this.brains.registerObjList(this.objects);
        this.objects.afterLoading(this.canvas);
        this.objects.getVisGroups().updateVisMask();
    }
}

