/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.Messages;
import geoobj.GObjectName;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class EditNameDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private GeoObj actObj;
    private JTextField tf;
    private JCheckBox sn;
    private JOptionPane optionPane;

    public EditNameDialog(Component owner, GeoObj geoObj) {
        super(JOptionPane.getFrameForComponent(owner), Messages.getString("EditNameDialog.title"), true);
        this.actObj = geoObj;
        JPanel win = new JPanel(new BorderLayout(0, 3));
        this.tf = new JTextField(geoObj.getName());
        win.add((Component)this.tf, "North");
        this.sn = new JCheckBox(Messages.getString("EditNameDialog.sn_capt"), true);
        win.add((Component)this.sn, "South");
        Object[] options = new Object[]{Messages.getString("EditNameDialog.okbtn_capt"), Messages.getString("EditNameDialog.cancelbtn_capt")};
        this.optionPane = new JOptionPane(win, -1, 2, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                EditNameDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                EditNameDialog.this.tf.requestFocusInWindow();
            }
        });
        this.tf.addActionListener(this);
        this.optionPane.addPropertyChangeListener(this);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.optionPane.setValue(Messages.getString("EditNameDialog.okbtn_capt"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (value.equals(Messages.getString("EditNameDialog.okbtn_capt"))) {
                String nn = this.tf.getText();
                int n = this.actObj.setName(nn);
                switch (n) {
                    case 0: {
                        if (this.sn.isSelected() && !this.actObj.hasNameObj()) {
                            GeoObjList list = this.actObj.getDrawing();
                            list.insertGO(new GObjectName(list, this.actObj));
                        }
                        this.clearAndHide();
                        break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(this, String.valueOf(Messages.getString("EditNameDialog.mess_01")) + nn + Messages.getString("EditNameDialog.mess_02") + Messages.getString("EditNameDialog.mess_03") + Messages.getString("EditNameDialog.mess_04"), Messages.getString("EditNameDialog.mess_05"), 0);
                        this.tf.selectAll();
                        this.tf.requestFocusInWindow();
                        break;
                    }
                    case -2: {
                        JOptionPane.showMessageDialog(this, String.valueOf(Messages.getString("EditNameDialog.mess_06")) + Messages.getString("EditNameDialog.mess_07"), Messages.getString("EditNameDialog.mess_08"), 0);
                        this.tf.requestFocusInWindow();
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(this, String.valueOf(Messages.getString("EditNameDialog.mess_09")) + nn + Messages.getString("EditNameDialog.mess_10") + Messages.getString("EditNameDialog.mess_11") + Messages.getString("EditNameDialog.mess_12"), Messages.getString("EditNameDialog.mess_13"), 0);
                        this.tf.setSelectionStart(n);
                        this.tf.setSelectionEnd(n + 1);
                        this.tf.requestFocusInWindow();
                        break;
                    }
                }
            } else {
                this.clearAndHide();
            }
        }
    }

    public void clearAndHide() {
        this.tf.setText(null);
        this.setVisible(false);
    }
}

