/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.Messages;
import geoobj.GNumber;
import geoobj.GeoObj;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import terms.TermTree;

public class EditNumberDialog
extends JDialog
implements PropertyChangeListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private GNumber actNumber = null;
    private JTextField tfval = null;
    private JTextField tfmin = null;
    private JTextField tfmax = null;
    private Checkbox cbisqua = null;
    private JTextField tfquant = null;
    private JOptionPane optionPane = null;
    private double newMin = -3.0;
    private double newVal = 1.0;
    private double newMax = 5.0;
    private double newQuant = 0.0;

    public EditNumberDialog(Component owner, String title, GeoObj geoObj) {
        super(JOptionPane.getFrameForComponent(owner), title, true);
        this.actNumber = (GNumber)geoObj;
        this.newMin = this.actNumber.getValue(6);
        this.newVal = this.actNumber.getValue(0);
        this.newMax = this.actNumber.getValue(7);
        this.newQuant = this.actNumber.getValue(8);
        JPanel win = new JPanel(new GridLayout(0, 3, 20, 10));
        JPanel labmin = this.getLabeledTextField(Messages.getString("EditNumberDialog.labmin_capt"), 1, this.newMin);
        win.add(labmin);
        JPanel labval = this.getLabeledTextField(Messages.getString("EditNumberDialog.labact_capt"), 2, this.newVal);
        win.add(labval);
        JPanel labmax = this.getLabeledTextField(Messages.getString("EditNumberDialog.labmax_capt"), 3, this.newMax);
        win.add(labmax);
        JPanel labisqua = this.getLabeledCheckBox(Messages.getString("EditNumberDialog.labisqua_capt"), 4, this.newQuant > 0.0);
        win.add(labisqua);
        JPanel labquant = this.getLabeledTextField(Messages.getString("EditNumberDialog.labquant_capt"), 5, this.newQuant);
        win.add(labquant);
        this.cbisqua.addItemListener(this);
        this.tfquant.setEditable(this.cbisqua.getState());
        Object[] options = new Object[]{Messages.getString("EditNumberDialog.okbtn_capt"), Messages.getString("EditNumberDialog.cancelbtn_capt")};
        this.optionPane = new JOptionPane(win, -1, 2, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.optionPane.addPropertyChangeListener(this);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (value.equals(Messages.getString("EditNumberDialog.okbtn_capt"))) {
                if (this.allTermsAreValid()) {
                    this.actNumber.setAllValues(this.newMin, this.newVal, this.newMax, this.newQuant);
                    this.actNumber.updateParams(null, 0.0, 0.0);
                    this.clearAndHide();
                } else {
                    JOptionPane.showMessageDialog(this, String.valueOf(Messages.getString("EditNumberDialog.error_str_01")) + Messages.getString("EditNumberDialog.error_str_02") + Messages.getString("EditNumberDialog.error_str_03") + Messages.getString("EditNumberDialog.error_str_04"), Messages.getString("EditNumberDialog.error_str_05"), 0);
                }
            } else {
                this.clearAndHide();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof Checkbox) {
            if (this.cbisqua.getState()) {
                this.tfquant.setEditable(true);
                this.tfquant.setText("0,5");
            } else {
                this.tfquant.setEditable(false);
                this.tfquant.setText("0");
            }
        }
    }

    public void clearAndHide() {
        this.tfmin.setText(null);
        this.tfval.setText(null);
        this.tfmax.setText(null);
        this.setVisible(false);
    }

    private JPanel getLabeledTextField(String caption, int nr, double val) {
        JPanel p = new JPanel(new BorderLayout());
        JLabel lab = new JLabel(caption);
        p.add((Component)lab, "North");
        Object[] v = new Double[]{val};
        JTextField tf = new JTextField(String.format("%.5f", v), 12);
        p.add((Component)tf, "South");
        if (nr == 1) {
            this.tfmin = tf;
        } else if (nr == 2) {
            this.tfval = tf;
        } else if (nr == 3) {
            this.tfmax = tf;
        } else if (nr == 5) {
            this.tfquant = tf;
        }
        return p;
    }

    private JPanel getLabeledCheckBox(String caption, int nr, boolean val) {
        JPanel p = new JPanel();
        this.cbisqua = new Checkbox(caption, val);
        p.add(this.cbisqua);
        return p;
    }

    private boolean isValidDoubleString(int nr) {
        String s = "";
        if (nr == 1) {
            s = this.tfmin.getText();
        } else if (nr == 2) {
            s = this.tfval.getText();
        } else if (nr == 3) {
            s = this.tfmax.getText();
        } else if (nr == 5) {
            s = this.tfquant.getText();
        }
        if (s.length() > 0) {
            TermTree tb = new TermTree(s, 0.0, this.actNumber.getDrawing(), TermTree.isRadMode);
            if (tb.isOkay()) {
                if (nr == 1) {
                    this.newMin = tb.getValue(0.0);
                } else if (nr == 2) {
                    this.newVal = tb.getValue(0.0);
                } else if (nr == 3) {
                    this.newMax = tb.getValue(0.0);
                } else if (nr == 5) {
                    if (this.cbisqua.getState()) {
                        this.newQuant = Math.abs(tb.getValue(0.0));
                    } else {
                        this.newQuant = 0.0;
                        this.tfquant.setText("0");
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean allTermsAreValid() {
        boolean b1 = this.isValidDoubleString(1);
        if (!b1) {
            this.tfmin.selectAll();
            this.tfmin.requestFocusInWindow();
            return false;
        }
        boolean b2 = this.isValidDoubleString(2);
        if (!b2) {
            this.tfval.selectAll();
            this.tfval.requestFocusInWindow();
            return false;
        }
        boolean b3 = this.isValidDoubleString(3);
        if (!b3) {
            this.tfmax.selectAll();
            this.tfmax.requestFocusInWindow();
            return false;
        }
        boolean b5 = this.isValidDoubleString(5);
        if (!b5) {
            this.tfquant.selectAll();
            this.tfmax.requestFocusInWindow();
            return false;
        }
        return !(this.newMin > this.newMax) && !(this.newVal < this.newMin) && !(this.newVal > this.newMax);
    }
}

