/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.Messages;
import geoobj.GCircleWDR;
import geoobj.GGraph;
import geoobj.GPointWDC;
import geoobj.GTerm;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import terms.TermTree;

public class EditTermDialog
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private int actMode = 0;
    private GeoObj actObj = null;
    private GeoObjList actDrawing = null;
    private JOptionPane optionPane = null;
    private JTextField tf = null;
    private JTextField tf2 = null;
    private JCheckBox cb = null;
    private JCheckBox cb2 = null;
    private JRadioButton rb0 = null;
    private JRadioButton rb1 = null;
    private JRadioButton rb2 = null;
    private boolean showTerm = true;
    private boolean showName = true;
    private int showFormat = 0;
    private String errorStr = "";
    private String result = "";
    private String result2 = "";

    public EditTermDialog(Component owner, int modus, String title, GeoObj geoObj, GeoObjList drawing) {
        super(JOptionPane.getFrameForComponent(owner), title, true);
        this.actMode = modus;
        this.actObj = geoObj;
        this.actDrawing = drawing;
        JPanel win = new JPanel(new BorderLayout(3, 3));
        this.tf = new JTextField(this.getTermStringFromObj(0));
        win.add((Component)this.tf, "North");
        if (this.actMode == 67 || this.actMode == 42) {
            this.tf2 = new JTextField(this.getTermStringFromObj(1));
            win.add((Component)this.tf2, "Last");
        } else if (this.actMode == 74 || this.actMode == 79) {
            JPanel jp = new JPanel(new BorderLayout());
            Box bx = new Box(1);
            if (this.actObj != null) {
                this.showTerm = ((GTerm)this.actObj).getShowsTerm();
            }
            this.cb = new JCheckBox(Messages.getString("EditTermDialog.cb_capt"), this.showTerm);
            bx.add(Box.createVerticalGlue());
            bx.add(this.cb);
            if (this.actObj != null) {
                this.showName = ((GTerm)this.actObj).getShowsName();
            }
            this.cb2 = new JCheckBox(Messages.getString("EditTermDialog.cb2_capt"), this.showName);
            bx.add(this.cb2);
            bx.add(Box.createVerticalGlue());
            jp.add((Component)bx, "West");
            if (this.actObj != null) {
                this.showFormat = ((GTerm)this.actObj).getShowFormat();
            }
            this.rb0 = new JRadioButton(Messages.getString("EditTermDialog.rb0_capt"));
            this.rb1 = new JRadioButton(Messages.getString("EditTermDialog.rb1_capt"));
            this.rb2 = new JRadioButton(Messages.getString("EditTermDialog.rb2_capt"));
            switch (this.showFormat) {
                case 1: {
                    this.rb1.setSelected(true);
                    break;
                }
                case 2: {
                    this.rb2.setSelected(true);
                    break;
                }
                default: {
                    this.rb0.setSelected(true);
                }
            }
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rb0);
            bg.add(this.rb1);
            bg.add(this.rb2);
            bx = new Box(1);
            bx.add(Box.createVerticalStrut(8));
            bx.add(new JLabel(Messages.getString("EditTermDialog.lbl_capt"), 4));
            bx.add(Box.createVerticalStrut(5));
            bx.add(this.rb0);
            bx.add(this.rb1);
            bx.add(this.rb2);
            jp.add((Component)bx, "East");
            win.add((Component)jp, "Last");
        }
        Object[] options = new Object[]{Messages.getString("EditTermDialog.okbtn_capt"), Messages.getString("EditTermDialog.cancelbtn_capt")};
        this.optionPane = new JOptionPane(win, -1, 2, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.optionPane.addPropertyChangeListener(this);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (value.equals(Messages.getString("EditTermDialog.okbtn_capt"))) {
                if (this.allTermsAreValid()) {
                    switch (this.actMode) {
                        case 65: {
                            if (this.actObj != null) {
                                ((GCircleWDR)this.actObj).setRadiusTerm(this.tf.getText());
                                break;
                            }
                            this.result = this.tf.getText();
                            break;
                        }
                        case 76: {
                            ((GGraph)this.actObj).setTermString(this.tf.getText());
                            break;
                        }
                        case 74: {
                            ((GTerm)this.actObj).setTermStr(this.tf.getText());
                            ((GTerm)this.actObj).setShowsTerm(this.cb.isSelected());
                            ((GTerm)this.actObj).setShowsName(this.cb2.isSelected());
                            ((GTerm)this.actObj).setShowFormat(this.getShowFormat());
                            break;
                        }
                        case 79: {
                            this.result = this.tf.getText();
                            this.showTerm = this.cb.isSelected();
                            this.showName = this.cb2.isSelected();
                            this.showFormat = this.getShowFormat();
                            break;
                        }
                        case 67: {
                            ((GPointWDC)this.actObj).setXTerm(this.tf.getText());
                            ((GPointWDC)this.actObj).setYTerm(this.tf2.getText());
                            this.actObj.updateParams(null, 0.0, 0.0);
                            break;
                        }
                        default: {
                            this.result = this.tf.getText();
                            if (this.tf2 != null) {
                                this.result2 = this.tf2.getText();
                            }
                            if (this.cb != null) {
                                this.showTerm = this.cb.isSelected();
                            }
                            if (this.cb2 == null) break;
                            this.showName = this.cb2.isSelected();
                        }
                    }
                    this.clearAndHide();
                } else {
                    JOptionPane.showMessageDialog(this, String.valueOf(Messages.getString("EditTermDialog.mess_01")) + this.errorStr + Messages.getString("EditTermDialog.mess_02") + Messages.getString("EditTermDialog.mess_03"), Messages.getString("EditTermDialog.mess_04"), 0);
                    this.result = "";
                }
            } else {
                this.result = "";
                this.clearAndHide();
            }
        }
    }

    public void clearAndHide() {
        this.tf.setText(null);
        this.setVisible(false);
    }

    public String getResult(int n) {
        if (n == 2) {
            return this.result2;
        }
        return this.result;
    }

    public boolean getShowTerm() {
        return this.showTerm;
    }

    public boolean getShowName() {
        return this.showName;
    }

    public int getShowFormat() {
        this.showFormat = this.rb1.isSelected() ? 1 : (this.rb2.isSelected() ? 2 : 0);
        return this.showFormat;
    }

    private String getTermStringFromObj(int n) {
        if (this.actObj != null) {
            switch (this.actMode) {
                case 65: {
                    return ((GCircleWDR)this.actObj).getRadiusTerm();
                }
                case 74: {
                    return ((GTerm)this.actObj).getTermStr();
                }
                case 76: {
                    return ((GGraph)this.actObj).getTermString();
                }
                case 67: {
                    if (n == 0) {
                        return ((GPointWDC)this.actObj).getXTerm();
                    }
                    return ((GPointWDC)this.actObj).getYTerm();
                }
            }
            return "";
        }
        return "";
    }

    private boolean isValidTermString(String s) {
        TermTree tb = new TermTree(s, 0.0, this.actDrawing, TermTree.isRadMode);
        return tb.isOkay();
    }

    private boolean allTermsAreValid() {
        boolean b2;
        boolean b1 = this.isValidTermString(this.tf.getText());
        if (!b1) {
            this.errorStr = this.tf.getText();
            this.tf.selectAll();
            this.tf.requestFocusInWindow();
            return false;
        }
        boolean bl = b2 = this.tf2 == null || this.isValidTermString(this.tf2.getText());
        if (!b2) {
            this.errorStr = this.tf2.getText();
            this.tf2.selectAll();
            this.tf2.requestFocusInWindow();
            return false;
        }
        return true;
    }
}

