/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.Messages;
import geoobj.GTextBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import xml.Helpers;

public class EditTextBoxDialog
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private GTextBox actObj = null;
    private JTextArea ta;
    private JOptionPane optionPane;

    public EditTextBoxDialog(Component owner, GTextBox geoObj) {
        super(JOptionPane.getFrameForComponent(owner), Messages.getString("EditTextBoxDialog.title"), true);
        this.actObj = geoObj;
        JPanel win = new JPanel(new BorderLayout(0, 3));
        String s = String.valueOf(Messages.getString("EditTextBoxDialog.mess_1")) + Messages.getString("EditTextBoxDialog.mess_2");
        if (geoObj != null) {
            s = Helpers.killAllHTMLTags(geoObj.getHtmlText());
        }
        this.ta = new JTextArea(s);
        this.ta.setSize(new Dimension(150, 50));
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        win.add((Component)this.ta, "North");
        Object[] options = new Object[]{Messages.getString("EditTextBoxDialog.okbtn_capt"), Messages.getString("EditTextBoxDialog.cancelbtn_capt")};
        this.optionPane = new JOptionPane(win, -1, 2, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                EditTextBoxDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                EditTextBoxDialog.this.ta.requestFocusInWindow();
            }
        });
        this.optionPane.addPropertyChangeListener(this);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (value.equals(Messages.getString("EditTextBoxDialog.okbtn_capt"))) {
                if (this.actObj != null) {
                    String nn = this.ta.getText();
                    this.actObj.setHtmlText(nn);
                    this.clearAndHide();
                } else {
                    this.setVisible(false);
                }
            } else {
                this.clearAndHide();
            }
        }
    }

    public String getResult(int i) {
        return this.ta.getText();
    }

    public Rectangle getTextRect() {
        Rectangle r = this.ta.getBounds();
        r.x += this.getX() - this.getParent().getX();
        r.y += this.getY() - this.getParent().getY();
        return r;
    }

    public void clearAndHide() {
        this.ta.setText(null);
        this.setVisible(false);
    }
}

