/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.Messages;
import geoobj.GeoObjList;
import geoobj.VisGroup;
import geoobj.VisGroupList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class EditVisibilityDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JOptionPane optionPane;
    protected GeoObjList objList = null;
    protected VisGroupList visGroups = null;
    protected JCheckBox[] visCheckBoxes = null;

    public EditVisibilityDialog(Component owner, GeoObjList iObjList) {
        super(JOptionPane.getFrameForComponent(owner), Messages.getString("EditVisibilityDialog.title"), true);
        this.objList = iObjList;
        this.setSize(200, 200);
        Box cbs = new Box(1);
        this.visGroups = this.objList.getVisGroups();
        int svg_cnt = this.visGroups.getStaticCount();
        this.visCheckBoxes = new JCheckBox[svg_cnt];
        int n = 0;
        if (svg_cnt > 0) {
            int i = 0;
            while (i < this.visGroups.getCount()) {
                VisGroup vg = this.visGroups.get(i);
                if (vg.isStatic()) {
                    this.visCheckBoxes[n] = new JCheckBox(vg.getComment(), vg.isVisible());
                    cbs.add(this.visCheckBoxes[n]);
                    ++n;
                }
                ++i;
            }
        }
        JPanel win = new JPanel();
        win.add(cbs);
        Object[] options = new Object[]{Messages.getString("EditVisibilityDialog.okbtn_capt"), Messages.getString("EditVisibilityDialog.cancelbtn_capt")};
        this.optionPane = new JOptionPane(win, -1, 2, null, options, options[0]);
        this.optionPane.addPropertyChangeListener(this);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && "value".equals(prop)) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (value.equals(Messages.getString("EditVisibilityDialog.cancelbtn_capt"))) {
                this.setVisible(false);
            } else if (value.equals(Messages.getString("EditVisibilityDialog.okbtn_capt"))) {
                int i = 0;
                while (i < this.visCheckBoxes.length) {
                    JCheckBox actCB = this.visCheckBoxes[i];
                    VisGroup vg = this.visGroups.getVGbyName(actCB.getText());
                    if (vg != null) {
                        vg.setVisible(actCB.isSelected());
                    }
                    ++i;
                }
                this.setVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.optionPane.setValue(Messages.getString("EditVisibilityDialog.okbtn_capt"));
    }
}

