/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.Messages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.Timer;

public class ScrollableTextWin
extends JPanel
implements Scrollable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private String data = "<html><font face=\"Arial\" size=\"3\"><font color=\"blue\"><b>Copyright 2004 - 2014<br>&nbsp;&nbsp;Roland Mechling</b></font><br><font color=\"blue\">" + Messages.getString("ScrollableTextWin.t1") + "<br>" + Messages.getString("ScrollableTextWin.t2") + "</font><br>" + "<br>" + "<font color=\"red\"><b>2005/2006: </b></font><br>" + "<i>&nbsp;&nbsp;Philipp Kern,<br>" + "&nbsp;&nbsp;Benjamin Herr,<br>" + "&nbsp;&nbsp;Sebastian Klaas,<br>" + "&nbsp;&nbsp;Alexander Schwende,<br>" + "&nbsp;&nbsp;Noel Weidenhammer,<br>" + "&nbsp;&nbsp;Christoph Borschensky,<br>" + "&nbsp;&nbsp;Sebastian Mayer,<br>" + "&nbsp;&nbsp;Armin Burgmeier;<br></i>" + "<br>" + "<font color=\"red\"><b>2010/2011: </b></font><br> " + "<i>&nbsp;&nbsp;Thilo Spinner,<br>" + "&nbsp;&nbsp;Lukas Heizmann,<br>" + "&nbsp;&nbsp;Jan Bross,<br>" + "&nbsp;&nbsp;Laura Kriener,<br>" + "&nbsp;&nbsp;Johannes Popp,<br>" + "&nbsp;&nbsp;Michael Sklarzik,<br>" + "&nbsp;&nbsp;Xenia Fischer.</i><br>" + "<br><br><br>";
    private String data2 = "<font color=\"blue\"><b>Copyright 2004 - 2014<br>&nbsp;&nbsp;Roland Mechling</b></font><br><font color=\"blue\">" + Messages.getString("ScrollableTextWin.t1") + "<br>" + Messages.getString("ScrollableTextWin.t2") + "</font><br>" + "<br>" + "<font color=\"red\"><b>2005/2006: </b></font><br>" + "<i>&nbsp;&nbsp;Philipp Kern,<br>" + "&nbsp;&nbsp;Benjamin Herr,<br>" + "&nbsp;&nbsp;Sebastian Klaas,<br>" + "&nbsp;&nbsp;Alexander Schwende,<br>" + "&nbsp;&nbsp;Noel Weidenhammer,<br>";
    private JEditorPane txt = new JEditorPane("text/html", this.data);
    private JScrollPane scrollPane = null;
    private int maxUnitIncrement = 1;
    private Dimension vpSize = null;
    private Timer timer = null;
    private int time = 0;
    private int delay = 50;
    private int wait = 2000;

    public ScrollableTextWin(int iWidth, int iHeight) {
        this.txt.setCaretPosition(0);
        this.txt.enableInputMethods(false);
        this.scrollPane = new JScrollPane(21, 31);
        this.scrollPane.setViewportView(this.txt);
        this.scrollPane.setPreferredSize(new Dimension(iWidth, iHeight));
        JViewport vp = this.scrollPane.getViewport();
        vp.setScrollMode(1);
        this.vpSize = vp.getViewSize();
        this.txt.setText(String.valueOf(this.data) + this.data2);
        this.txt.setCaretPosition(0);
        this.scrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.scrollPane.setVisible(true);
        this.add(this.scrollPane);
        this.timer = new Timer(this.delay, this);
        this.setVisible(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            super.setVisible(vis);
            this.time = -this.wait;
            this.timer.start();
        } else {
            this.timer.stop();
            super.setVisible(vis);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JViewport vp = this.scrollPane.getViewport();
        Point vpos = vp.getViewPosition();
        if (this.time > 0) {
            if (vpos.y < this.vpSize.height - 6) {
                vpos.y += this.maxUnitIncrement;
            } else {
                vpos.y = 0;
                this.time = -this.wait;
            }
        } else {
            this.time += this.delay;
        }
        vp.setViewPosition(vpos);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }
}

