/*
 * Decompiled with CFR 0.152.
 */
package canvas;

import applet.Controller;
import applet.DynaGeoJ;
import applet.Options;
import dgmath.MyMath;
import geoobj.GeoObjList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;
import xml.FormattedText;
import xml.WindowData;

public final class CoordsCanvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean highRenderQuality = true;
    private BufferedImage bi = null;
    private ImageIcon logo = new ImageIcon(CoordsCanvas.class.getClassLoader().getResource("graphics/logo_right.png"));
    private Graphics2D graphics;
    private GeoObjList objects = new GeoObjList();
    private Font defFont;
    private int ori_x;
    private int ori_y;
    private double x_min;
    private double x_max;
    private double y_min;
    private double y_max;
    private double hx_min;
    private double hx_max;
    private double hy_min;
    private double hy_max;
    private Controller brains;
    private int delay = 300;
    ActionListener taskPerformer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            CoordsCanvas.this.objects.toggleBlinking();
            CoordsCanvas.this.repaint();
        }
    };
    private Timer timer = new Timer(this.delay, this.taskPerformer);

    public CoordsCanvas(Controller iBrains) {
        this.brains = iBrains;
        this.addMouseListener(this.brains);
        this.addMouseMotionListener(this.brains);
        this.addMouseWheelListener(this.brains);
        this.addKeyListener(this.brains.myKeyListener);
        this.setCursor(new Cursor(13));
        this.setBackground(Color.WHITE);
    }

    public void setObjectList(GeoObjList objs) {
        this.objects = objs;
        this.defFont = objs.getStartFont();
    }

    public GeoObjList getObjectList() {
        return this.objects;
    }

    public void startBlinking() {
        this.objects.startBlinking();
        this.timer.start();
        this.repaint();
    }

    public void stopBlinking() {
        this.timer.stop();
        this.objects.stopBlinking();
        this.repaint();
    }

    public void zoom(double zf) {
        Options.ppcm *= zf;
        this.updateBorders();
        this.objects.resize(this);
        this.repaint();
    }

    public void moveScreenOri(int iox, int ioy) {
        this.ori_x += iox;
        this.ori_y += ioy;
        this.updateBorders();
        this.objects.resize(this);
        this.repaint();
    }

    public void setWindow(WindowData wd) {
        this.x_max = wd.getXmax();
        this.x_min = wd.getXmin();
        this.y_max = wd.getYmax();
        this.y_min = wd.getYmin();
        if (Math.abs(Options.ppcm) < 1.0E-6) {
            Options.ppcm = 37.79527559055118;
        }
        this.ori_x = (int)(-this.x_min * Options.ppcm);
        this.ori_y = (int)(this.y_max * Options.ppcm * Options.aspect);
        this.setHorizon();
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    public void refreshDrawing() {
        this.brains.getMainWindow().invalidate();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.graphics = (Graphics2D)g;
        if (this.highRenderQuality) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            this.graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        }
        this.graphics.setPaint(Color.BLACK);
        this.objects.drawAllObjs(this);
        this.graphics = null;
        if (this.brains.hasButtons()) {
            this.logo.paintIcon(this, g, 0, this.getHeight() - this.logo.getIconHeight());
        }
    }

    private void setPen(int pen, int size) {
        BasicStroke s = null;
        switch (pen) {
            case 3: {
                s = new BasicStroke(size, 0, 0, 10.0f, new float[]{21.0f, 6.0f, 3.0f, 6.0f}, 0.0f);
                break;
            }
            case 2: {
                s = new BasicStroke(size, 0, 1, 1.0f, new float[]{3.0f, 8.0f}, 0.0f);
                break;
            }
            case 1: {
                s = new BasicStroke(size, 0, 1, 1.0f, new float[]{21.0f, 21.0f}, 0.0f);
                break;
            }
            default: {
                s = new BasicStroke(size, 0, 0);
            }
        }
        this.graphics.setStroke(s);
    }

    private Color getBrighterColor(Color ori) {
        float[] hsb = Color.RGBtoHSB(ori.getRed(), ori.getGreen(), ori.getBlue(), null);
        hsb[2] = 1.0f - (1.0f - hsb[2]) / 2.0f;
        int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return new Color(rgb);
    }

    public boolean containsPt(double ux, double uy) {
        return ux >= this.x_min && ux <= this.x_max && uy >= this.y_min && uy <= this.y_max;
    }

    public boolean knowsPt(double ux, double uy) {
        return ux >= this.hx_min && ux <= this.hx_max && uy >= this.hy_min && uy <= this.hy_max;
    }

    public double[] getCoordsRange() {
        double[] res = new double[]{this.x_min, this.y_min, this.x_max, this.y_max};
        return res;
    }

    public Font getDefaultFont() {
        return this.defFont;
    }

    public void setDefaultFont(Font ifont) {
        this.defFont = ifont;
    }

    public void installSafeGraphic() {
        DynaGeoJ mw = this.brains.getMainWindow();
        this.bi = new BufferedImage(mw.getWidth(), mw.getHeight(), 1);
        this.graphics = (Graphics2D)this.bi.getGraphics();
    }

    public void revokeSafeGraphic() {
        this.graphics = null;
        this.bi = null;
    }

    @Override
    public Graphics2D getGraphics() {
        Graphics g = this.graphics;
        if (g == null) {
            g = super.getGraphics();
        }
        return g;
    }

    public void drawPoint(double x, double y, int penWidth, int ptShape, int ptSize, Color col) {
        this.graphics.setPaint(col);
        this.setPen(0, penWidth);
        int add = 0;
        if (penWidth > 1) {
            add = 1;
        }
        switch (ptShape) {
            case 0: {
                this.graphics.fill(new Ellipse2D.Double(this.userToScreenX(x) - ptSize, this.userToScreenY(y) - ptSize, ptSize * 2 + 1, ptSize * 2 + 1));
                break;
            }
            case 1: {
                this.graphics.fill(new Rectangle2D.Double(this.userToScreenX(x) - ptSize, this.userToScreenY(y) - ptSize, ptSize * 2 + 1, ptSize * 2 + 1));
                break;
            }
            case 2: {
                this.graphics.draw(new Ellipse2D.Double(this.userToScreenX(x) - ptSize, this.userToScreenY(y) - ptSize, ptSize * 2 + 1, ptSize * 2 + 1));
                break;
            }
            case 3: {
                this.graphics.draw(new Rectangle2D.Double(this.userToScreenX(x) - ptSize, this.userToScreenY(y) - ptSize, ptSize * 2 + 1, ptSize * 2 + 1));
                break;
            }
            case 4: {
                this.graphics.draw(new Line2D.Double(this.userToScreenX(x) - ptSize, this.userToScreenY(y), this.userToScreenX(x) + ptSize + add, this.userToScreenY(y)));
                this.graphics.draw(new Line2D.Double(this.userToScreenX(x), this.userToScreenY(y) - ptSize, this.userToScreenX(x), this.userToScreenY(y) + ptSize + add));
                break;
            }
            case 5: {
                this.graphics.draw(new Line2D.Double(this.userToScreenX(x) - ptSize, this.userToScreenY(y) - ptSize, this.userToScreenX(x) + ptSize, this.userToScreenY(y) + ptSize));
                this.graphics.draw(new Line2D.Double(this.userToScreenX(x) - ptSize, this.userToScreenY(y) + ptSize, this.userToScreenX(x) + ptSize, this.userToScreenY(y) - ptSize));
            }
        }
        this.setPen(0, 1);
    }

    public void drawSegment(double from_x, double from_y, double to_x, double to_y, int penStyle, int penWidth, Color col) {
        this.graphics.setColor(col);
        this.setPen(penStyle, penWidth);
        this.graphics.draw(new Line2D.Double(this.userToScreenX(from_x), this.userToScreenY(from_y), this.userToScreenX(to_x), this.userToScreenY(to_y)));
        this.setPen(0, 1);
    }

    public void drawRay(double start_x, double start_y, double thru_x, double thru_y, int penStyle, int penWidth, Color col) {
        this.graphics.setColor(col);
        this.setPen(penStyle, penWidth);
        double dx = thru_x - start_x;
        double dy = thru_y - start_y;
        double dr = MyMath.hypot(dx, dy);
        double ax = Math.max(Math.abs(start_x - this.x_max), Math.abs(start_x - this.x_min));
        double ay = Math.max(Math.abs(start_y - this.y_max), Math.abs(start_y - this.y_min));
        dr = 2.0 * Math.max(ax, ay) / dr;
        this.graphics.draw(new Line2D.Double(this.userToScreenX(start_x), this.userToScreenY(start_y), this.userToScreenX(start_x + dx * dr), this.userToScreenY(start_y + dy * dr)));
        this.setPen(0, 1);
    }

    public void drawVector(double from_x, double from_y, double to_x, double to_y, int penStyle, int penWidth, Color col) {
        this.graphics.setColor(col);
        this.setPen(penStyle, penWidth);
        this.graphics.draw(new Line2D.Double(this.userToScreenX(from_x), this.userToScreenY(from_y), this.userToScreenX(to_x), this.userToScreenY(to_y)));
        double vx = to_x - from_x;
        double vy = to_y - from_y;
        double vl = MyMath.hypot(vx, vy);
        if (Math.abs(vl) > 1.0E-6) {
            double dvl = 15.0 / Options.ppcm;
            double k = dvl / vl;
            double dv_x = vx * k;
            double dv_y = vy * k;
            double s1x = to_x - dv_x + dv_y / 3.0;
            double s1y = to_y - dv_y - dv_x / 3.0;
            double s2x = to_x - dv_x - dv_y / 3.0;
            double s2y = to_y - dv_y + dv_x / 3.0;
            this.graphics.draw(new Line2D.Double(this.userToScreenX(to_x), this.userToScreenY(to_y), this.userToScreenX(s1x), this.userToScreenY(s1y)));
            this.graphics.draw(new Line2D.Double(this.userToScreenX(to_x), this.userToScreenY(to_y), this.userToScreenX(s2x), this.userToScreenY(s2y)));
        }
        this.setPen(0, 1);
    }

    public void drawEllipse(double x, double y, double a, double b, int penStyle, int penWidth, Color frameColor) {
        int width = this.userToScreenW(2.0 * a);
        int height = this.userToScreenH(2.0 * b);
        this.graphics.setColor(frameColor);
        this.setPen(penStyle, penWidth);
        this.graphics.drawOval(this.userToScreenX(x) - width / 2, this.userToScreenY(y) - height / 2, width, height);
        this.setPen(0, 1);
    }

    public void drawArc(double mx, double my, double radius, double start, double end, int penStyle, int penWidth, Color frameColor, int fill, Color fillColor) {
        int x1 = this.userToScreenX(mx - radius);
        int y1 = this.userToScreenY(my + radius);
        int x2 = this.userToScreenX(mx + radius);
        int y2 = this.userToScreenY(my - radius);
        int w = x2 - x1 + 1;
        int h = y2 - y1 + 1;
        int s = (int)MyMath.rad2deg(start);
        double dae = end - start;
        if (dae < 0.0) {
            dae += Math.PI * 2;
        }
        int ae = (int)Math.rint(MyMath.rad2deg(dae)) + 1;
        this.setPen(penStyle, penWidth);
        if (fill != 1) {
            this.graphics.setColor(fillColor);
            this.graphics.fillArc(x1, y1, w, h, s, ae);
        }
        this.graphics.setColor(frameColor);
        this.graphics.drawArc(x1, y1, w, h, s, ae);
        this.setPen(0, 1);
    }

    public void drawPolygon(double[] x, double[] y, int penStyle, int penWidth, Color frameColor) {
        int[] own_x = new int[x.length];
        int[] own_y = new int[y.length];
        this.graphics.setColor(frameColor);
        this.setPen(penStyle, penWidth);
        int n = 0;
        while (n < x.length) {
            own_x[n] = this.userToScreenX(x[n]);
            ++n;
        }
        n = 0;
        while (n < y.length) {
            own_y[n] = this.userToScreenY(y[n]);
            ++n;
        }
        this.graphics.drawPolygon(own_x, own_y, own_x.length);
        this.setPen(0, 1);
    }

    public void drawTriangle(double x1, double y1, double x2, double y2, double x3, double y3, int penStyle, int penWidth, Color frameColor) {
        double[] x = new double[]{x1, x2, x3};
        double[] y = new double[]{y1, y2, y3};
        this.drawPolygon(x, y, penStyle, penWidth, frameColor);
    }

    public void fillPolygon(double[] x, double[] y, int penStyle, int penWidth, Color frameColor, Color fillColor) {
        int[] own_x = new int[x.length];
        int[] own_y = new int[y.length];
        this.graphics.setColor(frameColor);
        this.setPen(penStyle, penWidth);
        int n = 0;
        while (n < x.length) {
            own_x[n] = this.userToScreenX(x[n]);
            ++n;
        }
        n = 0;
        while (n < y.length) {
            own_y[n] = this.userToScreenY(y[n]);
            ++n;
        }
        Polygon p = new Polygon(own_x, own_y, own_x.length);
        this.fillShape(p, 0, fillColor);
        this.graphics.drawPolygon(p);
        this.setPen(0, 1);
    }

    public void fillShape(Shape border, int fillStyle, Color fillColor) {
        if (this.isVisible() && fillStyle != 1) {
            Paint op = this.graphics.getPaint();
            BufferedImage bi = this.createBrushImage(fillStyle, fillColor);
            TexturePaint tp = new TexturePaint(bi, new Rectangle(0, 0, 8, 8));
            this.graphics.setPaint(tp);
            this.graphics.fill(border);
            this.graphics.setPaint(op);
        }
    }

    public void drawOrigin(int ptShape, int ptSize, int cosysType, int gridMarks, boolean showNumbers, Color col) {
        this.drawPoint(0.0, 0.0, 1, ptShape, ptSize, col);
        if (cosysType >= 0) {
            this.graphics.setColor(col);
            double atx0 = 0.0;
            double aty0 = 0.0;
            double tsx = this.getTickStep(Math.max(cosysType, 1), Options.ppcm);
            double tsy = this.getTickStep(Math.max(cosysType, 1), Options.ppcm * Options.aspect);
            while (atx0 > this.x_min) {
                atx0 -= tsx;
            }
            while (atx0 < this.x_min) {
                atx0 += tsx;
            }
            while (aty0 > this.y_min) {
                aty0 -= tsy;
            }
            while (aty0 < this.y_min) {
                aty0 += tsy;
            }
            if (cosysType > 0) {
                double atx = atx0;
                double aty = aty0;
                if (gridMarks == 0) {
                    while (atx < this.x_max) {
                        aty = aty0;
                        while (aty < this.y_max) {
                            this.draw_Tick(atx, aty);
                            aty += tsy;
                        }
                        atx += tsx;
                    }
                } else {
                    if (gridMarks == 1) {
                        this.setPen(0, 1);
                    } else {
                        this.setPen(2, 1);
                    }
                    int sy_min = this.userToScreenY(this.y_max);
                    int sy_max = this.userToScreenY(this.y_min);
                    while (atx < this.x_max) {
                        int sx = this.userToScreenX(atx);
                        this.graphics.drawLine(sx, sy_min, sx, sy_max);
                        atx += tsx;
                    }
                    int sx_min = this.userToScreenX(this.x_min);
                    int sx_max = this.userToScreenX(this.x_max);
                    while (aty < this.y_max) {
                        int sy = this.userToScreenY(aty);
                        this.graphics.drawLine(sx_min, sy, sx_max, sy);
                        aty += tsy;
                    }
                }
            }
            if (showNumbers) {
                this.letter_Axis(atx0, aty0, tsx, tsy);
            }
        }
        this.setPen(0, 1);
    }

    public void drawAxis(double[] eq, int penStyle, int penWidth, Color col, String label) {
        this.graphics.setColor(col);
        this.setPen(penStyle, penWidth);
        int[] pt = new int[4];
        if (Math.abs(eq[0]) > Math.abs(eq[1])) {
            pt[0] = this.userToScreenX(0.0);
            pt[1] = this.userToScreenY(this.y_min);
            pt[2] = pt[0];
            pt[3] = this.userToScreenY(this.y_max);
            this.graphics.draw(new Line2D.Float(pt[0], pt[1], pt[2], pt[3]));
            this.graphics.draw(new Line2D.Float(pt[2], pt[3], pt[2] - 5, pt[3] + 20));
            this.graphics.draw(new Line2D.Float(pt[2], pt[3], pt[2] + 5, pt[3] + 20));
            this.graphics.drawString(label, pt[2] - 15, pt[3] + 15);
        } else {
            pt[0] = this.userToScreenX(this.x_min);
            pt[1] = this.userToScreenY(0.0);
            pt[2] = this.userToScreenX(this.x_max);
            pt[3] = pt[1];
            this.graphics.draw(new Line2D.Double(pt[0], pt[1], pt[2], pt[3]));
            this.graphics.draw(new Line2D.Float(pt[2], pt[3], pt[2] - 20, pt[3] + 5));
            this.graphics.draw(new Line2D.Float(pt[2], pt[3], pt[2] - 20, pt[3] - 5));
            this.graphics.drawString(label, pt[2] - 15, pt[3] - 10);
        }
        this.setPen(0, 1);
    }

    public void drawLongLine(double[] eq, int penStyle, int penWidth, Color col) {
        double[] pt = new double[4];
        if (Math.abs(eq[0]) > Math.abs(eq[1])) {
            pt[0] = (-eq[1] * this.y_max + eq[2]) / eq[0];
            pt[1] = this.y_max;
            pt[2] = (-eq[1] * this.y_min + eq[2]) / eq[0];
            pt[3] = this.y_min;
        } else {
            pt[0] = this.x_max;
            pt[1] = (-eq[0] * this.x_max + eq[2]) / eq[1];
            pt[2] = this.x_min;
            pt[3] = (-eq[0] * this.x_min + eq[2]) / eq[1];
        }
        this.drawSegment(pt[0], pt[1], pt[2], pt[3], penStyle, penWidth, col);
    }

    public void drawCurve(GeneralPath curve, int penStyle, int penWidth, Color col) {
        this.graphics.setColor(col);
        this.setPen(penStyle, penWidth);
        this.graphics.draw(curve);
        this.setPen(0, 1);
    }

    public void drawRiemannBorder(Point2D.Double[] pts, int cnt, int penStyle, int penWidth, Color col) {
        this.graphics.setColor(col);
        this.setPen(penStyle, penWidth);
        int i = 1;
        while (i <= cnt) {
            int h;
            int y;
            int w;
            int x;
            if (pts[i].x > pts[i - 1].x) {
                x = (int)pts[i - 1].x;
                w = (int)(pts[i].x - pts[i - 1].x);
            } else {
                x = (int)pts[i].x;
                w = (int)(pts[i - 1].x - pts[i].x);
            }
            if (pts[i].y > pts[0].y) {
                y = (int)pts[0].y;
                h = (int)(pts[i].y - pts[0].y);
            } else {
                y = (int)pts[i].y;
                h = (int)(pts[0].y - pts[i].y);
            }
            this.graphics.drawRect(x, y, w, h);
            ++i;
        }
        this.setPen(0, 1);
    }

    public void drawNumberBox(double[] pos, double[] val, String name, Color col) {
        this.graphics.setColor(col);
        this.setPen(0, 1);
        int[] i_pos = new int[]{this.userToScreenX(pos[0]), this.userToScreenY(pos[1]), this.userToScreenX(pos[2]), this.userToScreenY(pos[3])};
        int width = i_pos[2] - i_pos[0];
        int height = i_pos[3] - i_pos[1];
        this.graphics.drawRect(i_pos[0], i_pos[1], width / 4, height / 2);
        this.graphics.drawRect(i_pos[0] + width / 4 + 3, i_pos[1], width / 2 - 6, height / 2);
        this.graphics.drawRect(i_pos[0] + 3 * width / 4, i_pos[1], width / 4, height / 2);
        this.graphics.drawRect(i_pos[0], i_pos[1] + height / 2 + 3, 3 * width / 4 + width / 4, height / 2 - 3);
        this.setPen(0, 2);
        this.graphics.setColor(col.brighter());
        int line_y = i_pos[1] + 3 * height / 4 + 2;
        this.graphics.drawLine(i_pos[0] + 5, line_y, i_pos[2] - 6, line_y);
        double relPos = (val[1] - val[0]) / (val[2] - val[0]);
        int srp = i_pos[0] + 5 + (int)((double)(i_pos[2] - i_pos[0] - 11) * relPos);
        int[] px = new int[]{srp - 4, srp + 4, srp + 4, srp, srp - 4};
        int[] py = new int[]{line_y - 4, line_y - 4, line_y, line_y + 3, line_y};
        Polygon ps = new Polygon(px, py, 5);
        this.graphics.fill(ps);
        this.graphics.setColor(col.darker());
        this.graphics.draw(ps);
        this.setPen(0, 1);
        pos[0] = this.screenToUserX(srp);
        pos[1] = this.screenToUserY(line_y);
        pos[2] = this.screenToUserX(i_pos[0] + 5);
        pos[3] = this.screenToUserX(i_pos[2] - 6);
        Font f = new Font("SansSerif", 0, 12);
        this.graphics.setFont(f);
        this.graphics.setColor(col);
        FontRenderContext frc = this.graphics.getFontRenderContext();
        String s = Double.toString(val[0]);
        Rectangle2D r = f.getStringBounds(s, frc);
        this.graphics.drawString(s, i_pos[0] + width / 8 - (int)r.getWidth() / 2, i_pos[1] + height / 2 - 3);
        Object[] v = new Double[]{val[1]};
        s = String.format(String.valueOf(name) + " = %.3f", v);
        r = f.getStringBounds(s, frc);
        this.graphics.drawString(s, i_pos[0] + width / 2 - (int)r.getWidth() / 2, i_pos[1] + height / 2 - 3);
        s = Double.toString(val[2]);
        r = f.getStringBounds(s, frc);
        this.graphics.drawString(s, i_pos[0] + 7 * width / 8 - (int)r.getWidth() / 2, i_pos[1] + height / 2 - 3);
        this.setPen(0, 1);
    }

    public void drawCounterBox(double[] pos, double val, String name, Color col) {
        this.graphics.setColor(col);
        this.setPen(0, 1);
        int[] i_pos = new int[]{this.userToScreenX(pos[0]), this.userToScreenY(pos[1]), this.userToScreenX(pos[2]), this.userToScreenY(pos[3])};
        int width = i_pos[2] - i_pos[0];
        int height = i_pos[3] - i_pos[1];
        this.graphics.drawRect(i_pos[0], i_pos[1], width, height);
        double w = (pos[2] - pos[0]) * 0.2;
        double h = (pos[1] - pos[3]) * 0.5;
        double[] px = new double[]{pos[0] + 0.5 * w, pos[0] + 0.2 * w, pos[0] + 0.8 * w};
        double[] py = new double[]{pos[1] - 0.2 * h, pos[1] - 0.9 * h, pos[1] - 0.9 * h};
        Color b_col = this.getBrighterColor(col);
        this.fillPolygon(px, py, 0, 1, col, b_col);
        double[] py2 = new double[]{pos[3] + 0.2 * h, pos[3] + 0.9 * h, pos[3] + 0.9 * h};
        this.fillPolygon(px, py2, 0, 1, col, b_col);
        Font f = new Font("SansSerif", 0, 12);
        this.graphics.setFont(f);
        this.graphics.setColor(col);
        Object[] v = new Double[]{val};
        String s = String.format(String.valueOf(name) + " = %.2g", v);
        this.graphics.drawString(s, i_pos[0] + width / 3, i_pos[1] + height / 2 + 5);
    }

    public void drawTermBox(double[] pos, String titleStr, String valStr, Color col) {
        this.graphics.setColor(col);
        this.setPen(0, 1);
        Font f = new Font("SansSerif", 0, 12);
        this.graphics.setFont(f);
        this.graphics.setColor(col);
        FontRenderContext frc = this.graphics.getFontRenderContext();
        Rectangle2D r = null;
        int[] nArray = new int[4];
        nArray[0] = this.userToScreenX(pos[0]);
        nArray[1] = this.userToScreenY(pos[1]);
        int[] i_pos = nArray;
        if (titleStr.length() == 0) {
            r = f.getStringBounds(valStr, frc);
            i_pos[2] = r.getWidth() + 10.0 > 75.0 ? i_pos[0] + (int)r.getWidth() + 10 : i_pos[0] + 75;
            i_pos[3] = i_pos[1] + 16;
        } else {
            r = f.getStringBounds(titleStr, frc);
            i_pos[2] = r.getWidth() + 10.0 > 150.0 ? i_pos[0] + (int)r.getWidth() + 10 : i_pos[0] + 150;
            i_pos[3] = i_pos[1] + 33;
        }
        pos[2] = this.screenToUserX(i_pos[2]);
        pos[3] = this.screenToUserY(i_pos[3]);
        this.graphics.drawRect(i_pos[0], i_pos[1], i_pos[2] - i_pos[0], i_pos[3] - i_pos[1]);
        if (titleStr.length() > 0) {
            this.graphics.drawString(titleStr, i_pos[0] + (i_pos[2] - i_pos[0]) / 2 - (int)r.getWidth() / 2, i_pos[1] + 16 - 3);
            r = f.getStringBounds(valStr, frc);
            this.graphics.drawString(valStr, i_pos[0] + (i_pos[2] - i_pos[0]) / 2 - (int)r.getWidth() / 2, i_pos[1] + 33 - 3);
        } else {
            r = f.getStringBounds(valStr, frc);
            this.graphics.drawString(valStr, i_pos[0] + (i_pos[2] - i_pos[0]) / 2 - (int)r.getWidth() / 2, i_pos[1] + 16 - 3);
        }
        this.setPen(0, 1);
    }

    public void drawText(String htmlText, double x1, double y1, boolean centered, Color col, Point2D bounds) {
        if (htmlText.length() > 0) {
            this.graphics.setFont(this.objects.getStartFont());
            this.graphics.setColor(col);
            String[] list = htmlText.split("<br>");
            FontRenderContext frc = this.graphics.getFontRenderContext();
            Rectangle2D r = this.graphics.getFont().getStringBounds(list[0], frc);
            int width = (int)Math.ceil(r.getWidth());
            int height = (int)Math.ceil(r.getHeight());
            int sx = this.userToScreenX(x1);
            int sy = this.userToScreenY(y1) + (int)r.getHeight();
            if (centered) {
                sx -= (int)(r.getWidth() / 2.0);
                sy -= (int)(r.getHeight() / 2.0);
            }
            this.graphics.drawString(list[0], sx, sy);
            int i = 1;
            while (i < list.length) {
                r = this.graphics.getFont().getStringBounds(list[i], frc);
                this.graphics.drawString(list[i], sx, sy += (int)r.getHeight());
                if (r.getWidth() > (double)width) {
                    width = (int)Math.ceil(r.getWidth());
                }
                height += (int)Math.ceil(r.getHeight());
                ++i;
            }
            bounds.setLocation(this.screenToUserW(width), this.screenToUserH(height));
            this.setPen(0, 1);
        } else {
            bounds.setLocation(0.0, 0.0);
        }
    }

    public void drawFormattedText(FormattedText formatText, double x1, double y1, Color col) {
        this.graphics.setColor(col);
        int sx = this.userToScreenX(x1);
        int sy = this.userToScreenY(y1);
        this.graphics.setFont(this.objects.getStartFont());
        formatText.draw(this.graphics, sx, sy);
        this.setPen(0, 1);
    }

    public void drawImage(Image img, double x, double y) {
        this.graphics.drawImage(img, this.userToScreenX(x), this.userToScreenY(y), null);
    }

    public void drawMappedImage(Image img, double x, double y, double x1, double y1, double x2, double y2) {
        double[][] p = new double[][]{{0.0, 0.0}, {0.0, img.getHeight(null)}, {img.getWidth(null), img.getHeight(null)}};
        double[][] q = new double[][]{{this.userToScreenX(x), this.userToScreenY(y)}, {this.userToScreenX(x1), this.userToScreenY(y1)}, {this.userToScreenX(x2), this.userToScreenY(y2)}};
        double[][] mat = new double[][]{{0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        if (MyMath.getAffineMapFromPts(p, q, mat)) {
            AffineTransform map = new AffineTransform(mat[0][0], mat[0][1], mat[1][0], mat[1][1], mat[2][0], mat[2][1]);
            this.graphics.drawImage(img, map, null);
        }
    }

    public void getScreenPtCoords(double ux, double uy, Point2D.Double scr) {
        if (scr == null) {
            System.err.println("getUserPtCoords cannot write to null!");
        }
        scr.x = this.userToScreenX(ux);
        scr.y = this.userToScreenY(uy);
    }

    public void getUserPtCoords(double sx, double sy, Point2D.Double usr) {
        if (usr == null) {
            System.err.println("getUserPtCoords cannot write to null!");
        }
        usr.x = this.screenToUserX((int)Math.rint(sx));
        usr.y = this.screenToUserY((int)Math.rint(sy));
    }

    public int userToScreenX(double x) {
        return (int)(x * Options.ppcm + (double)this.ori_x);
    }

    public int userToScreenY(double y) {
        return (int)((double)this.ori_y - y * Options.ppcm * Options.aspect);
    }

    public int userToScreenW(double w) {
        return (int)(w * Options.ppcm);
    }

    public int userToScreenH(double h) {
        return (int)(h * Options.ppcm * Options.aspect);
    }

    public double screenToUserX(int x) {
        return (double)(x - this.ori_x) / Options.ppcm;
    }

    public double screenToUserY(int y) {
        return (double)(this.ori_y - y) / (Options.ppcm * Options.aspect);
    }

    public double screenToUserW(int w) {
        return (double)w / Options.ppcm;
    }

    public double screenToUserH(int h) {
        return (double)(-h) / (Options.ppcm * Options.aspect);
    }

    private double getTickStep(int tickstyle, double ppcm) {
        int nz;
        double logk = Math.log10((double)(tickstyle * 37) / ppcm);
        double res = (logk -= (double)(nz = (int)Math.floor(logk))) > 0.849 ? 10.0 : (logk > 0.5 ? 5.0 : (logk > 0.151 ? 2.0 : 1.0));
        return res * Math.pow(10.0, nz);
    }

    private String getLabelStr(double spot) {
        String s = Double.toString(spot);
        int n = s.indexOf(".");
        if (n >= 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    private void draw_Tick(double lx, double ly) {
        int sx = this.userToScreenX(lx);
        int sy = this.userToScreenY(ly);
        if (Math.abs(sy - this.ori_y) > 3) {
            this.graphics.drawLine(sx - 3, sy, sx + 3, sy);
        }
        if (Math.abs(sx - this.ori_x) > 3) {
            this.graphics.drawLine(sx, sy - 3, sx, sy + 3);
        }
    }

    private void letter_Axis(double atx0, double aty0, double tsx, double tsy) {
        String s;
        int sx;
        FontRenderContext frc = this.graphics.getFontRenderContext();
        double lx = atx0;
        double ly = aty0;
        int sy = this.userToScreenY(0.0);
        while (lx < this.x_max) {
            if (Math.abs(lx) < tsx / 2.0) {
                lx += tsx;
            }
            sx = this.userToScreenX(lx);
            s = this.getLabelStr(lx);
            Rectangle2D r = this.graphics.getFont().getStringBounds(s, 0, s.length(), frc);
            int dx = (int)Math.rint(r.getWidth() / 2.0);
            int dy = (int)Math.rint(r.getHeight() + 5.0);
            this.graphics.drawLine(sx, sy - 3, sx, sy + 3);
            this.graphics.drawString(s, sx - dx, sy + dy);
            lx += tsx;
        }
        sx = this.userToScreenX(0.0);
        while (ly < this.y_max) {
            if (Math.abs(ly) < tsy / 2.0) {
                ly += tsy;
            }
            sy = this.userToScreenY(ly);
            s = this.getLabelStr(ly);
            this.graphics.drawLine(sx - 3, sy, sx + 3, sy);
            this.graphics.drawString(s, sx + 10, sy + 5);
            ly += tsy;
        }
    }

    private void updateBorders() {
        this.x_min = this.screenToUserX(0);
        this.x_max = this.screenToUserX(this.getWidth());
        this.y_max = this.screenToUserY(0);
        this.y_min = this.screenToUserY(this.getHeight());
        this.setHorizon();
    }

    private void setHorizon() {
        double dx = Math.abs(this.x_max - this.x_min);
        double dy = Math.abs(this.y_max - this.y_min);
        this.hx_min = Math.max(this.x_min - 10.0 * dx, -1.0E8);
        this.hx_max = Math.min(this.x_max + 10.0 * dx, 1.0E8);
        this.hy_min = Math.max(this.y_min - 10.0 * dy, -1.0E8);
        this.hy_max = Math.min(this.y_max + 10.0 * dy, 1.0E8);
    }

    private BufferedImage createBrushImage(int brushStyle, Color col) {
        GraphicsConfiguration gfxConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage res = gfxConf.createCompatibleImage(7, 7, 3);
        Graphics2D gc = res.createGraphics();
        gc.setBackground(new Color(255, 255, 255, 0));
        gc.clearRect(0, 0, 7, 7);
        if (brushStyle == 0) {
            gc.setColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), 127));
        } else {
            gc.setColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), 255));
        }
        switch (brushStyle) {
            case 2: {
                gc.drawLine(0, 3, 6, 3);
                break;
            }
            case 3: {
                gc.drawLine(3, 0, 3, 6);
                break;
            }
            case 4: {
                gc.drawLine(0, 0, 6, 6);
                break;
            }
            case 5: {
                gc.drawLine(0, 6, 6, 0);
                break;
            }
            case 6: {
                gc.drawLine(0, 3, 6, 3);
                gc.drawLine(3, 0, 3, 6);
                break;
            }
            case 7: {
                gc.drawLine(0, 0, 6, 6);
                gc.drawLine(0, 6, 6, 0);
                break;
            }
            case 8: {
                int i = 0;
                while (i < 30) {
                    int x = (int)MyMath.random(7);
                    int y = (int)MyMath.random(7);
                    gc.drawLine(x, y, x + 1, y);
                    ++i;
                }
            }
            case 0: {
                gc.fillRect(0, 0, 8, 8);
            }
        }
        return res;
    }
}

