/*
 * Decompiled with CFR 0.152.
 */
package dgmath;

public class Lgs {
    private double[][] ko;
    private static final double epsilon = 1.0E-12;

    public Lgs(int iEquaCount, int iVarCount) {
        this.redim(iEquaCount, iVarCount);
    }

    private double safeSub(double b, double c) {
        double sum_bc = Math.abs(b) + Math.abs(c);
        if (sum_bc > 1.0E-12 && Math.abs(b - c) / sum_bc >= 1.0E-12) {
            return b - c;
        }
        return 0.0;
    }

    private int equaCount() {
        return this.ko.length - 1;
    }

    private int varCount() {
        if (this.ko.length > 0) {
            return this.ko[0].length - 1;
        }
        return 0;
    }

    private int intSpur() {
        int n = 0;
        int i = 1;
        while (i <= this.equaCount() && i <= this.varCount()) {
            n += (int)Math.round(this.ko[i][i]);
            ++i;
        }
        return n;
    }

    private boolean contradiction() {
        int i = 1;
        while (i <= this.equaCount() && i <= this.varCount()) {
            if (Math.abs(this.ko[i][i]) < 1.0E-12 && Math.abs(this.ko[i][0]) > 1.0E-12) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void redim(int iEquaCount, int iVarCount) {
        this.ko = new double[iEquaCount + 1][iVarCount + 1];
        int i = 0;
        while (i <= iEquaCount) {
            int j = 0;
            while (j <= iVarCount) {
                this.ko[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        this.ko[0][0] = -1.0;
    }

    private void exchangeEquations(int n1, int n2) {
        if (n1 != n2) {
            int i = 0;
            while (i <= this.equaCount()) {
                double pu = this.ko[n1][i];
                this.ko[n1][i] = this.ko[n2][i];
                this.ko[n2][i] = pu;
                ++i;
            }
        }
    }

    private void divideEquation(int nr, double factor) {
        int i = 0;
        while (i <= this.varCount()) {
            double[] dArray = this.ko[nr];
            int n = i++;
            dArray[n] = dArray[n] / factor;
        }
    }

    private void subtEquation(int dest, double factor, int source) {
        int i = 0;
        while (i <= this.varCount()) {
            this.ko[dest][i] = this.safeSub(this.ko[dest][i], this.ko[source][i] * factor);
            ++i;
        }
    }

    private void pivotExchange(int n) {
        if (n < this.equaCount()) {
            int k = n;
            while (k <= this.equaCount()) {
                double sf = 0.0;
                int i = k;
                while (i <= this.varCount()) {
                    sf += this.ko[k][i] * this.ko[k][i];
                    ++i;
                }
                if (sf > 0.0) {
                    sf = Math.sqrt(sf);
                    i = n;
                    while (i <= this.varCount()) {
                        this.ko[k][i] = this.ko[k][i] / sf;
                        ++i;
                    }
                    this.ko[k][0] = this.ko[k][0] / sf;
                }
                ++k;
            }
            int i = n;
            int k2 = n + 1;
            while (k2 <= this.equaCount()) {
                if (Math.abs(this.ko[k2][n]) > Math.abs(this.ko[i][n])) {
                    i = k2;
                }
                ++k2;
            }
            this.exchangeEquations(n, i);
        }
    }

    public void setEquation(int nr, double[] koeff) {
        int i = 0;
        while (i <= this.varCount()) {
            this.ko[nr][i] = koeff[i];
            ++i;
        }
    }

    public void getEquation(int nr, double[] koeff) {
        int i = 0;
        while (i <= this.varCount()) {
            koeff[i] = this.ko[nr][i];
            ++i;
        }
    }

    public void diagonalize() {
        int i;
        int m = this.equaCount() >= this.varCount() ? this.varCount() : this.equaCount();
        int k = 1;
        while (k <= m) {
            this.pivotExchange(k);
            if (this.ko[k][k] != 0.0) {
                this.divideEquation(k, this.ko[k][k]);
                i = 1;
                while (i <= this.equaCount()) {
                    if (i != k) {
                        this.subtEquation(i, this.ko[i][k], k);
                    }
                    ++i;
                }
            }
            ++k;
        }
        k = this.intSpur();
        if (k == this.varCount()) {
            this.ko[0][0] = 1.0;
            i = 1;
            while (i <= this.varCount()) {
                this.ko[0][i] = this.ko[i][0];
                ++i;
            }
        } else {
            this.ko[0][0] = this.contradiction() ? 0.0 : 2.0;
        }
    }
}

