/*
 * Decompiled with CFR 0.152.
 */
package dgmath;

import dgmath.Lgs;
import dgmath.V3List;
import dgmath.Vector3;
import java.util.Calendar;
import java.util.Random;

public final class MyMath {
    public static final double epsilon = 1.0E-12;
    public static final double distEpsilon = 1.0E-6;
    public static final double angleEpsilon = 1.74533E-4;
    public static final double paramEpsilon = 1.0E-6;
    public static final double maxBending = 0.01;
    public static final double maxGradient = 1000.0;
    public static final double sqrt2 = Math.sqrt(2.0);
    public static final double twoPI = Math.PI * 2;
    public static final double degPerRad = 57.29577951308232;
    private static final Random randGen = new Random();

    public static int gcd(int a, int b) {
        int r;
        if (b > a) {
            r = a;
            a = b;
            b = r;
        }
        while (b > 0) {
            r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double gt2ui(double t) {
        double res;
        if (Math.abs(t) < 1.0E-6) {
            res = t;
        } else {
            double z = -0.5 / t;
            double w = Math.sqrt(MyMath.sqr(z) + 1.0);
            res = t > 0.0 ? z + w : z - w;
        }
        return res;
    }

    public static double ui2gt(double p) {
        double res;
        try {
            res = p / (1.0 - MyMath.sqr(p));
        }
        catch (ArithmeticException e) {
            res = p > 0.5 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        return res;
    }

    public static double mvArg(double vx, double vy) {
        double pa = Math.atan2(vy, vx);
        if (pa < 0.0) {
            pa += Math.PI * 2;
        }
        return pa;
    }

    public static double signedAngle(double ax, double ay, double bx, double by) {
        double res = MyMath.mvArg(ax, ay) - MyMath.mvArg(bx, by);
        if (res > Math.PI) {
            res -= Math.PI * 2;
        } else if (res < -Math.PI) {
            res += Math.PI * 2;
        }
        return res;
    }

    public static double rad2deg(double radAngle) {
        return radAngle * 57.29577951308232;
    }

    public static double deg2rad(double degAngle) {
        return degAngle / 57.29577951308232;
    }

    public static double arcsin(double x) {
        if (Math.abs(x) < 0.999999) {
            return Math.atan(x / Math.sqrt(1.0 - MyMath.sqr(x)));
        }
        if (x > 0.0) {
            return 1.5707963267948966;
        }
        return -1.5707963267948966;
    }

    public static double arccos(double x) {
        if (Math.abs(x) < 0.999999) {
            return 1.5707963267948966 - Math.atan(x / Math.sqrt(1.0 - MyMath.sqr(x)));
        }
        if (x > 0.0) {
            return 0.0;
        }
        return Math.PI;
    }

    public static double getNormingValue(double x, double y, double z, double dd) {
        double res;
        if (dd < 1.0E-12) {
            dd = 1.0E-12;
        }
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        if (x < 1.0E-12) {
            x = 0.0;
        }
        if (y < 1.0E-12) {
            y = 0.0;
        }
        if (z < 1.0E-12) {
            z = 0.0;
        }
        if ((res = Math.sqrt(MyMath.sqr(x) + MyMath.sqr(y) + MyMath.sqr(z))) > 1.0E-12) {
            double p;
            if (z > y) {
                p = z;
                z = y;
                y = p;
            }
            if (y > x) {
                p = y;
                y = x;
                x = p;
            }
            if (z > y) {
                p = z;
                z = y;
                y = p;
            }
            if (MyMath.isInteger(x, dd) && MyMath.isInteger(y, dd) && MyMath.isInteger(z, dd)) {
                res = z > 1.0E-12 ? (double)MyMath.gcd(MyMath.gcd((int)Math.rint(x), (int)Math.rint(y)), (int)Math.rint(z)) : (y > 1.0E-12 ? (double)MyMath.gcd((int)Math.rint(x), (int)Math.rint(y)) : Math.rint(x));
            }
        }
        return res;
    }

    public static Vector3 getTV(double[] p) {
        Vector3 res = new Vector3();
        res.setValid(true);
        double dx = p[2] - p[0];
        double dy = p[3] - p[1];
        double adx = Math.abs(dx);
        double ady = Math.abs(dy);
        if (adx > ady) {
            if (adx > 1.0E-12) {
                res.x = (p[4] - p[0]) / dx;
            }
        } else if (ady > 1.0E-12) {
            res.x = (p[5] - p[1]) / dy;
        } else {
            res.setValid(false);
        }
        return res;
    }

    public static double[] rotateVector2(double[] v2, double angle) {
        double[][] mat = MyMath.initRotMat(angle);
        double[] res = MyMath.mapPt(mat, v2);
        return res;
    }

    public static double frac(double x) {
        boolean neg = x < 0.0;
        x = Math.abs(x);
        double rx = Math.floor(x);
        if (neg) {
            return rx - x;
        }
        return x - rx;
    }

    public static double random(int n) {
        if (n == 0) {
            return randGen.nextDouble();
        }
        n = Math.abs(n);
        return randGen.nextInt(n);
    }

    public static double[] solveQuadraticEquation(double a, double b, double c) {
        double[] res = new double[3];
        double d = Math.sqrt(MyMath.sqr(a) + MyMath.sqr(b) + MyMath.sqr(c));
        if (d > 1.0E-12) {
            a /= d;
            b /= d;
            c /= d;
            if (Math.abs(a) > 1.0E-12) {
                d = MyMath.sqr(b) - 4.0 * a * c;
                if (d > -1.0E-12) {
                    if (d > 1.0E-12) {
                        d = Math.sqrt(d);
                        double q = b > 0.0 ? (b + d) / -2.0 : (b - d) / -2.0;
                        res[1] = q / a;
                        res[2] = c / q;
                        res[0] = 2.0;
                    } else {
                        res[1] = -b / (2.0 * a);
                        res[0] = 1.0;
                    }
                } else {
                    res[0] = 0.0;
                }
            } else if (Math.abs(b) > 1.0E-12) {
                res[1] = -c / b;
                res[0] = 1.0;
            } else {
                res[0] = Math.abs(c) > 1.0E-12 ? 0.0 : -1.0;
            }
            if (Math.abs(c) < 1.0E-12 && res[0] > 0.0) {
                long n = Math.round(res[0]);
                if (n == 1L) {
                    res[0] = 0.0;
                } else if (Math.abs(res[2]) > Math.abs(res[1])) {
                    res[1] = 0.0;
                } else {
                    res[2] = 0.0;
                }
            }
        } else {
            res[0] = -1.0;
        }
        return res;
    }

    public static double[] solveCubicEquation(double a, double b, double c, double d) {
        double[] res = new double[]{0.0, 0.0, 0.0, 0.0};
        int n = 0;
        if (Math.abs(a) > 1.0E-12) {
            double q3;
            b /= a;
            c /= a;
            d /= a;
            a = b;
            b = c;
            c = d;
            double q = (MyMath.sqr(a) - 3.0 * b) / 9.0;
            double r = (2.0 * Math.pow(a, 3.0) - 9.0 * a * b + 27.0 * c) / 54.0;
            double r2 = MyMath.sqr(r);
            d = r2 - (q3 = Math.pow(q, 3.0));
            if (d < 0.0) {
                double w = Math.acos(r / Math.sqrt(q3));
                double v = -2.0 * Math.sqrt(q);
                res[1] = MyMath.iterate(a, b, c, v * Math.cos(w / 3.0) - a / 3.0);
                res[2] = MyMath.iterate(a, b, c, v * Math.cos((w + Math.PI * 2) / 3.0) - a / 3.0);
                res[3] = MyMath.iterate(a, b, c, v * Math.cos((w - Math.PI * 2) / 3.0) - a / 3.0);
                n = 3;
            } else {
                double _A = Math.pow(Math.abs(r) + Math.sqrt(d), 0.0);
                if (r > 0.0) {
                    _A = -_A;
                }
                double _B = Math.abs(_A) > 1.0E-12 ? q / _A : 0.0;
                res[1] = _A + _B - a / 3.0;
                if (Math.abs(d) > 1.0E-12) {
                    res[1] = MyMath.iterate(a, b, c, res[1]);
                    n = 1;
                } else if (Math.abs(r2) > 1.0E-12) {
                    res[2] = -0.5 * (_A + _B) - a / 3.0;
                    res[1] = MyMath.iterate(a, b, c, res[1]);
                    n = 2;
                } else {
                    n = 1;
                }
            }
            if (Math.abs(c) < 1.0E-12 && n > 0) {
                switch (n) {
                    case 1: {
                        res[1] = 0.0;
                        break;
                    }
                    case 2: {
                        if (Math.abs(res[2]) > Math.abs(res[1])) {
                            res[1] = 0.0;
                            break;
                        }
                        res[2] = 0.0;
                        break;
                    }
                    case 3: {
                        if (Math.abs(res[3]) > Math.abs(res[2])) {
                            if (Math.abs(res[2]) > Math.abs(res[1])) {
                                res[1] = 0.0;
                                break;
                            }
                            res[2] = 0.0;
                            break;
                        }
                        if (Math.abs(res[3]) > Math.abs(res[1])) {
                            res[1] = 0.0;
                            break;
                        }
                        res[3] = 0.0;
                    }
                }
            }
            res[0] = n;
        } else {
            double[] res2 = MyMath.solveQuadraticEquation(b, c, d);
            res[0] = res2[0];
            res[1] = res2[1];
            res[2] = res2[2];
        }
        return res;
    }

    public static Vector3 intersectLines(Vector3 g1, Vector3 g2) {
        Vector3 res = new Vector3();
        double det = g1.x * g2.y - g2.x * g1.y;
        if (Math.abs(det) > 1.0E-12) {
            res.x = (g2.y * g1.z - g1.y * g2.z) / det;
            res.y = (g1.x * g2.z - g2.x * g1.z) / det;
            res.z = 1.0;
        } else {
            res.z = 0.0;
        }
        return res;
    }

    public static Vector3 intersectLines(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        Vector3 res = new Vector3();
        double x21 = x2 - x1;
        double y34 = y4 - y3;
        double y21 = y2 - y1;
        double x34 = x4 - x3;
        double s = MyMath.safeSub(x21 * y34, y21 * x34);
        if (Math.abs(s) > 1.0E-12) {
            s = (y21 * (x3 - x1) - x21 * (y3 - y1)) / s;
            res.x = x3 + s * x34;
            res.y = y3 + s * y34;
            res.setValid(true);
        } else {
            res.setValid(false);
        }
        return res;
    }

    public static double[] intersectLineAndRectangle(Vector3 line, double[] r) {
        double y;
        double x;
        double[] res = new double[6];
        double xmin = r[0];
        double ymin = r[1];
        double xmax = r[2];
        double ymax = r[3];
        int found = 0;
        if (Math.abs(line.y) > 1.0E-12) {
            x = xmin;
            y = (line.z - line.x * x) / line.y;
            if (y <= ymax && y >= ymin) {
                res[0] = x;
                res[1] = y;
                res[2] = 1.0;
                ++found;
            }
            if ((y = (line.z - line.x * (x = xmax)) / line.y) <= ymax && y >= ymin) {
                if (found == 0) {
                    res[0] = x;
                    res[1] = y;
                    res[2] = 1.0;
                } else {
                    res[3] = x;
                    res[4] = y;
                    res[5] = 1.0;
                }
                ++found;
            }
        }
        if (found < 2 && Math.abs(line.x) > 1.0E-12) {
            y = ymin;
            x = (line.z - line.y * y) / line.x;
            if (x <= xmax && x >= xmin) {
                if (found == 0) {
                    res[0] = x;
                    res[1] = y;
                    res[2] = 1.0;
                } else {
                    res[3] = x;
                    res[4] = y;
                    res[5] = 1.0;
                }
                ++found;
            }
            if ((x = (line.z - line.y * (y = ymax)) / line.x) <= xmax && x >= xmin) {
                if (found == 0) {
                    res[0] = x;
                    res[1] = y;
                    res[2] = 1.0;
                } else {
                    res[3] = x;
                    res[4] = y;
                    res[5] = 1.0;
                }
                ++found;
            }
        }
        return res;
    }

    public static double[] intersectLineAndCircle(Vector3 hl, Vector3 c) {
        double[] res = new double[6];
        res[2] = 0.0;
        res[5] = 0.0;
        if (hl != null && c != null) {
            long n;
            double p;
            if (Math.abs(hl.x) >= Math.abs(hl.y)) {
                p = 2.0 * (hl.x * (hl.y * c.x - hl.x * c.y) - hl.y * hl.z);
                double q = MyMath.sqr(hl.x) * (MyMath.sqr(c.x) + MyMath.sqr(c.y) - MyMath.sqr(c.z)) - hl.z * (2.0 * hl.x * c.x - hl.z);
                double[] qer = MyMath.solveQuadraticEquation(1.0, p, q);
                n = Math.round(qer[0]);
                if (n >= 1L) {
                    res[1] = qer[1];
                    res[0] = (-hl.y * qer[1] + hl.z) / hl.x;
                    res[2] = 1.0;
                    if (n == 2L) {
                        res[4] = qer[2];
                        res[3] = (-hl.y * qer[2] + hl.z) / hl.x;
                        res[5] = 1.0;
                    }
                }
            } else {
                p = 2.0 * (hl.y * (hl.x * c.y - hl.y * c.x) - hl.x * hl.z);
                double q = MyMath.sqr(hl.y) * (MyMath.sqr(c.x) + MyMath.sqr(c.y) - MyMath.sqr(c.z)) - hl.z * (2.0 * hl.y * c.y - hl.z);
                double[] qer = MyMath.solveQuadraticEquation(1.0, p, q);
                n = Math.round(qer[0]);
                if (n >= 1L) {
                    res[0] = qer[1];
                    res[1] = (-hl.x * qer[1] + hl.z) / hl.y;
                    res[2] = 1.0;
                    if (n == 2L) {
                        res[3] = qer[2];
                        res[4] = (-hl.x * qer[2] + hl.z) / hl.y;
                        res[5] = 1.0;
                    }
                }
            }
            if (n == 2L && hl.y * (res[3] - res[0]) - hl.x * (res[4] - res[1]) < 0.0) {
                p = res[3];
                res[3] = res[0];
                res[0] = p;
                p = res[4];
                res[4] = res[1];
                res[1] = p;
            }
        }
        return res;
    }

    public static double[] intersectLineAndConic(Vector3 g, double[] co) {
        double[] res = new double[6];
        if (g != null && co != null) {
            double a = co[0];
            double b = co[1];
            double c = co[2];
            double d = co[3];
            double e = co[4];
            double f = co[5];
            double h = g.x;
            double j = g.y;
            double k = -g.z;
            if (Math.abs(j) > Math.abs(h)) {
                double p = a - 2.0 * b * h / j + c * MyMath.sqr(h / j);
                double q = 2.0 * (d - (e * h + b * k) / j + c * h * k / MyMath.sqr(j));
                double r = f - 2.0 * e * k / j + c * MyMath.sqr(k / j);
                double[] qer = MyMath.solveQuadraticEquation(p, q, r);
                long n = Math.round(qer[0]);
                res[2] = 0.0;
                res[5] = 0.0;
                if (n >= 1L) {
                    res[0] = qer[1];
                    res[1] = (-h * qer[1] - k) / j;
                    res[2] = 1.0;
                    if (n == 2L) {
                        res[3] = qer[2];
                        res[4] = (-h * qer[2] - k) / j;
                        res[5] = 1.0;
                    }
                }
            } else {
                double p = a * MyMath.sqr(j / h) - 2.0 * b * j / h + c;
                double q = 2.0 * (a * j * k / MyMath.sqr(h) - (b * k + d * j) / h + e);
                double r = a * MyMath.sqr(k / h) - 2.0 * d * k / h + f;
                double[] qer = MyMath.solveQuadraticEquation(p, q, r);
                long n = Math.round(qer[0]);
                res[2] = 0.0;
                res[5] = 0.0;
                if (n >= 1L) {
                    res[1] = qer[1];
                    res[0] = (-j * qer[1] - k) / h;
                    res[2] = 1.0;
                    if (n == 2L) {
                        res[4] = qer[2];
                        res[3] = (-j * qer[2] - k) / h;
                        res[5] = 1.0;
                    }
                }
            }
        }
        return res;
    }

    public static double[] intersectCircles(Vector3 c1, Vector3 c2) {
        Vector3 chord = MyMath.getChordalLineFromCircles(c1, c2);
        double[] res = MyMath.intersectLineAndCircle(chord, c1);
        return res;
    }

    public static double[] intersectConics(double[] co1, double[] co2) {
        double z;
        double w;
        double v;
        double[] res = new double[12];
        double[] degco = new double[6];
        double[] truco = new double[6];
        double np = 1.0 / Math.sqrt(MyMath.sqr(co1[0]) + MyMath.sqr(co1[1]) + MyMath.sqr(co1[2]));
        double a1 = np * co1[0];
        double b1 = np * co1[1];
        double c1 = np * co1[2];
        double d1 = np * co1[3];
        double e1 = np * co1[4];
        double f1 = np * co1[5];
        np = 1.0 / Math.sqrt(MyMath.sqr(co2[0]) + MyMath.sqr(co2[1]) + MyMath.sqr(co2[2]));
        double a2 = np * co2[0];
        double b2 = np * co2[1];
        double c2 = np * co2[2];
        double d2 = np * co2[3];
        double e2 = np * co2[4];
        double f2 = np * co2[5];
        double u = a2 * (MyMath.sqr(e2) - c2 * f2) + b2 * (b2 * f2 - e2 * d2) + d2 * (c2 * d2 - b2 * e2);
        double[] s = MyMath.solveCubicEquation(u, v = a1 * (c2 * f2 - MyMath.sqr(e2)) + c1 * (a2 * f2 - MyMath.sqr(d2)) + f1 * (a2 * c2 - MyMath.sqr(b2)) + 2.0 * (e1 * (b2 * d2 - a2 * e2) + b1 * (d2 * e2 - b2 * f2) + d1 * (b2 * e2 - c2 * d2)), w = a2 * (MyMath.sqr(e1) - c1 * f1) + c2 * (MyMath.sqr(d1) - a1 * f1) + f2 * (MyMath.sqr(b1) - a1 * c1) + 2.0 * (e2 * (a1 * e1 - b1 * d1) + b2 * (b1 * f1 - d1 * e1) + d2 * (c1 * d1 - b1 * e1)), z = a1 * (c1 * f1 - MyMath.sqr(e1)) + b1 * (e1 * d1 - b1 * f1) + d1 * (b1 * e1 - c1 * d1));
        int n = MyMath.double2int(s[0]);
        if (n > 0) {
            u = s[1];
            if (n > 1) {
                if (Math.abs(s[2]) > Math.abs(u)) {
                    u = s[2];
                }
                if (n > 2 && Math.abs(s[3]) > Math.abs(u)) {
                    u = s[3];
                }
            }
            degco[0] = a1 - u * a2;
            degco[1] = b1 - u * b2;
            degco[2] = c1 - u * c2;
            degco[3] = d1 - u * d2;
            degco[4] = e1 - u * e2;
            degco[5] = f1 - u * f2;
            if (Math.abs(u) > 1.0) {
                truco[0] = a1;
                truco[1] = b1;
                truco[2] = c1;
                truco[3] = d1;
                truco[4] = e1;
                truco[5] = f1;
            } else {
                truco[0] = a2;
                truco[1] = b2;
                truco[2] = c2;
                truco[3] = d2;
                truco[4] = e2;
                truco[5] = f2;
            }
        } else {
            double dg1 = co1[0] * (co1[2] * co1[5] - MyMath.sqr(co1[4])) + co1[1] * (co1[4] * co1[3] - co1[1] * co1[5]) + co1[3] * (co1[1] * co1[4] - co1[2] * co1[3]);
            double dg2 = co2[0] * (co2[2] * co2[5] - MyMath.sqr(co2[4])) + co2[1] * (co2[4] * co2[3] - co2[1] * co2[5]) + co2[3] * (co2[1] * co2[4] - co2[2] * co2[3]);
            if (Math.abs(dg1) < Math.abs(dg2)) {
                degco[0] = a1;
                degco[1] = b1;
                degco[2] = c1;
                degco[3] = d1;
                degco[4] = e1;
                degco[5] = f1;
                truco[0] = a2;
                truco[1] = b2;
                truco[2] = c2;
                truco[3] = d2;
                truco[4] = e2;
                truco[5] = f2;
            } else {
                degco[0] = a2;
                degco[1] = b2;
                degco[2] = c2;
                degco[3] = d2;
                degco[4] = e2;
                degco[5] = f2;
                truco[0] = a1;
                truco[1] = b1;
                truco[2] = c1;
                truco[3] = d1;
                truco[4] = e1;
                truco[5] = f1;
            }
        }
        double[] params = MyMath.getConicParamsFromCoeff(degco, 0.0);
        int ct = MyMath.double2int(params[0]);
        if (ct >= 2 && ct <= 5) {
            Vector3 g1 = new Vector3(params[11], params[12], params[13]);
            double[] res1 = MyMath.intersectLineAndConic(g1, truco);
            System.arraycopy(res1, 0, res, 0, 6);
            if (ct != 3) {
                Vector3 g2 = new Vector3(params[14], params[15], params[16]);
                double[] res2 = MyMath.intersectLineAndConic(g2, truco);
                System.arraycopy(res2, 0, res, 6, 6);
            }
        }
        return res;
    }

    public static Vector3 getPedalPoint(Vector3 g, Vector3 p) {
        Vector3 res = new Vector3();
        double b2 = g.x * g.x + g.y * g.y;
        if (Math.abs(b2) > 1.0E-12) {
            double t = (-g.x * p.x - g.y * p.y + g.z) / b2;
            res.x = p.x + t * g.x;
            res.y = p.y + t * g.y;
            res.setValid(true);
        } else {
            res.setValid(false);
        }
        return res;
    }

    public static Vector3 getPedalPoint(Vector3 line, double[] p) {
        Vector3 pv = new Vector3(p[0], p[1], 0.0);
        return MyMath.getPedalPoint(line, pv);
    }

    public static Vector3 getPedalPoint(double[] line, double[] p) {
        Vector3 g = new Vector3(line[0], line[1], line[2]);
        return MyMath.getPedalPoint(g, p);
    }

    public static Vector3 getProjPoint(double[] sourcePt, Vector3 targetLine, Vector3 projDir) {
        Vector3 dir = MyMath.getDirectionFromHesseEq(projDir);
        Vector3 parLine = MyMath.getHesseEqFromPtAndDir(sourcePt, dir);
        return MyMath.intersectLines(targetLine, parLine);
    }

    public static boolean tooMuchBending(Vector3 a, Vector3 b, Vector3 c) {
        if (a == null || b == null || c == null) {
            return false;
        }
        if (a.tag >= 0 && b.tag >= 0 && c.tag >= 0) {
            double[] v1 = new double[]{b.x - a.x, b.y - a.y};
            double[] v2 = new double[]{c.x - b.x, c.y - b.y};
            double cosw = MyMath.getCosBetween(v1, v2);
            return cosw < 0.99;
        }
        return false;
    }

    public static double hypot(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }

    public static double distPt2Line(double[] g, double px, double py) {
        if (MyMath.hypot(g[0], g[1]) > 1.0E-12) {
            return Math.abs(g[0] * px + g[1] * py - g[2]);
        }
        return 1.0E20;
    }

    public static double oriDistPt2Line(double[] g, double px, double py) {
        if (MyMath.hypot(g[0], g[1]) > 1.0E-12) {
            return g[0] * px + g[1] * py - g[2];
        }
        return 1.0E20;
    }

    public static double distPt2ShortLn(double x1, double y1, double x2, double y2, double x, double y) {
        double dx1 = x - x1;
        double dx12 = x2 - x1;
        double dy1 = y - y1;
        double dy12 = y2 - y1;
        if (dx1 * dx12 + dy1 * dy12 >= 0.0) {
            double dx2 = x2 - x;
            double dy2 = y2 - y;
            if (dx2 * dx12 + dy2 * dy12 >= 0.0) {
                double d = MyMath.hypot(dx12, dy12);
                if (d > 1.0E-6) {
                    return Math.abs((dx1 * dy12 - dy1 * dx12) / d);
                }
                return Math.hypot(dx1, dy1);
            }
            return Math.hypot(dx2, dy2);
        }
        return Math.hypot(dx1, dy1);
    }

    public static boolean ptInRect(double mx, double my, double x1, double y1, double x2, double y2) {
        return mx > x1 && mx < x2 && my < y1 && my > y2;
    }

    public static Vector3 getLineParamFromPt(Vector3 g, double[] p) {
        Vector3 res = MyMath.getPedalPoint(g, p);
        double[] origin = new double[]{0.0, 0.0};
        Vector3 foot = MyMath.getPedalPoint(g, origin);
        double dx = res.x - foot.x;
        double dy = res.y - foot.y;
        double r = MyMath.hypot(dx, dy);
        Vector3 dir = MyMath.getDirectionFromHesseEq(g);
        if (Math.abs(dir.x) > Math.abs(dir.y)) {
            if (Math.signum(dir.x) != Math.signum(dx)) {
                r = -r;
            }
        } else if (Math.signum(dir.y) != Math.signum(dy)) {
            r = -r;
        }
        res.z = r;
        return res;
    }

    public static Vector3 getLineParamFromPt(double[] line, double[] p) {
        Vector3 g = new Vector3(line[0], line[1], line[2]);
        return MyMath.getLineParamFromPt(g, p);
    }

    public static double[] getLinePtFromParam(double[] g, double t, double x0, double y0) {
        double[] res = new double[]{x0 + t * g[1], y0 - t * g[0]};
        return res;
    }

    public static double[] getLinePtFromParam(Vector3 g, double t) {
        double[] res = new double[]{0.0, 0.0};
        Vector3 fo = MyMath.getPedalPoint(g, res);
        res[0] = fo.x + t * g.y;
        res[1] = fo.y - t * g.x;
        return res;
    }

    public static double[] getSegmentParamFromPt(Vector3 s, double[] p) {
        Vector3 foot;
        double[] res = new double[3];
        if (s == null) {
            double[] pt = new double[]{p[2], p[3]};
            Vector3 dir = new Vector3(p[4] - p[2], p[5] - p[3], 0.0);
            s = MyMath.getHesseEqFromPtAndDir(pt, dir);
        }
        if ((foot = MyMath.getPedalPoint(s, p)) != null) {
            res[0] = foot.x;
            res[1] = foot.y;
            double dx = p[4] - p[2];
            double dy = p[5] - p[3];
            res[2] = Math.abs(dx) > Math.abs(dy) ? (res[0] - p[2]) / dx : (res[1] - p[3]) / dy;
        } else {
            res[0] = p[2];
            res[1] = p[3];
            res[2] = 0.0;
        }
        return res;
    }

    public static double[] getSegmentPtFromParam(double[] s, double t) {
        double[] res = new double[]{s[0] + t * (s[2] - s[0]), s[1] + t * (s[3] - s[1])};
        return res;
    }

    public static double[] getCircleParamFromPt(Vector3 c, double[] p) {
        double[] res = new double[3];
        double dx = p[0] - c.x;
        double dy = p[1] - c.y;
        double d = MyMath.hypot(dx, dy);
        if (d > 1.0E-12) {
            res[0] = c.x + dx * c.z / d;
            res[1] = c.y + dy * c.z / d;
            res[2] = MyMath.mvArg(dx, dy) / (Math.PI * 2);
        } else {
            res[0] = c.x + c.z;
            res[1] = c.y;
            res[2] = 0.0;
        }
        return res;
    }

    public static double[] getCirclePtFromParam(Vector3 c, double t) {
        double[] res = new double[]{c.x + c.z * Math.cos(t *= Math.PI * 2), c.y + c.z * Math.sin(t)};
        return res;
    }

    public static double[] getArcParamFromPt(Vector3 c, double sa, double ea, double[] p) {
        while (ea >= Math.PI * 2) {
            ea -= Math.PI * 2;
        }
        while (sa < 0.0) {
            sa += Math.PI * 2;
        }
        double[] res = new double[3];
        double dx = p[0] - c.x;
        double dy = p[1] - c.y;
        double pa = MyMath.mvArg(dx, dy);
        if (ea > sa) {
            if (pa < sa || pa > ea) {
                if (pa < sa || pa > (ea + sa + Math.PI * 2) / 2.0) {
                    pa = sa;
                    res[2] = 0.0;
                } else {
                    pa = ea;
                    res[2] = 1.0;
                }
            } else {
                res[2] = (pa - sa) / (ea - sa);
            }
        } else if (pa < sa && pa > ea) {
            if (pa >= (sa + ea) / 2.0) {
                pa = sa;
                res[2] = 0.0;
            } else {
                pa = ea;
                res[2] = 1.0;
            }
        } else {
            if (pa < sa) {
                pa += Math.PI * 2;
            }
            res[2] = (pa - sa) / (ea + Math.PI * 2 - sa);
        }
        res[0] = c.x + c.z * Math.cos(pa);
        res[1] = c.y + c.z * Math.sin(pa);
        return res;
    }

    public static double[] getArcPtFromParam(Vector3 c, double sa, double ea, double t) {
        while (ea < sa) {
            ea += Math.PI * 2;
        }
        double[] res = new double[2];
        double pa = sa + (ea - sa) * t;
        res[0] = c.x + c.z * Math.cos(pa);
        res[1] = c.y + c.z * Math.sin(pa);
        return res;
    }

    public static Vector3 getNormalizedVector(Vector3 v) {
        Vector3 res = new Vector3();
        double d = Math.sqrt(MyMath.sqr(v.x) + MyMath.sqr(v.y) + MyMath.sqr(v.z));
        if (d > 1.0E-12) {
            res.x = v.x / d;
            res.y = v.y / d;
            res.z = v.z / d;
        } else {
            res.setValid(false);
        }
        return res;
    }

    public static Vector3 getHesseEqFromPtAndDir(double[] p, Vector3 v) {
        Vector3 res = new Vector3();
        double d = MyMath.hypot(v.x, v.y);
        if (d > 1.0E-12) {
            res.x = -v.y / d;
            res.y = v.x / d;
            res.z = p[0] * res.x + p[1] * res.y;
            res.setValid(true);
        } else {
            res.setValid(false);
        }
        return res;
    }

    public static Vector3 getHesseEqFromPtAndDir(double[] p, double[] v) {
        Vector3 dir = new Vector3(v[0], v[1], 0.0);
        return MyMath.getHesseEqFromPtAndDir(p, dir);
    }

    public static Vector3 getHesseEqFromPtAndDir(Vector3 p, Vector3 v) {
        double[] pt = new double[]{p.x, p.y};
        return MyMath.getHesseEqFromPtAndDir(pt, v);
    }

    public static double getCosBetween(double[] v1, double[] v2) {
        double sp = MyMath.scalprod(v1, v2);
        double b1 = MyMath.hypot(v1[0], v1[1]);
        double b2 = MyMath.hypot(v2[0], v2[1]);
        if (Math.abs(sp) < 1.0E-12) {
            return 0.0;
        }
        return sp / (b1 * b2);
    }

    public static Vector3 getDirectionFromHesseEq(Vector3 g) {
        Vector3 res = new Vector3(g.y, -g.x, 0.0);
        if (g.x != 0.0 || g.y != 0.0) {
            res.setValid(true);
        } else {
            res.setValid(false);
        }
        return res;
    }

    public static Vector3 getChordalLineFromCircles(Vector3 c1, Vector3 c2) {
        double dx = c1.x - c2.x;
        double dy = c1.y - c2.y;
        double ld = MyMath.hypot(dx, dy);
        if (ld > 1.0E-12) {
            double d = 0.5 * (MyMath.sqr(c2.z) - MyMath.sqr(c1.z) + dx * (c1.x + c2.x) + dy * (c1.y + c2.y));
            Vector3 res = new Vector3(dx / ld, dy / ld, d / ld);
            return res;
        }
        return null;
    }

    public static double[][] initRotMat(double w) {
        double[][] res = new double[2][2];
        res[0][0] = Math.cos(w);
        res[0][1] = Math.sin(w);
        res[1][0] = -res[0][1];
        res[1][1] = res[0][0];
        return res;
    }

    public static double[] getConicParamsFromCoeff(double[] co, double old_alpha) {
        int ct;
        Vector3 g1;
        Vector3 g2;
        double[] nco;
        double w2;
        double w1;
        double v;
        double[] res = new double[17];
        double[] sa = new double[2];
        double alpha = old_alpha;
        double[] hd = new double[2];
        double ec = 1.0;
        double[] m = new double[2];
        double[] n = new double[2];
        double dg = co[0] * (co[2] * co[5] - MyMath.sqr(co[4])) + co[1] * (co[4] * co[3] - co[1] * co[5]) + co[3] * (co[1] * co[4] - co[2] * co[3]);
        double dk = co[0] * co[2] - MyMath.sqr(co[1]);
        if (Math.abs(dg) < 1.0E-6) {
            dg = 0.0;
        }
        if (Math.abs(dk) < 1.0E-6) {
            dk = 0.0;
        }
        if (Math.abs(co[1]) > 1.0E-12) {
            v = (co[0] - co[2]) / (2.0 * co[1]);
            w1 = Math.atan(v - MyMath.hypot(v, 1.0));
            w2 = w1 + 1.5707963267948966;
            alpha = alpha <= w1 ? (Math.abs(alpha - w1) < Math.abs(alpha - (w2 - Math.PI)) ? w1 : w2) : (alpha <= w2 ? (Math.abs(alpha - w1) < Math.abs(alpha - w2) ? w1 : w2) : (Math.abs(alpha - (w1 + Math.PI)) < Math.abs(alpha - w2) ? w1 : w2));
            nco = MyMath.rotateConic(co, alpha);
        } else {
            nco = new double[6];
            System.arraycopy(co, 0, nco, 0, 6);
            nco[1] = 0.0;
            w1 = 0.0;
            w2 = 1.5707963267948966;
            alpha = 0.0;
        }
        if (Math.abs(dk) > 1.0E-12) {
            if (dk > 0.0) {
                if (Math.abs(dg) > 1.0E-12) {
                    if (Math.abs(nco[0]) > Math.abs(nco[2])) {
                        alpha = alpha > (w1 + w2) / 2.0 ? w1 : w2;
                        nco = MyMath.rotateConic(co, alpha);
                    }
                    if (dg * (nco[0] + nco[2]) < 0.0) {
                        sa[0] = Math.sqrt(Math.abs(dg / (dk * nco[0])));
                        sa[1] = Math.sqrt(Math.abs(dg / (dk * nco[2])));
                        ec = Math.sqrt(1.0 - MyMath.sqr(sa[1] / sa[0]));
                        hd[0] = -nco[3] / nco[0];
                        hd[1] = -nco[4] / nco[2];
                        double[][] rotmat = MyMath.initRotMat(-alpha);
                        m = MyMath.mapPt(rotmat, hd);
                        n = MyMath.mapPt(rotmat, 0.0, 1.0);
                        g2 = MyMath.getHesseEqFromPtAndDir(m, n);
                        n = MyMath.mapPt(rotmat, 1.0, 0.0);
                        g1 = MyMath.getHesseEqFromPtAndDir(m, n);
                        n[0] = m[0] + sa[0] * ec * n[0];
                        n[1] = m[1] + sa[0] * ec * n[1];
                        ct = 7;
                    } else {
                        g1 = new Vector3();
                        g2 = new Vector3();
                        ct = 0;
                    }
                } else {
                    hd[0] = -nco[3] / nco[0];
                    hd[1] = -nco[4] / nco[2];
                    double[][] rotmat = MyMath.initRotMat(-alpha);
                    m = MyMath.mapPt(rotmat, hd);
                    g1 = new Vector3();
                    g2 = new Vector3();
                    ct = 6;
                }
            } else if (Math.abs(dg) > 1.0E-12) {
                if (dg * nco[2] > 0.0) {
                    alpha = alpha > (w1 + w2) / 2.0 ? w1 : w2;
                    nco = MyMath.rotateConic(co, alpha);
                }
                sa[0] = Math.sqrt(Math.abs(dg / (dk * nco[0])));
                sa[1] = Math.sqrt(Math.abs(dg / (dk * nco[2])));
                ec = Math.sqrt(1.0 + MyMath.sqr(sa[1] / sa[0]));
                hd[0] = -nco[3] / nco[0];
                hd[1] = -nco[4] / nco[2];
                double[][] rotmat = MyMath.initRotMat(-alpha);
                m = MyMath.mapPt(rotmat, hd);
                n = MyMath.mapPt(rotmat, sa);
                g1 = MyMath.getHesseEqFromPtAndDir(m, n);
                n = MyMath.mapPt(rotmat, sa[0], -sa[1]);
                g2 = MyMath.getHesseEqFromPtAndDir(m, n);
                n = MyMath.mapPt(rotmat, 1.0, 0.0);
                n[0] = m[0] + sa[0] * ec * n[0];
                n[1] = m[1] + sa[0] * ec * n[1];
                ct = 5;
            } else {
                double[][] rotmat = MyMath.initRotMat(-alpha);
                n = new double[]{-nco[3] / nco[0], -nco[4] / nco[2]};
                m = MyMath.mapPt(rotmat, n);
                n[0] = m[0];
                n[1] = m[1];
                v = Math.sqrt(Math.abs(nco[0] / nco[2]));
                double[] w = MyMath.mapPt(rotmat, 1.0, v);
                g1 = MyMath.getHesseEqFromPtAndDir(m, w);
                w = MyMath.mapPt(rotmat, 1.0, -v);
                g2 = MyMath.getHesseEqFromPtAndDir(n, w);
                ct = 4;
            }
        } else {
            if (Math.abs(nco[0]) < Math.abs(nco[2])) {
                alpha = alpha > (w1 + w2) / 2.0 ? w1 : w2;
                nco = MyMath.rotateConic(co, alpha);
            }
            if (Math.abs(dg) > 1.0E-12) {
                hd[0] = -nco[3] / nco[0];
                hd[1] = (MyMath.sqr(nco[3]) - nco[0] * nco[5]) / (2.0 * nco[0] * nco[4]);
                ec = -nco[4] / nco[0];
                sa[0] = 0.0;
                sa[1] = ec > 0.0 ? 1.0 : -1.0;
                double[][] rotmat = MyMath.initRotMat(-alpha);
                n = MyMath.mapPt(rotmat, sa);
                double[] buf = new double[]{hd[0], hd[1] - ec / 2.0};
                m = MyMath.mapPt(rotmat, buf);
                buf[0] = n[1];
                buf[1] = -n[0];
                g1 = MyMath.getHesseEqFromPtAndDir(m, buf);
                g2 = MyMath.getHesseEqFromPtAndDir(m, n);
                m = MyMath.mapPt(rotmat, hd);
                ct = 1;
            } else {
                v = MyMath.sqr(nco[3]) - nco[0] * nco[5];
                double[][] rotmat = MyMath.initRotMat(-alpha);
                if (v > 1.0E-12) {
                    double[] w = MyMath.mapPt(rotmat, 0.0, 1.0);
                    m = MyMath.mapPt(rotmat, (-nco[3] - Math.sqrt(v)) / nco[0], 0.0);
                    g1 = MyMath.getHesseEqFromPtAndDir(m, w);
                    n = MyMath.mapPt(rotmat, (-nco[3] + Math.sqrt(v)) / nco[0], 0.0);
                    g2 = MyMath.getHesseEqFromPtAndDir(n, w);
                    ct = 2;
                } else if (v > -1.0E-12 && Math.abs(nco[0]) > 1.0E-12) {
                    double[] w = MyMath.mapPt(rotmat, 0.0, 1.0);
                    m = MyMath.mapPt(rotmat, -nco[3] / nco[0], 0.0);
                    g1 = MyMath.getHesseEqFromPtAndDir(m, w);
                    g2 = new Vector3();
                    ct = 3;
                } else {
                    g1 = new Vector3();
                    g2 = new Vector3();
                    ct = 0;
                }
            }
        }
        res[0] = ct;
        res[1] = m[0];
        res[2] = m[1];
        res[3] = n[0];
        res[4] = n[1];
        res[5] = hd[0];
        res[6] = hd[1];
        res[7] = alpha;
        res[8] = sa[0];
        res[9] = sa[1];
        res[10] = ec;
        res[11] = g1.x;
        res[12] = g1.y;
        res[13] = g1.z;
        res[14] = g2.x;
        res[15] = g2.y;
        res[16] = g2.z;
        return res;
    }

    public static double[] getConicCoeffFromFFP(double[] pt, boolean expEllipse) {
        double[] eq = new double[6];
        try {
            double za = expEllipse ? MyMath.hypot(pt[4] - pt[0], pt[5] - pt[1]) + MyMath.hypot(pt[4] - pt[2], pt[5] - pt[3]) : MyMath.hypot(pt[4] - pt[0], pt[5] - pt[1]) - MyMath.hypot(pt[4] - pt[2], pt[5] - pt[3]);
            double za2 = MyMath.sqr(za);
            double lg = pt[2] - pt[0];
            double mh = pt[3] - pt[1];
            double lpg = pt[2] + pt[0];
            double mph = pt[3] + pt[1];
            double g2h2 = MyMath.sqr(pt[0]) + MyMath.sqr(pt[1]);
            double l2m2 = MyMath.sqr(pt[2]) + MyMath.sqr(pt[3]);
            double gh2lm2 = g2h2 - l2m2;
            eq[0] = 4.0 * (MyMath.sqr(lg) - za2);
            eq[1] = 4.0 * lg * mh;
            eq[2] = 4.0 * (MyMath.sqr(mh) - za2);
            eq[3] = 2.0 * (lg * gh2lm2 + lpg * za2);
            eq[4] = 2.0 * (mh * gh2lm2 + mph * za2);
            eq[5] = MyMath.sqr(gh2lm2) - 2.0 * (g2h2 + l2m2) * za2 + MyMath.sqr(za2);
            double norm = MyMath.getNormingValue(eq[0], eq[1], eq[2], 0.001);
            if (eq[0] < 0.0) {
                norm = -norm;
            }
            if (Math.abs(norm) > 1.0E-12) {
                int i = 0;
                while (i <= 5) {
                    eq[i] = eq[i] / norm;
                    ++i;
                }
            }
        }
        catch (Exception e) {
            eq = null;
        }
        return eq;
    }

    public static double[] getConicCoeffFromPoints(double[] cp) {
        double[][] vp = new double[5][3];
        int i = 0;
        while (i < 5) {
            vp[i][0] = cp[2 * i];
            vp[i][1] = cp[2 * i + 1];
            vp[i][2] = 1.0;
            ++i;
        }
        double[] vg12 = MyMath.vprod3(vp[0], vp[1]);
        double[] vg34 = MyMath.vprod3(vp[2], vp[3]);
        double[] vg13 = MyMath.vprod3(vp[0], vp[2]);
        double[] vg24 = MyMath.vprod3(vp[1], vp[3]);
        double[][] ma = MyMath.fillmatrix(vg12, vg34);
        double[][] mb = MyMath.fillmatrix(vg13, vg24);
        vp[0] = MyMath.vtransf(mb, vp[4]);
        double la = MyMath.scalprod(vp[4], vp[0]);
        vp[0] = MyMath.vtransf(ma, vp[4]);
        double mu = MyMath.scalprod(vp[4], vp[0]);
        double[][] mc = new double[3][3];
        i = 0;
        while (i <= 2) {
            int k = 0;
            while (k <= 2) {
                mc[i][k] = la * ma[i][k] - mu * mb[i][k];
                ++k;
            }
            ++i;
        }
        double[] res = new double[]{mc[0][0], (mc[1][0] + mc[0][1]) / 2.0, mc[1][1], (mc[2][0] + mc[0][2]) / 2.0, (mc[2][1] + mc[1][2]) / 2.0, mc[2][2]};
        double norm = MyMath.normingValue(res[0], res[1], res[2], 0.001);
        if (norm > 1.0E-12) {
            if (res[0] < 0.0) {
                norm = -norm;
            }
            if (Math.abs(norm) > 1.0E-12) {
                int i2 = 0;
                while (i2 <= 5) {
                    res[i2] = res[i2] / norm;
                    if (Math.abs(res[i2]) < 1.0E-12) {
                        res[i2] = 0.0;
                    }
                    ++i2;
                }
            }
        }
        return res;
    }

    public static double[] getPolFromPolareAndConic(Vector3 pl, double[] conic) {
        Lgs gs = new Lgs(3, 3);
        double[] eq = new double[]{0.0, 0.0, 0.0, 0.0};
        eq[0] = pl.x;
        eq[1] = conic[0];
        eq[2] = conic[1];
        eq[3] = conic[3];
        gs.setEquation(1, eq);
        eq[0] = pl.y;
        eq[1] = conic[1];
        eq[2] = conic[2];
        eq[3] = conic[4];
        gs.setEquation(2, eq);
        eq[0] = -pl.z;
        eq[1] = conic[3];
        eq[2] = conic[4];
        eq[3] = conic[5];
        gs.setEquation(3, eq);
        gs.diagonalize();
        gs.getEquation(0, eq);
        if (Math.round(eq[0]) == 1L && Math.abs(eq[3]) > 1.0E-12) {
            double[] res = new double[]{eq[1] / eq[3], eq[2] / eq[3]};
            return res;
        }
        return null;
    }

    public static Vector3 getPolareFromPolAndConic(double px, double py, double[] conic) {
        Vector3 res = new Vector3(conic[0] * px + conic[1] * py + conic[3], conic[1] * px + conic[2] * py + conic[4], conic[3] * px + conic[4] * py + conic[5]);
        double bnv = MyMath.hypot(res.x, res.y);
        if (Math.abs(bnv) > 1.0E-12) {
            res.divBy(bnv);
            return res;
        }
        return null;
    }

    public static double[] getPolyCOG(V3List pvList) {
        double[] res = new double[]{0.0, 0.0};
        int i = 0;
        while (i < pvList.count()) {
            res[0] = res[0] + pvList.get((int)i).x;
            res[1] = res[1] + pvList.get((int)i).y;
            ++i;
        }
        res[0] = res[0] / (double)pvList.count();
        res[1] = res[1] / (double)pvList.count();
        return res;
    }

    public static double getPolyArea(V3List pvList) {
        double res = 0.0;
        int i = 0;
        while (i < pvList.count() - 1) {
            res += pvList.get((int)i).x * pvList.get((int)(i + 1)).y - pvList.get((int)(i + 1)).x * pvList.get((int)i).y;
            ++i;
        }
        return Math.abs(res / 2.0);
    }

    public static double getPolyCircumf(V3List pvList) {
        double res = 0.0;
        int i = 0;
        while (i < pvList.count() - 1) {
            res += MyMath.hypot(pvList.get((int)(i + 1)).x - pvList.get((int)i).x, pvList.get((int)(i + 1)).y - pvList.get((int)i).y);
            ++i;
        }
        return res;
    }

    public static boolean getAffineMapFromPts(double[][] p, double[][] q, double[][] mat) {
        boolean res = false;
        Lgs lgs = new Lgs(3, 3);
        double[] eq = new double[4];
        int i = 1;
        while (i <= 3) {
            eq[0] = q[i - 1][0];
            eq[1] = p[i - 1][0];
            eq[2] = p[i - 1][1];
            eq[3] = 1.0;
            lgs.setEquation(i, eq);
            ++i;
        }
        lgs.diagonalize();
        lgs.getEquation(0, eq);
        if ((double)Math.abs(Math.round(eq[0]) - 1L) < 1.0E-12) {
            mat[0][0] = eq[1];
            mat[1][0] = eq[2];
            mat[2][0] = eq[3];
            i = 1;
            while (i <= 3) {
                eq[0] = q[i - 1][1];
                eq[1] = p[i - 1][0];
                eq[2] = p[i - 1][1];
                eq[3] = 1.0;
                lgs.setEquation(i, eq);
                ++i;
            }
            lgs.diagonalize();
            lgs.getEquation(0, eq);
            if ((double)Math.abs(Math.round(eq[0]) - 1L) < 1.0E-12) {
                mat[0][1] = eq[1];
                mat[1][1] = eq[2];
                mat[2][1] = eq[3];
                res = true;
            }
        }
        return res;
    }

    private static boolean isSpecialNameChar(char c) {
        return c == '_' || c == '\'' || c == '#';
    }

    public static int isValidName(String nn) {
        if (nn != null && nn.length() > 0 && Character.isLetter(nn.charAt(0))) {
            int i = 1;
            while (i < nn.length()) {
                char c = nn.charAt(i);
                if (!Character.isLetterOrDigit(c) && !MyMath.isSpecialNameChar(c)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static String getNowStr() {
        Calendar now = Calendar.getInstance();
        int ye = now.get(1);
        int mo = now.get(2);
        int da = now.get(5);
        int ho = now.get(11);
        int mi = now.get(12);
        int se = now.get(13);
        String ds = String.valueOf(ye) + "-" + mo + "-" + da + "T" + ho + ":" + mi + ":" + se;
        return ds;
    }

    public static boolean bestLineApprox(V3List data, double[] qualityF, Vector3 pt, Vector3 dir) {
        double b;
        double a;
        boolean res = false;
        if (data.count() < 7) {
            return res;
        }
        res = true;
        double sx = 0.0;
        double sy = 0.0;
        double sxy = 0.0;
        double sx2 = 0.0;
        double sy2 = 0.0;
        double dmin = 1.0E100;
        int n = 0;
        int i = 0;
        while (i < data.count()) {
            Vector3 di = data.get(i);
            if (di.tag >= 0) {
                sx += di.x;
                sy += di.y;
                sxy += di.x * di.y;
                double x2 = MyMath.sqr(di.x);
                double y2 = MyMath.sqr(di.y);
                sx2 += x2;
                sy2 += y2;
                double dneu = x2 + y2;
                if (dneu < dmin) {
                    dmin = dneu;
                }
                ++n;
            }
            ++i;
        }
        double sax = Math.abs((double)n * sx2 - MyMath.sqr(sx));
        double say = Math.abs((double)n * sy2 - MyMath.sqr(sy));
        double saxy = (double)n * sxy - sx * sy;
        if (sax * 1.0E-12 > say || say * 1.0E-12 > sax) {
            qualityF[0] = 1.0;
        } else if (sax > 1.0E-12 && say > 1.0E-12) {
            qualityF[0] = Math.abs(saxy) / Math.sqrt(sax * say);
            if (qualityF[0] > 1.0) {
                qualityF[0] = 1.0;
            }
        } else {
            qualityF[0] = 0.0;
        }
        double c = MyMath.safeSub(sx2 * sy2, MyMath.sqr(sxy));
        if (Math.abs(c) > 1.0E-12) {
            a = sxy * sy - sy2 * sx;
            b = sxy * sx - sx2 * sy;
        } else if (sx2 > sy2) {
            a = -sxy;
            b = sx2;
        } else {
            a = sy2;
            b = -sxy;
        }
        double d = MyMath.hypot(a, b);
        if (Math.abs(d) > 1.0E-12) {
            dir.assign(b / d, -a / d, 0.0);
        } else {
            res = false;
        }
        if (res) {
            Vector3 p = new Vector3(sx / (double)n, sy / (double)n, 0.0);
            Vector3 line = MyMath.getHesseEqFromPtAndDir(p, dir);
            Vector3 erg = MyMath.getPedalPoint(line, p);
            pt.assign(erg.x, erg.y, 0.0);
        }
        return res;
    }

    public static boolean bestCircleApprox(V3List ptList, double[] quality, Vector3 c_data) {
        boolean res = false;
        if (ptList.count() > 7) {
            V3List mp_List = new V3List();
            int k = ptList.count() / 3;
            int[] nr = new int[]{-1, k - 1, 2 * k - 1};
            while (ptList.getNextTriangle(nr)) {
                Vector3 new_mp = new Vector3();
                if (!MyMath.getCircumMidPt(ptList.get(nr[0]), ptList.get(nr[1]), ptList.get(nr[2]), new_mp)) continue;
                mp_List.add(new_mp);
            }
            double xm = 0.0;
            double ym = 0.0;
            if (mp_List.count() > 3) {
                int i = 0;
                while (i < mp_List.count()) {
                    xm += mp_List.get((int)i).x;
                    ym += mp_List.get((int)i).y;
                    ++i;
                }
                xm /= (double)mp_List.count();
                ym /= (double)mp_List.count();
                k = 0;
                double r = 0.0;
                double sr = 0.0;
                double sr2 = 0.0;
                int i2 = 0;
                while (i2 < ptList.count()) {
                    if (ptList.get(i2).getValid()) {
                        r = MyMath.hypot(ptList.get((int)i2).x - xm, ptList.get((int)i2).y - ym);
                        sr += r;
                        sr2 += MyMath.sqr(r);
                        ++k;
                    }
                    ++i2;
                }
                if (k > 1) {
                    c_data.assign(xm, ym, sr / (double)k);
                    double s = Math.sqrt(Math.abs(sr2 - MyMath.sqr(sr) / (double)k) / (double)(k - 1));
                    quality[0] = Math.max(1.0 - s, 0.0);
                    res = true;
                }
            }
        }
        return res;
    }

    public static boolean bestConicApprox(V3List data, double[] quality, double[] coeff) {
        boolean res = false;
        int mp_count = data.validPtCount();
        double[] pts = new double[10];
        if (MyMath.fillMatchPts(data, pts)) {
            double[] n_coeff = MyMath.getConicCoeffFromPoints(pts);
            double sd2 = 0.0;
            int i = 0;
            while (i < mp_count) {
                if (data.get(i).getValid()) {
                    sd2 += Math.abs(MyMath.ptOnConicTest(n_coeff, data.get((int)i).x, data.get((int)i).y));
                }
                ++i;
            }
            i = 0;
            while (i <= 5) {
                coeff[i] = n_coeff[i];
                ++i;
            }
            quality[0] = Math.max(0.0, 1.0 - sd2 / (double)mp_count);
            res = true;
        } else {
            quality[0] = 0.0;
        }
        return res;
    }

    private static boolean fillMatchPts(V3List data, double[] pts) {
        boolean res = false;
        int[] mp_ind = new int[5];
        int i = 0;
        while (i <= 4) {
            mp_ind[i] = -1;
            ++i;
        }
        try {
            int dn = (data.validPtCount() - 5) / 4;
            int n = 0;
            while (n < data.count() && !data.get(n).getValid()) {
                ++n;
            }
            if (n < data.count()) {
                pts[0] = data.get((int)n).x;
                pts[1] = data.get((int)n).y;
                int i2 = 1;
                do {
                    int vn = 0;
                    do {
                        if (data.get(n).getValid()) {
                            ++vn;
                        }
                        ++n;
                    } while (vn < dn);
                    pts[2 * i2] = data.get((int)n).x;
                    pts[2 * i2 + 1] = data.get((int)n).y;
                } while (++i2 <= 4);
                res = true;
            } else {
                res = false;
            }
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    private static double ptOnConicTest(double[] coeff, double x, double y) {
        double res = coeff[0] * MyMath.sqr(x) + 2.0 * coeff[1] * x * y + coeff[2] * MyMath.sqr(y) + 2.0 * coeff[3] * x + 2.0 * coeff[4] * y + coeff[5];
        return res;
    }

    private static double[] mapPt(double[][] mat, double[] p) {
        double[] res = new double[]{mat[0][0] * p[0] + mat[1][0] * p[1], mat[0][1] * p[0] + mat[1][1] * p[1]};
        return res;
    }

    private static double[] mapPt(double[][] mat, double px, double py) {
        double[] res = new double[]{mat[0][0] * px + mat[1][0] * py, mat[0][1] * px + mat[1][1] * py};
        return res;
    }

    private static boolean getSymAxis(double[] ori_pts, double[] mpt_dir) {
        mpt_dir[0] = (ori_pts[0] + ori_pts[2]) / 2.0;
        mpt_dir[1] = (ori_pts[1] + ori_pts[3]) / 2.0;
        mpt_dir[2] = ori_pts[3] - ori_pts[1];
        mpt_dir[3] = ori_pts[0] - ori_pts[2];
        return MyMath.hypot(mpt_dir[2], mpt_dir[3]) > 1.0E-12;
    }

    private static boolean getCircumMidPt(Vector3 p1, Vector3 p2, Vector3 p3, Vector3 mp) {
        double dis;
        boolean res = false;
        double[] ori_pts1 = new double[]{p1.x, p1.y, p2.x, p2.y};
        double[] ra = new double[4];
        double[] ori_pts2 = new double[]{p2.x, p2.y, p3.x, p3.y};
        double[] rb = new double[4];
        if (MyMath.getSymAxis(ori_pts1, ra) && MyMath.getSymAxis(ori_pts2, rb) && Math.abs(dis = rb[3] * ra[2] - rb[2] * ra[3]) > 1.0E-12) {
            double t = ((rb[0] - ra[0]) * ra[3] - (rb[1] - ra[1]) * ra[2]) / dis;
            mp.x = rb[0] + t * rb[2];
            mp.y = rb[1] + t * rb[3];
            res = true;
        }
        return res;
    }

    private static double[] rotateConic(double[] co, double rota) {
        double[] res = new double[6];
        double sina = Math.sin(rota);
        double cosa = Math.cos(rota);
        double sico = sina * cosa;
        double sin2a = MyMath.sqr(sina);
        double cos2a = MyMath.sqr(cosa);
        res[0] = co[0] * cos2a - 2.0 * co[1] * sico + co[2] * sin2a;
        res[1] = 0.0;
        res[2] = co[0] * sin2a + 2.0 * co[1] * sico + co[2] * cos2a;
        res[3] = co[3] * cosa - co[4] * sina;
        res[4] = co[3] * sina + co[4] * cosa;
        res[5] = co[5];
        return res;
    }

    private static int double2int(double r) {
        return new Double(Math.rint(r)).intValue();
    }

    private static boolean isInteger(double ix, double idx) {
        double diff;
        double dx = 1.0E-12;
        double adx = Math.abs(idx);
        if (adx > 1.0E-12) {
            dx = adx;
        }
        return (diff = Math.abs(ix - (double)MyMath.double2int(ix))) < dx;
    }

    private static double iterate(double a, double b, double c, double x) {
        double xa;
        int i = 0;
        double dx = Math.abs(x * 1.0E-15);
        do {
            double denom;
            if (Math.abs(denom = (3.0 * (xa = x) + 2.0 * a) * xa + b) > 1.0E-12) {
                x = xa - (((xa + a) * xa + b) * xa + c) / denom;
                continue;
            }
            i = 10;
        } while (++i < 10 && Math.abs(x - xa) > dx);
        return x;
    }

    private static double scalprod(double[] v1, double[] v2) {
        int n = v1.length;
        if (v2.length != n) {
            return 0.0;
        }
        double res = 0.0;
        int i = 0;
        while (i < n) {
            res += v1[i] * v2[i];
            ++i;
        }
        return res;
    }

    private static double[] vprod3(double[] v1, double[] v2) {
        if (v1.length == 3 && v2.length == 3) {
            double[] res = new double[]{v1[1] * v2[2] - v2[1] * v1[2], v1[2] * v2[0] - v2[2] * v1[0], v1[0] * v2[1] - v2[0] * v1[1]};
            return res;
        }
        return null;
    }

    private static double[][] fillmatrix(double[] g1, double[] g2) {
        double[][] res = new double[3][3];
        int i = 0;
        while (i <= 2) {
            int k = 0;
            while (k <= 2) {
                res[i][k] = g1[i] * g2[k] + g2[i] * g1[k];
                ++k;
            }
            ++i;
        }
        return res;
    }

    private static double[] vtransf(double[][] m, double[] v) {
        double[] res = new double[3];
        int i = 0;
        while (i <= 2) {
            res[i] = v[0] * m[0][i] + v[1] * m[1][i] + v[2] * m[2][i];
            ++i;
        }
        return res;
    }

    private static double normingValue(double ex, double ey, double ez, double edd) {
        double res;
        double dd = Math.abs(edd);
        if (dd < 1.0E-12) {
            dd = 1.0E-12;
        }
        double x = Math.abs(ex);
        double y = Math.abs(ey);
        double z = Math.abs(ez);
        if (x < 1.0E-12) {
            x = 0.0;
        }
        if (y < 1.0E-12) {
            y = 0.0;
        }
        if (z < 1.0E-12) {
            z = 0.0;
        }
        if ((res = Math.sqrt(MyMath.sqr(x) + MyMath.sqr(y) + MyMath.sqr(z))) > 1.0E-12) {
            double p;
            if (z > y) {
                p = z;
                z = y;
                y = p;
            }
            if (y > x) {
                p = y;
                y = x;
                x = p;
            }
            if (z > y) {
                p = z;
                z = y;
                y = p;
            }
            if (MyMath.isInteger(x, dd) && MyMath.isInteger(y, dd) && MyMath.isInteger(z, dd)) {
                res = z > 1.0E-12 ? (double)MyMath.gcd(MyMath.gcd(MyMath.double2int(x), MyMath.double2int(y)), MyMath.double2int(z)) : (y > 1.0E-12 ? (double)MyMath.gcd(MyMath.double2int(x), MyMath.double2int(y)) : Math.rint(x));
            }
        } else {
            res = 0.0;
        }
        return res;
    }

    private static double safeSub(double x, double y) {
        double bx = Math.abs(x);
        double by = Math.abs(y);
        double d = x - y;
        if (bx > by) {
            if (Math.abs(d) < bx * 1.0E-12) {
                return 0.0;
            }
            return d;
        }
        if (Math.abs(d) < by * 1.0E-12) {
            return 0.0;
        }
        return d;
    }
}

