/*
 * Decompiled with CFR 0.152.
 */
package dgmath;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import xml.Helpers;

public class V3List {
    ArrayList<Vector3> data;

    public V3List() {
        this.data = new ArrayList();
    }

    public V3List(int n) {
        this.data = new ArrayList();
        int i = 0;
        while (i < n) {
            this.data.add(new Vector3(0.0, 0.0, 0.0));
            ++i;
        }
    }

    public V3List(V3List master) {
        this.data = new ArrayList(master.count());
        int i = 0;
        while (i < master.count()) {
            this.data.add(new Vector3(master.get(i)));
            ++i;
        }
    }

    public V3List(String s) {
        String dataStr = Helpers.killAllBreaks(s);
        String[] sz = dataStr.split(" ");
        this.data = new ArrayList();
        int i = 0;
        while (i < sz.length) {
            Vector3 v = new Vector3(sz[i]);
            if (v.getValid()) {
                this.add(v);
            }
            ++i;
        }
    }

    public int count() {
        return this.data.size();
    }

    public int validPtCount() {
        int res = 0;
        int i = 0;
        while (i < this.data.size()) {
            if (this.get(i).getValid()) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    public void clear() {
        this.data.clear();
    }

    public void reset2zList(int intCnt, double first_z, double last_z) {
        this.clear();
        double p = first_z;
        double dp = (last_z - first_z) / (double)intCnt;
        int i = 0;
        while (i <= intCnt) {
            this.insertAt(i, new Vector3(0.0, 0.0, p));
            p += dp;
            ++i;
        }
        this.get((int)intCnt).z = last_z;
    }

    public int insert(Vector3 v) {
        int s = -1;
        if (this.data.size() == 0) {
            this.data.add(v);
            s = 0;
        } else if (v.z <= this.get((int)0).z) {
            if (v.z <= this.get((int)0).z - 1.0E-6) {
                this.data.add(0, v);
                s = 0;
            }
        } else if (v.z >= this.get((int)(this.data.size() - 1)).z) {
            if (v.z >= this.get((int)(this.data.size() - 1)).z + 1.0E-6) {
                this.data.add(v);
                s = this.data.size() - 1;
            }
        } else {
            s = this.insSpot(0, this.data.size() - 1, v.z);
            if (s >= 0) {
                this.data.add(s, v);
            }
        }
        return s;
    }

    public boolean insertAt(int n, Vector3 v) {
        if (n >= 0) {
            if (n < this.data.size()) {
                this.data.add(n, v);
            } else {
                this.data.add(v);
            }
            return true;
        }
        return false;
    }

    public boolean add(Vector3 v) {
        return this.data.add(v);
    }

    public Vector3 remove(int n) {
        if (n >= 0 && n < this.count()) {
            return this.data.remove(n);
        }
        return null;
    }

    public Vector3 get(int n) {
        if (n >= 0 && n < this.data.size()) {
            return this.data.get(n);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (i < this.count()) {
            if (this.get(i) != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.get(i).toString());
            }
            ++i;
        }
        return sb.toString();
    }

    public int getPtIndexNextToZ(double z) {
        int res;
        if (this.data.size() > 0) {
            res = 0;
            double dist = 1.0E20;
            double oldDist = Math.abs(this.get((int)0).z - z);
            int i = 1;
            while (i < this.data.size()) {
                if (this.get(i) != null && (dist = Math.abs(this.get((int)i).z - z)) < oldDist) {
                    res = i;
                    oldDist = dist;
                }
                ++i;
            }
        } else {
            res = -1;
        }
        return res;
    }

    public int getPtIndexNextToXY(double mx, double my) {
        int res;
        if (this.data.size() > 0) {
            res = 0;
            double dist = 1.0E20;
            double oldDist = 1.0E20;
            int i = 1;
            while (i < this.data.size()) {
                if (this.get(i) != null && this.get(i).getValid() && (dist = MyMath.hypot(this.get((int)i).x - mx, this.get((int)i).y - my)) < oldDist) {
                    res = i;
                    oldDist = dist;
                }
                ++i;
            }
        } else {
            res = -1;
        }
        return res;
    }

    public boolean isClosed() {
        boolean res = !this.data.contains(null) && MyMath.hypot(this.get((int)0).x - this.get((int)(this.data.size() - 1)).x, this.get((int)0).y - this.get((int)(this.data.size() - 1)).y) < 1.0E-6;
        return res;
    }

    public GeneralPath getBezierCurve(CoordsCanvas canvas) {
        GeneralPath curve = null;
        if (this.data.size() > 2) {
            curve = new GeneralPath();
            Point2D.Double spt = new Point2D.Double();
            V3List buf = new V3List();
            int n = 0;
            int i = 0;
            while (i < this.data.size()) {
                if (this.get(i) != null) {
                    if (canvas.knowsPt(this.get((int)i).x, this.get((int)i).y)) {
                        canvas.getScreenPtCoords(this.get((int)i).x, this.get((int)i).y, spt);
                        if (n == 0 || buf.get(n - 1) == null || Math.abs(buf.get((int)(n - 1)).x - spt.x) + Math.abs(buf.get((int)(n - 1)).y - spt.y) > 0.5) {
                            buf.insertAt(n, new Vector3(spt.x, spt.y, this.get((int)i).z));
                            ++n;
                        }
                    }
                } else {
                    buf.insertAt(n, null);
                    ++n;
                }
                ++i;
            }
            if (buf.count() < 3) {
                return null;
            }
            int indexLastPIR = buf.getIndexOfLPIR(0);
            Vector3 cp0 = new Vector3(0.0, 0.0, 0.0);
            Vector3 cp1 = new Vector3(0.0, 0.0, 0.0);
            Vector3 cp2 = new Vector3(0.0, 0.0, 0.0);
            Vector3 cpz = new Vector3(0.0, 0.0, 0.0);
            if (this.isClosed()) {
                this.getBezierCtrlPts(buf.get(indexLastPIR - 1), buf.get(0), buf.get(1), cpz, cp0);
            } else {
                cp0.assign(buf.get(0));
                cpz.assign(buf.get(indexLastPIR));
            }
            int i2 = 0;
            while (i2 < buf.count() - 1) {
                curve.moveTo((float)buf.get((int)i2).x, (float)buf.get((int)i2).y);
                ++i2;
                while (i2 < indexLastPIR) {
                    if (this.getBezierCtrlPts(buf.get(i2 - 1), buf.get(i2), buf.get(i2 + 1), cp1, cp2)) {
                        curve.curveTo((float)cp0.x, (float)cp0.y, (float)cp1.x, (float)cp1.y, (float)buf.get((int)i2).x, (float)buf.get((int)i2).y);
                        cp0.assign(cp2);
                    } else {
                        curve.lineTo((float)buf.get((int)i2).x, (float)buf.get((int)i2).y);
                        cp0.assign(buf.get(i2));
                    }
                    ++i2;
                }
                if (buf.get(i2) != null) {
                    curve.curveTo((float)cp0.x, (float)cp0.y, (float)cpz.x, (float)cpz.y, (float)buf.get((int)i2).x, (float)buf.get((int)i2).y);
                }
                i2 += 2;
                while (i2 < buf.count() && buf.get(i2) == null) {
                    ++i2;
                }
                if (i2 >= buf.count()) continue;
                indexLastPIR = buf.getIndexOfLPIR(i2);
                cp0.assign(buf.get(i2));
                cpz.assign(buf.get(indexLastPIR));
            }
        }
        return curve;
    }

    public GeneralPath getSegmentedCurve(CoordsCanvas canvas) {
        GeneralPath curve = null;
        if (this.data.size() > 2) {
            curve = new GeneralPath();
            Point2D.Double lspt = new Point2D.Double();
            Point2D.Double aspt = new Point2D.Double();
            boolean penDown = false;
            int i = 0;
            while (i < this.data.size()) {
                if (this.get(i) == null || this.get((int)i).tag == -2) {
                    penDown = false;
                    while (++i < this.data.size() && (this.get(i) == null || this.get((int)i).tag == -2)) {
                    }
                }
                if (i < this.data.size() && this.get((int)i).tag >= -1 && !penDown) {
                    canvas.getScreenPtCoords(this.get((int)i).x, this.get((int)i).y, lspt);
                    curve.moveTo((float)lspt.x, (float)lspt.y);
                    penDown = true;
                    ++i;
                }
                while (i < this.data.size() && this.get(i) != null && this.get((int)i).tag >= -1) {
                    canvas.getScreenPtCoords(this.get((int)i).x, this.get((int)i).y, aspt);
                    if (Math.abs(lspt.x - aspt.x) + Math.abs(lspt.y - aspt.y) > 0.5) {
                        curve.lineTo((float)aspt.x, (float)aspt.y);
                        lspt.setLocation(aspt);
                    }
                    ++i;
                }
            }
        }
        return curve;
    }

    public boolean getNextTriangle(int[] nr) {
        do {
            nr[2] = nr[2] + 1;
        } while (nr[2] < this.count() && !this.get(nr[2]).getValid());
        do {
            nr[1] = nr[1] + 1;
        } while (nr[1] < nr[2] && !this.get(nr[1]).getValid());
        do {
            nr[0] = nr[0] + 1;
        } while (nr[0] < nr[1] && !this.get(nr[0]).getValid());
        return nr[2] < this.count() && nr[0] < nr[1] && nr[1] < nr[2];
    }

    private boolean getBezierCtrlPts(Vector3 v1, Vector3 v2, Vector3 v3, Vector3 cp1, Vector3 cp2) {
        double[] dArray = new double[]{v3.x - v1.x, v3.y - v1.y};
        double[] dir = dArray;
        double len13 = MyMath.hypot(dir[0], dir[1]);
        if (Math.abs(len13) > 1.0E-6) {
            double len12 = MyMath.hypot(v2.x - v1.x, v2.y - v1.y);
            double len23 = MyMath.hypot(v3.x - v2.x, v3.y - v2.y);
            cp1.x = v2.x - 0.35 * len12 / len13 * dir[0];
            cp1.y = v2.y - 0.35 * len12 / len13 * dir[1];
            cp2.x = v2.x + 0.35 * len23 / len13 * dir[0];
            cp2.y = v2.y + 0.35 * len23 / len13 * dir[1];
            return true;
        }
        return false;
    }

    private int getIndexOfLPIR(int start) {
        int i = start + 1;
        while (i < this.data.size() && this.get(i) != null) {
            ++i;
        }
        return --i;
    }

    private int insSpot(int lo, int hi, double sk) {
        if (lo >= hi - 1) {
            if (sk < this.get((int)hi).z) {
                return hi;
            }
            return -1;
        }
        int mi = (lo + hi) / 2;
        if (sk <= this.get((int)mi).z) {
            return this.insSpot(lo, mi, sk);
        }
        return this.insSpot(mi, hi, sk);
    }
}

