/*
 * Decompiled with CFR 0.152.
 */
package dgmath;

public class Vector3 {
    public double x;
    public double y;
    public double z;
    public int tag;

    public Vector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.tag = 0;
    }

    public Vector3(double ix, double iy, double iz) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.tag = 0;
    }

    public Vector3(double ix, double iy, double iz, int itag) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.tag = itag;
    }

    public Vector3(Vector3 ov) {
        this.x = ov.x;
        this.y = ov.y;
        this.z = ov.z;
        this.tag = ov.tag;
    }

    public Vector3(String s) {
        this.tag = -2;
        String[] c = s.split(";");
        if (c.length == 3) {
            this.x = Double.parseDouble(c[0]);
            this.y = Double.parseDouble(c[1]);
            this.z = Double.parseDouble(c[2]);
            this.tag = 0;
        }
    }

    public void assign(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.tag = v.tag;
    }

    public void assign(double ix, double iy, double iz) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.tag = 0;
    }

    public void assign(double ix, double iy, double iz, int itag) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.tag = itag;
    }

    public void multBy(double fac) {
        this.x *= fac;
        this.y *= fac;
        this.z *= fac;
    }

    public void divBy(double den) {
        if (Math.abs(den) > 1.0E-12) {
            this.x /= den;
            this.y /= den;
            this.z /= den;
        } else {
            this.setValid(false);
        }
    }

    public void setValid(boolean newVal) {
        this.tag = newVal ? 0 : -2;
    }

    public boolean getValid() {
        return this.tag > -2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append(this.x);
        sb.append(";");
        sb.append(this.y);
        sb.append(";");
        sb.append(this.z);
        return sb.toString();
    }
}

