/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import java.awt.Color;
import xml.Helpers;

public final class Appearance {
    public static final int psSolid = 0;
    public static final int psDashed = 1;
    public static final int psDotted = 2;
    public static final int psDashDot = 3;
    public static final int shFilledCircle = 0;
    public static final int shFilledRect = 1;
    public static final int shCircle = 2;
    public static final int shRect = 3;
    public static final int shUpCross = 4;
    public static final int shDiagCross = 5;
    public static final int bsSolid = 0;
    public static final int bsClear = 1;
    public static final int bsHorizHatched = 2;
    public static final int bsVertHatched = 3;
    public static final int bsDiagBkwd = 4;
    public static final int bsDiagFrwd = 5;
    public static final int bsCrossed = 6;
    public static final int bsDiagCrossed = 7;
    public static final int bsUserDef = 8;
    public static final int lsSolid = 10;
    public static final int lsThick = 11;
    public static final int lsFat = 12;
    public static final int lsDashed = 13;
    public static final int lsDotted = 14;
    public static final int lsDashDot = 15;
    public static final int psFilledCircle = 30;
    public static final int psFilledSquare = 31;
    public static final int psHollowCircle = 32;
    public static final int psHollowSquare = 33;
    public static final int psCrossUpright = 34;
    public static final int psCrossDiag = 35;
    public static final int psHollowCircleThin = 36;
    public static final int psHollowSquareThin = 37;
    public static final int psCrossUprightThin = 38;
    public static final int psCrossDiagThin = 39;
    private String color = "$00000000";
    private Color aColor = Color.BLACK;
    private int pen_style = 0;
    private int line_width = 1;
    private int shape = 1;
    private int point_size = 3;
    private int brush_style = 1;
    private int groups = 0;
    private boolean visible = true;
    private boolean blinking = false;
    private boolean isBlinkOn = true;
    private boolean add_data2name = false;

    public final Color getColor() {
        if (this.blinking && !this.isBlinkOn) {
            return Color.white;
        }
        return this.aColor;
    }

    public final Color getFillColor() {
        if (this.aColor.equals(Color.BLACK)) {
            return Color.YELLOW;
        }
        return this.aColor;
    }

    public final Color getLightFillColor() {
        Color col = this.getFillColor();
        return this.lighter(col);
    }

    public final String getColorString() {
        return this.color;
    }

    public final int getPenStyle() {
        return this.pen_style;
    }

    public final int getLineWidth() {
        return this.line_width;
    }

    public final int getShape() {
        return this.shape;
    }

    public final int getPointSize() {
        return this.point_size;
    }

    public final int getBrushStyle() {
        return this.brush_style;
    }

    public final boolean getVisible(int mask) {
        if (this.groups > 0) {
            return this.visible && (this.groups & mask) > 0;
        }
        return this.visible;
    }

    public final boolean getAddData2Name() {
        return this.add_data2name;
    }

    public int getGroups() {
        return this.groups;
    }

    public final void setColor(Color aColor) {
        this.aColor = aColor;
        this.color = Helpers.toHexColorString(aColor);
    }

    public final void setColor(String color) {
        this.color = color;
        this.aColor = Helpers.fromHexColorString(color);
    }

    public final void setBlinking(boolean blink) {
        this.blinking = blink;
    }

    public final void setBlinkOn(boolean blinkOn) {
        this.isBlinkOn = this.blinking ? blinkOn : true;
    }

    public final void setPenStyle(int ps) {
        this.pen_style = ps;
    }

    public final void setLineWidth(int lw) {
        this.line_width = lw;
    }

    public final void setShape(int s) {
        this.shape = s;
        this.point_size = s == 0 || s == 2 ? 4 : 3;
    }

    public final void setBrushStyle(int bs) {
        this.brush_style = bs;
    }

    public final void setVisible(boolean v) {
        this.visible = v;
    }

    public final void setAddData2Name(boolean v) {
        this.add_data2name = v;
    }

    public void setGroups(int groups) {
        this.groups = groups;
    }

    public final void setLineStyle(int ls) {
        switch (ls) {
            case 10: {
                this.setPenStyle(0);
                this.setLineWidth(1);
                break;
            }
            case 11: {
                this.setPenStyle(0);
                this.setLineWidth(3);
                break;
            }
            case 12: {
                this.setPenStyle(0);
                this.setLineWidth(5);
                break;
            }
            case 13: {
                this.setLineWidth(1);
                this.setPenStyle(1);
                break;
            }
            case 14: {
                this.setLineWidth(1);
                this.setPenStyle(2);
                break;
            }
            case 15: {
                this.setLineWidth(1);
                this.setPenStyle(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown argument: " + String.valueOf(ls));
            }
        }
    }

    public final void setPointStyle(int ps) {
        switch (ps) {
            case 30: {
                this.setLineStyle(10);
                this.setShape(0);
                this.setBrushStyle(0);
                break;
            }
            case 31: {
                this.setLineStyle(10);
                this.setShape(1);
                this.setBrushStyle(0);
                break;
            }
            case 32: {
                this.setLineStyle(11);
                this.setShape(2);
                this.setBrushStyle(1);
                break;
            }
            case 33: {
                this.setLineStyle(11);
                this.setShape(3);
                this.setBrushStyle(1);
                break;
            }
            case 34: {
                this.setLineStyle(11);
                this.setShape(4);
                this.setBrushStyle(1);
                break;
            }
            case 35: {
                this.setLineStyle(11);
                this.setShape(5);
                this.setBrushStyle(1);
                break;
            }
            case 36: {
                this.setLineStyle(10);
                this.setShape(2);
                this.setBrushStyle(1);
                break;
            }
            case 37: {
                this.setLineStyle(10);
                this.setShape(3);
                this.setBrushStyle(1);
                break;
            }
            case 38: {
                this.setLineStyle(10);
                this.setShape(4);
                this.setBrushStyle(1);
                break;
            }
            case 39: {
                this.setLineStyle(10);
                this.setShape(5);
                this.setBrushStyle(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown argument: " + String.valueOf(ps));
            }
        }
    }

    private Color lighter(Color col) {
        float[] colData = col.getRGBComponents(null);
        int i = 0;
        while (i <= 2) {
            colData[i] = (colData[i] + 3.0f) / 4.0f;
            ++i;
        }
        return new Color(colData[0], colData[1], colData[2], colData[3]);
    }
}

