/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GLine;
import geoobj.GMapping;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;
import terms.TermTree;

public class GAffineMapping
extends GMapping {
    protected TermTree f11 = null;
    protected TermTree f12 = null;
    protected TermTree f21 = null;
    protected TermTree f22 = null;
    protected TermTree f31 = null;
    protected TermTree f32 = null;

    public GAffineMapping(GeoObjList list) {
        super(list);
    }

    public GAffineMapping(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        if (this.mapType == 19) {
            this.f11 = new TermTree(this.a11, 0.0, this.drawing, TermTree.isRadMode);
            this.f12 = new TermTree(this.a12, 0.0, this.drawing, TermTree.isRadMode);
            this.f21 = new TermTree(this.a21, 0.0, this.drawing, TermTree.isRadMode);
            this.f22 = new TermTree(this.a22, 0.0, this.drawing, TermTree.isRadMode);
            this.f31 = new TermTree(this.a31, 0.0, this.drawing, TermTree.isRadMode);
            this.f32 = new TermTree(this.a32, 0.0, this.drawing, TermTree.isRadMode);
        }
    }

    @Override
    public boolean getMappedCircle(Vector3 circ, Vector3 res) {
        return false;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        double[][] p = new double[3][2];
        double[][] q = new double[3][2];
        this.setValid(false);
        switch (this.mapType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                GLine axis = (GLine)this.parent.get(0);
                GPoint p1 = (GPoint)this.parent.get(1);
                GPoint q1 = (GPoint)this.parent.get(2);
                if (axis == null || p1 == null || q1 == null) break;
                Vector3 dir = MyMath.getDirectionFromHesseEq(axis.getEq());
                double[][] pl = new double[][]{{axis.x1, axis.y1}, {axis.x1 + dir.x, axis.y1 + dir.y}, {p1.x, p1.y}};
                double[][] ql = new double[][]{{axis.x1, axis.y1}, {axis.x1 + dir.x, axis.y1 + dir.y}, {q1.x, q1.y}};
                this.setValid(MyMath.getAffineMapFromPts(pl, ql, this.mat));
                break;
            }
            case 14: {
                Vector3 g1 = ((GLine)this.parent.get(0)).getEq();
                Vector3 g2 = ((GLine)this.parent.get(1)).getEq();
                Vector3 s = MyMath.intersectLines(g1, g2);
                if (!(s.z > 0.5)) break;
                p[0][0] = s.x;
                p[0][1] = s.y;
                q[0][0] = s.x;
                q[0][1] = s.y;
                GPoint p2 = (GPoint)this.parent.get(2);
                GPoint q2 = (GPoint)this.parent.get(3);
                if (p2 == null || q2 == null || !p2.isValid() || !q2.isValid()) break;
                double[] pt = new double[]{p2.x, p2.y};
                s = MyMath.getProjPoint(pt, g1, g2);
                if (!(s.z > 0.5)) break;
                p[1][0] = s.x;
                p[1][1] = s.y;
                s = MyMath.getProjPoint(pt, g2, g1);
                if (!(s.z > 0.5)) break;
                p[2][0] = s.x;
                p[2][1] = s.y;
                pt[0] = q2.x;
                pt[1] = q2.y;
                s = MyMath.getProjPoint(pt, g1, g2);
                if (!(s.z > 0.5)) break;
                q[1][0] = s.x;
                q[2][1] = s.y;
                s = MyMath.getProjPoint(pt, g2, g1);
                if (!(s.z > 0.5)) break;
                q[2][0] = s.x;
                q[2][1] = s.y;
                this.setValid(MyMath.getAffineMapFromPts(p, q, this.mat));
                break;
            }
            case 15: {
                p[0][0] = ((GPoint)this.parent.get((int)0)).x;
                p[0][1] = ((GPoint)this.parent.get((int)0)).y;
                q[0][0] = p[0][0];
                q[0][1] = p[0][1];
                int i = 1;
                while (i <= 2) {
                    GPoint sPt = (GPoint)this.parent.get(2 * i);
                    p[i][0] = sPt.x;
                    p[i][1] = sPt.y;
                    GPoint dPt = (GPoint)this.parent.get(2 * i + 1);
                    q[i][0] = dPt.x;
                    q[i][1] = dPt.y;
                    ++i;
                }
                this.setValid(MyMath.getAffineMapFromPts(p, q, this.mat));
                break;
            }
            case 18: {
                int i = 0;
                while (i <= 2) {
                    GPoint sPt = (GPoint)this.parent.get(2 * i);
                    p[i][0] = sPt.x;
                    p[i][1] = sPt.y;
                    GPoint dPt = (GPoint)this.parent.get(2 * i + 1);
                    q[i][0] = dPt.x;
                    q[i][1] = dPt.y;
                    ++i;
                }
                this.setValid(MyMath.getAffineMapFromPts(p, q, this.mat));
                break;
            }
            case 19: {
                this.mat[0][0] = this.f11.getValue(0.0);
                this.mat[0][1] = this.f12.getValue(0.0);
                this.mat[1][0] = this.f21.getValue(0.0);
                this.mat[1][1] = this.f22.getValue(0.0);
                this.mat[2][0] = this.f31.getValue(0.0);
                this.mat[2][1] = this.f32.getValue(0.0);
            }
        }
    }
}

