/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GAngle
extends GeoObj {
    protected double[] xi = new double[]{0.0, 0.0, 0.0};
    protected double[] yi = new double[]{0.0, 0.0, 0.0};
    protected double[] angle = new double[]{0.0, 0.0};
    protected double radius = 0.6;
    protected boolean reversed = false;

    public GAngle(GeoObjList list) {
        super(list);
        this.ccMask = 0x140001;
        this.appearance.setBrushStyle(0);
    }

    public GAngle(GeoObjList list, GeoObj iP1, GeoObj iP2, GeoObj iP3, boolean iReversed, boolean iVisible) {
        super(list);
        this.ccMask = 0x140001;
        this.appearance.setBrushStyle(0);
        this.becomesChildOf(iP1);
        this.becomesChildOf(iP2);
        this.becomesChildOf(iP3);
        this.reversed = iReversed;
        this.setVisible(iVisible);
        this.updateParams(null, 0.0, 0.0);
    }

    public GAngle(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 0x140001;
        Element childElem = Helpers.getChildElementByName("position", objElem);
        if (childElem != null) {
            this.xi[0] = Double.parseDouble(childElem.getAttribute("x1"));
            this.yi[0] = Double.parseDouble(childElem.getAttribute("y1"));
            this.xi[1] = Double.parseDouble(childElem.getAttribute("x2"));
            this.yi[1] = Double.parseDouble(childElem.getAttribute("y2"));
            this.xi[2] = Double.parseDouble(childElem.getAttribute("x3"));
            this.yi[2] = Double.parseDouble(childElem.getAttribute("y3"));
        }
        if ((childElem = Helpers.getChildElementByName("line", objElem)) != null) {
            this.radius = Double.parseDouble(childElem.getAttribute("radius"));
            this.reversed = childElem.getAttribute("reversed") != null ? Boolean.parseBoolean(childElem.getAttribute("reversed")) : false;
        }
        this.appearance.setBrushStyle(0);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = domDoc.createElement("position");
        pos.setAttribute("x1", new Double(this.xi[0]).toString());
        pos.setAttribute("y1", new Double(this.yi[0]).toString());
        pos.setAttribute("x2", new Double(this.xi[1]).toString());
        pos.setAttribute("y2", new Double(this.yi[1]).toString());
        pos.setAttribute("x3", new Double(this.xi[2]).toString());
        pos.setAttribute("y3", new Double(this.yi[2]).toString());
        domData.appendChild(pos);
        Element ln = domDoc.createElement("line");
        ln.setAttribute("radius", new Double(this.radius).toString());
        if (this.reversed) {
            ln.setAttribute("reversed", "true");
        }
        domData.appendChild(ln);
        return domData;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        try {
            this.angle[0] = MyMath.mvArg(this.xi[0] - this.xi[1], this.yi[0] - this.yi[1]);
            this.angle[1] = MyMath.mvArg(this.xi[2] - this.xi[1], this.yi[2] - this.yi[1]);
        }
        catch (Exception e) {
            this.setValid(false);
        }
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.hasSameParentsAs(o, true);
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            double dmm = MyMath.hypot(mx - this.xi[1], my - this.yi[1]);
            if (Math.abs(dmm) > 1.0E-6) {
                double ma = MyMath.mvArg(mx - this.xi[1], my - this.yi[1]);
                if (this.isInAngleRange(ma)) {
                    return Math.abs(dmm - this.radius);
                }
                return Math.min(MyMath.hypot(mx - this.xi[0], my - this.yi[0]), MyMath.hypot(mx - this.xi[2], my - this.yi[2]));
            }
            return this.radius;
        }
        return 1.0E20;
    }

    public double getx() {
        return this.xi[1];
    }

    public double gety() {
        return this.yi[1];
    }

    @Override
    public double getValue(int select) {
        switch (select) {
            case 0: 
            case 9: {
                return this.getAngle();
            }
            case 6: {
                return this.angle[0];
            }
            case 7: {
                return this.angle[1];
            }
            case 4: {
                return this.radius;
            }
            case 1: {
                return this.xi[1] + Math.cos(this.angle[0] + 0.5 * this.getAngle()) * 0.5 * this.radius;
            }
            case 2: {
                return this.yi[1] + Math.sin(this.angle[0] + 0.5 * this.getAngle()) * 0.5 * this.radius;
            }
        }
        return super.getValue(select);
    }

    @Override
    public double[] getNameParamsFromCoords(double nx, double ny) {
        double[] res = new double[]{nx - this.getValue(1), ny - this.getValue(2)};
        return res;
    }

    @Override
    public double[] getNameCoordsFromParams(double[] np) {
        double[] res = new double[]{this.getValue(1) + np[0], this.getValue(2) + np[1]};
        return res;
    }

    @Override
    public double[] getDefaultNameParams() {
        double[] res = new double[]{0.0, 0.0};
        return res;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawArc(this.xi[1], this.yi[1], this.radius, this.angle[0], this.angle[1], this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor(), this.appearance.getBrushStyle(), this.appearance.getLightFillColor());
            if (this.isRightAngle()) {
                double a = 0.5 * (this.angle[0] + this.angle[1]);
                if (!this.isInAngleRange(a)) {
                    a -= Math.PI;
                }
                double mx = this.xi[1] + this.radius * 0.6 * Math.cos(a);
                double my = this.yi[1] + this.radius * 0.6 * Math.sin(a);
                canvas.drawPoint(mx, my, 1, 0, 3, this.appearance.getColor());
            }
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        if (mousedObj == this) {
            this.radius = MyMath.hypot(this.xi[1] - lmx, this.yi[1] - lmy);
        } else {
            this.setValid(true);
            int i = 0;
            while (i < this.parent.size()) {
                if (this.parent.get(i).isValid()) {
                    this.xi[i] = this.parent.get((int)i).x;
                    this.yi[i] = this.parent.get((int)i).y;
                } else {
                    this.setValid(false);
                }
                ++i;
            }
            if (this.isValid()) {
                try {
                    this.angle[0] = MyMath.mvArg(this.xi[0] - this.xi[1], this.yi[0] - this.yi[1]);
                    this.angle[1] = MyMath.mvArg(this.xi[2] - this.xi[1], this.yi[2] - this.yi[1]);
                    if (this.reversed) {
                        double buf = this.angle[0];
                        this.angle[0] = this.angle[1];
                        this.angle[1] = buf;
                    }
                }
                catch (Exception e) {
                    this.setValid(false);
                }
            }
        }
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushBool(this.reversed);
        this.stack.pushDouble(this.angle[0]);
        this.stack.pushDouble(this.angle[1]);
    }

    @Override
    public void restoreState() {
        this.angle[1] = this.stack.popDouble();
        this.angle[0] = this.stack.popDouble();
        this.reversed = this.stack.popBool();
        super.restoreState();
    }

    protected double getAngle() {
        double val = this.angle[1] - this.angle[0];
        if (val < 0.0) {
            val += Math.PI * 2;
        }
        return val;
    }

    protected boolean isInAngleRange(double a) {
        double a2 = this.angle[1];
        if (a2 < this.angle[0]) {
            a2 += Math.PI * 2;
        }
        return a >= this.angle[0] && a <= a2;
    }

    @Override
    protected String defName() {
        return "\u03b1";
    }

    protected boolean isRightAngle() {
        return Math.abs(this.getAngle() - 1.5707963267948966) < 0.0017453299999999998;
    }
}

