/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import geoobj.GCircle;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GArc
extends GCircle {
    protected double x2 = 0.0;
    protected double y2 = 0.0;
    protected double x3 = 0.0;
    protected double y3 = 0.0;
    protected double startAngle = 0.0;
    protected double endAngle = 0.0;
    protected boolean reversed = false;

    public GArc(GeoObjList list, GeoObj iP1, GeoObj iSP, GeoObj iP2, boolean iReversed, boolean iIsVisible) {
        super(list);
        this.becomesChildOf(iSP);
        this.becomesChildOf(iP1);
        this.becomesChildOf(iP2);
        this.appearance.setVisible(iIsVisible);
        this.appearance.setBrushStyle(1);
        this.ccMask = 6160;
        this.updateParams(null, 0.0, 0.0);
    }

    public GArc(GeoObjList list) {
        super(list);
        this.ccMask = 6160;
    }

    public GArc(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 6160;
        Element childElem = Helpers.getChildElementByName("direction", objElem);
        if (childElem != null) {
            if (childElem.getAttribute("x3") != null) {
                this.x3 = Double.parseDouble(childElem.getAttribute("x3"));
                this.y3 = Double.parseDouble(childElem.getAttribute("y3"));
            }
            if (childElem.getAttribute("inverted") != null) {
                this.reversed = Boolean.parseBoolean(childElem.getAttribute("inverted"));
            }
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = Helpers.getChildElementByName("position", domData);
        pos.setAttribute("x2", new Double(this.x2).toString());
        pos.setAttribute("y2", new Double(this.y2).toString());
        Element dir = domDoc.createElement("direction");
        dir.setAttribute("x3", new Double(this.x3).toString());
        dir.setAttribute("y3", new Double(this.y3).toString());
        if (this.getReversed()) {
            dir.setAttribute("inverted", "true");
        }
        domData.appendChild(dir);
        return domData;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            double aa = MyMath.mvArg(mx - this.fData.x, my - this.fData.y);
            if (aa > this.startAngle && aa <= this.endAngle || this.endAngle > Math.PI * 2 && aa < this.endAngle - Math.PI * 2) {
                return Math.abs(MyMath.hypot(mx - this.fData.x, my - this.fData.y) - this.getRadius());
            }
            return Math.min(MyMath.hypot(mx - this.x2, my - this.y2), MyMath.hypot(mx - this.x3, my - this.y3));
        }
        return 1.0E20;
    }

    @Override
    public double getValue(int select) {
        switch (select) {
            case 0: 
            case 9: {
                return this.endAngle - this.startAngle;
            }
            case 5: {
                return MyMath.sqr(this.getRadius()) * 0.5 * (this.endAngle - this.startAngle);
            }
            case 3: {
                return this.getRadius() * (this.endAngle - this.startAngle);
            }
        }
        return super.getValue(select);
    }

    public boolean getReversed() {
        return this.reversed;
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        double[] p = new double[]{px, py};
        double[] res = MyMath.getArcParamFromPt(this.getCoordData(), this.startAngle, this.endAngle, p);
        return res[2];
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        double[] res = MyMath.getArcPtFromParam(this.getCoordData(), this.startAngle, this.endAngle, param);
        return res;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        GPoint mp = (GPoint)this.parent.get(0);
        GPoint sp = (GPoint)this.parent.get(1);
        GPoint ep = (GPoint)this.parent.get(2);
        if (mp != null && sp != null && ep != null && mp.isValid() && sp.isValid() && ep.isValid()) {
            this.fData.x = mp.getx(0);
            this.fData.y = mp.gety(0);
            this.x2 = sp.getx(0);
            this.y2 = sp.gety(0);
            this.x3 = ep.getx(0);
            this.y3 = ep.gety(0);
            double k = MyMath.hypot(this.x2 - this.fData.x, this.y2 - this.fData.y) / MyMath.hypot(this.x3 - this.fData.x, this.y3 - this.fData.y);
            this.x3 = this.fData.x + (this.x3 - this.fData.x) * k;
            this.y3 = this.fData.y + (this.y3 - this.fData.y) * k;
            double dx = this.x2 - this.fData.x;
            double dy = this.y2 - this.fData.y;
            this.fData.z = MyMath.hypot(dx, dy);
            if (this.reversed) {
                this.startAngle = MyMath.mvArg(this.x3 - this.fData.x, this.y3 - this.fData.y);
                this.endAngle = MyMath.mvArg(dx, dy);
            } else {
                this.startAngle = MyMath.mvArg(dx, dy);
                this.endAngle = MyMath.mvArg(this.x3 - this.fData.x, this.y3 - this.fData.y);
            }
            if (this.startAngle > this.endAngle) {
                this.endAngle += Math.PI * 2;
            }
            this.setValid(true);
        } else {
            this.setValid(false);
        }
    }

    @Override
    public boolean isVisible() {
        boolean res = super.isVisible();
        if (res) {
            double da = Math.abs(this.endAngle - this.startAngle);
            while (da > Math.PI * 2) {
                da -= Math.PI * 2;
            }
            res = da < 6.283010774179586;
        }
        return res;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawArc(this.fData.x, this.fData.y, this.getRadius(), this.startAngle, this.endAngle, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor(), 1, null);
        }
    }
}

