/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import geoobj.GLineObj;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GArea
extends GeoObj {
    protected boolean fOrientation = true;
    protected CoordsCanvas myCanvas = null;
    protected Area areaComp = null;
    private String ops = "";

    public GArea(GeoObjList list) {
        super(list);
        this.ccMask = 0x100000;
    }

    public GArea(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element childElem = Helpers.getChildElementByName("orientation", objElem);
        if (childElem != null) {
            this.fOrientation = Boolean.parseBoolean(childElem.getTextContent().trim());
        }
        if ((childElem = Helpers.getChildElementByName("operators", objElem)) != null) {
            this.ops = childElem.getTextContent().trim();
        }
        this.ccMask = 0x100000;
    }

    public GArea(GeoObjList list, GLineObj border, boolean iIsVisible) {
        super(list);
        this.becomesChildOf(border);
        this.appearance.setBrushStyle(3);
        this.appearance.setColor(Color.red);
        this.updateParams(null, 0.0, 0.0);
        this.setVisible(iIsVisible);
        this.ccMask = 0x100000;
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        if (!this.fOrientation) {
            Element orient = domDoc.createElement("orientation");
            orient.setTextContent("false");
            domData.appendChild(orient);
        }
        if (this.ops.length() > 0) {
            Element opera = domDoc.createElement("operators");
            opera.setTextContent(this.ops);
            domData.appendChild(opera);
        }
        return domData;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.myCanvas = canvas;
    }

    @Override
    public String defName() {
        return "F";
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.hasSameParentsAs(o, true);
    }

    @Override
    public double dist(double mx, double my) {
        double res = 1.0E20;
        Point2D.Double sp = new Point2D.Double(mx, my);
        if (this.isValid() && this.myCanvas != null) {
            this.myCanvas.getScreenPtCoords(mx, my, sp);
            if (this.areaComp != null && this.areaComp.contains(sp.x, sp.y)) {
                res = 0.0;
            }
        }
        return res;
    }

    @Override
    public double getValue(int select) {
        switch (select) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                double res = 0.0;
                res = this.parent.size() == 1 ? this.parent.get(0).getValue(select) : this.parent.get(0).getValue(select);
                return res;
            }
        }
        return super.getValue(select);
    }

    @Override
    public boolean canMoveFree() {
        if (this.parent.size() == 1) {
            return this.parent.get(0).canMoveFree();
        }
        return true;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        this.myCanvas = canvas;
        if (this.isVisible()) {
            this.areaComp = this.getAreaComp(0, canvas);
            if (this.areaComp != null) {
                if (this.ops.length() > 0) {
                    char op = '\u0000';
                    int i = 1;
                    while (i <= this.ops.length()) {
                        Area areaComp2 = this.getAreaComp(i, canvas);
                        if (areaComp2 != null) {
                            op = this.ops.charAt(i - 1);
                            switch (op) {
                                case '+': {
                                    this.areaComp.add(this.getAreaComp(i, canvas));
                                    break;
                                }
                                case '-': {
                                    this.areaComp.subtract(this.getAreaComp(i, canvas));
                                    break;
                                }
                                case '*': {
                                    this.areaComp.intersect(this.getAreaComp(i, canvas));
                                }
                            }
                        }
                        ++i;
                    }
                }
                canvas.fillShape(this.areaComp, this.appearance.getBrushStyle(), this.appearance.getFillColor());
            }
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        menu.add2List(new JMenuItem(Messages.getString("GArea.menu_editpattern")), 64);
    }

    public void setFillStyle(int new_fs) {
        this.appearance.setBrushStyle(new_fs);
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        int i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).moveBy(dx, dy, canvas);
            ++i;
        }
    }

    private Area getAreaComp(int n, CoordsCanvas canvas) {
        Shape bl = ((GLineObj)this.parent.get(n)).getBorder(canvas);
        if (bl != null) {
            if (bl instanceof Arc2D) {
                ((Arc2D)bl).setArcType(2);
            }
            return new Area(bl);
        }
        return null;
    }
}

