/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import geoobj.GCircle;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;
import xml.Helpers;

public class GBasisCircle
extends GCircle {
    public GBasisCircle(GeoObjList list, double ix, double iy, double ir, boolean isVisible) {
        super(list, null, null, isVisible);
        this.fData.x = ix;
        this.fData.y = iy;
        this.fData.z = ir;
        this.ccMask |= 1;
    }

    public GBasisCircle(GeoObjList list) {
        super(list);
        this.ccMask |= 1;
    }

    public GBasisCircle(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element childElem = Helpers.getChildElementByName("radius", objElem);
        if (childElem != null) {
            this.fData.z = Double.parseDouble(childElem.getTextContent());
        }
        this.ccMask |= 1;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        double dy;
        double dx;
        double new_r;
        this.setValid(true);
        if (this == mousedObj && (new_r = MyMath.hypot(dx = this.fData.x - mx, dy = this.fData.y - my)) > 1.0E-6) {
            this.fData.x = mx + (dx /= new_r) * this.fData.z;
            this.fData.y = my + (dy /= new_r) * this.fData.z;
            this.setValid(true);
        }
    }
}

