/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GLine;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GBasisLine
extends GLine {
    public GBasisLine(GeoObjList list, double[] pos, boolean isVisible) {
        super(list, null, null, false);
        this.x1 = pos[0];
        this.y1 = pos[1];
        this.x2 = pos[2];
        this.y2 = pos[3];
        this.afterLoading(null);
        this.setVisible(isVisible);
        this.ccMask |= 1;
    }

    public GBasisLine(GeoObjList list) {
        super(list);
        this.ccMask |= 1;
    }

    public GBasisLine(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask |= 1;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.eq[0] = this.y1 - this.y2;
        this.eq[1] = this.x2 - this.x1;
        double c = MyMath.hypot(this.eq[0], this.eq[1]);
        if (Math.abs(c) > 1.0E-12) {
            this.eq[0] = this.eq[0] / c;
            this.eq[1] = this.eq[1] / c;
            this.eq[2] = this.eq[0] * this.x1 + this.eq[1] * this.y1;
            this.x2 = this.x1 + this.eq[1];
            this.y2 = this.y1 - this.eq[0];
            this.setValid(true);
        } else {
            this.setValid(false);
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.setValid(true);
        if (this == mousedObj) {
            this.eq[2] = this.eq[0] * mx + this.eq[1] * my;
            double[] pt = new double[]{this.x1, this.y1};
            Vector3 fp = MyMath.getPedalPoint(this.eq, pt);
            this.x1 = fp.x;
            this.y1 = fp.y;
            this.x2 = this.x1 + this.eq[1];
            this.y2 = this.y1 - this.eq[0];
        }
    }
}

