/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import geoobj.GLine;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GBisector
extends GLine {
    private boolean useInheritedGetCoords = true;

    public GBisector(GeoObjList list, GeoObj ip1, GeoObj ip2, GeoObj ip3, boolean iIsVisible) {
        super(list);
        this.becomesChildOf(ip1);
        this.becomesChildOf(ip2);
        this.becomesChildOf(ip3);
        this.setVisible(iIsVisible);
        this.updateParams(null, 0.0, 0.0);
    }

    public GBisector(GeoObjList list) {
        super(list);
    }

    public GBisector(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return o.getClass().equals(this.getClass()) && this.hasSameParentsAs(o, true);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        double[] px = new double[3];
        double[] py = new double[3];
        this.setValid(true);
        int i = 0;
        while (i < 3) {
            GPoint p = (GPoint)this.parent.get(i);
            if (p.isValid()) {
                px[i] = p.getx(0);
                py[i] = p.gety(0);
            } else {
                this.setValid(false);
            }
            ++i;
        }
        if (this.isValid()) {
            this.x1 = px[1];
            this.y1 = py[1];
            double dx1 = px[0] - this.x1;
            double dy1 = py[0] - this.y1;
            double dx2 = px[2] - this.x1;
            double dy2 = py[2] - this.y1;
            double nf1 = MyMath.hypot(dx1, dy1);
            if (nf1 < 1.0E-6) {
                this.setValid(false);
            } else {
                double nf2 = MyMath.hypot(dx2, dy2);
                if (nf2 < 1.0E-6) {
                    this.setValid(false);
                } else {
                    double dx0 = (dx1 /= nf1) + (dx2 /= nf2);
                    double dy0 = (dy1 /= nf1) + (dy2 /= nf2);
                    if (MyMath.hypot(dx0, dy0) > 1.0E-12) {
                        this.x2 = this.x1 + dx0;
                        this.y2 = this.y1 + dy0;
                        this.useInheritedGetCoords = true;
                    } else {
                        this.x2 = this.x1 + dy1 - dy2;
                        this.y2 = this.y1 + dx2 - dx1;
                        this.useInheritedGetCoords = false;
                    }
                    double[] pt = new double[]{this.x1, this.y1};
                    double[] dir = new double[]{this.x2 - this.x1, this.y2 - this.y1};
                    this.setEq(MyMath.getHesseEqFromPtAndDir(pt, dir));
                }
            }
        }
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        if (this.useInheritedGetCoords) {
            return super.getCoordsFromParam(param);
        }
        double[] res = new double[]{this.x1, this.y1};
        return res;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushBool(this.useInheritedGetCoords);
    }

    @Override
    public void restoreState() {
        this.useInheritedGetCoords = this.stack.popBool();
        super.restoreState();
    }
}

