/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCircle;
import geoobj.GLine;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GChordal
extends GLine {
    public GChordal(GeoObjList list, GeoObj ip1, GeoObj ip2, boolean isVisible) {
        super(list, ip1, ip2, isVisible);
    }

    public GChordal(GeoObjList list) {
        super(list);
    }

    public GChordal(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        Vector3 chordal;
        this.setValid(false);
        Vector3[] c = new Vector3[]{new Vector3(0.0, 0.0, 0.0, -2), new Vector3(0.0, 0.0, 0.0, -2)};
        int i = 0;
        while (i <= 1) {
            if (this.parent.get(i).isCompatibleTo(4096)) {
                c[i] = ((GCircle)this.parent.get(i)).getCoordData();
                c[i].setValid(this.parent.get(i).isValid());
            } else if (this.parent.get(i).isCompatibleTo(2)) {
                GPoint p = (GPoint)this.parent.get(i);
                c[i].assign(p.x, p.y, 0.0);
                c[i].setValid(this.parent.get(i).isValid());
            }
            ++i;
        }
        if (c[0].getValid() && c[1].getValid() && (chordal = MyMath.getChordalLineFromCircles(c[0], c[1])) != null && chordal.getValid()) {
            this.setEq(chordal);
            this.setValid(true);
        }
    }
}

