/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GLineObj;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GCircle
extends GLineObj {
    public static double paramEpsilon = 1.0E-6;
    Vector3 fData = new Vector3();

    public GCircle(GeoObjList list, GeoObj iMP, GeoObj iPP, boolean iIsVisible) {
        super(list);
        this.becomesChildOf(iMP);
        this.becomesChildOf(iPP);
        this.appearance.setVisible(iIsVisible);
        this.appearance.setBrushStyle(1);
        this.ccMask = 4112;
        if (this.getClass() == GCircle.class) {
            this.updateParams(null, 0.0, 0.0);
        }
    }

    public GCircle(GeoObjList list) {
        super(list);
        this.ccMask = 4112;
    }

    public GCircle(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 4112;
        if (this instanceof GCircle) {
            Element childElem;
            if (this.getClass().equals(GCircle.class) && (childElem = Helpers.getChildElementByName("radius", objElem)) != null) {
                this.fData.z = Double.parseDouble(childElem.getTextContent());
            }
            if ((childElem = Helpers.getChildElementByName("position", objElem)) != null) {
                this.fData.x = Double.parseDouble(childElem.getAttribute("x1"));
                this.fData.y = Double.parseDouble(childElem.getAttribute("y1"));
            }
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = domDoc.createElement("position");
        pos.setAttribute("x1", new Double(this.fData.x).toString());
        pos.setAttribute("y1", new Double(this.fData.y).toString());
        domData.appendChild(pos);
        Element rds = domDoc.createElement("radius");
        rds.setTextContent(new Double(this.getRadius()).toString());
        domData.appendChild(rds);
        return domData;
    }

    @Override
    protected String defName() {
        return "k";
    }

    @Override
    public boolean includes(GPoint pt) {
        return this.dist(pt.x, pt.y) < 1.0E-6;
    }

    @Override
    public double[] getTangentDirIn(double xp, double yp) {
        double[] dArray = new double[]{yp - this.fData.y, this.fData.x - xp};
        double[] res = dArray;
        double len = MyMath.hypot(res[0], res[1]);
        if (len > 1.0E-6) {
            res[0] = res[0] / len;
            res[1] = res[1] / len;
            return res;
        }
        return null;
    }

    @Override
    public double[] getNormalDirIn(double xp, double yp) {
        double[] dArray = new double[]{xp - this.fData.x, yp - this.fData.y};
        double[] res = dArray;
        double len = MyMath.hypot(res[0], res[1]);
        if (len > 1.0E-6) {
            res[0] = res[0] / len;
            res[1] = res[1] / len;
            return res;
        }
        return null;
    }

    @Override
    public double[] getNameParamsFromCoords(double pox, double poy) {
        double[] pt = new double[]{pox, poy};
        double[] fpt = MyMath.getCircleParamFromPt(this.getCoordData(), pt);
        double[] res = new double[]{fpt[2], MyMath.hypot(this.fData.x - pox, this.fData.y - poy) - this.getRadius()};
        return res;
    }

    @Override
    public double[] getNameCoordsFromParams(double[] np) {
        double[] fpt = MyMath.getCirclePtFromParam(this.getCoordData(), np[0]);
        double[] res = new double[]{0.0, 0.0};
        double aRad = this.getRadius();
        if (aRad > 1.0E-6) {
            res[0] = fpt[0] + (fpt[0] - this.fData.x) / aRad * np[1];
            res[1] = fpt[1] + (fpt[1] - this.fData.y) / aRad * np[1];
        } else {
            res[0] = fpt[0] + np[1];
            res[1] = fpt[1];
        }
        return res;
    }

    @Override
    public double[] getDefaultNameParams() {
        double[] res = new double[]{0.125, 0.2};
        return res;
    }

    @Override
    public Shape getBorder(CoordsCanvas canvas) {
        Point2D.Double m = new Point2D.Double();
        Point2D.Double r = new Point2D.Double();
        canvas.getScreenPtCoords(this.fData.x, this.fData.y, m);
        canvas.getScreenPtCoords(this.fData.x + 2.0 * this.getRadius(), this.fData.y, r);
        double dr = r.x - m.x;
        Ellipse2D.Double border = new Ellipse2D.Double(m.x - dr / 2.0, m.y - dr / 2.0, dr, dr);
        return border;
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        ptList.reset2zList(30, 0.0, 1.0);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(false);
        GPoint MP = (GPoint)this.parent.get(0);
        GPoint PP = (GPoint)this.parent.get(1);
        if (MP.isValid() && PP.isValid()) {
            this.fData.assign(MP.x, MP.y, MyMath.hypot(MP.x - PP.x, MP.y - PP.y), 1);
            this.setValid(true);
        }
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        double[] p = new double[]{px, py};
        double[] res = MyMath.getCircleParamFromPt(this.getCoordData(), p);
        return res[2];
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        double[] res = MyMath.getCirclePtFromParam(this.getCoordData(), param);
        return res;
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        menu.add2List(new JMenuItem(Messages.getString("GCircle.menu_editstyle")), 63);
    }

    public double getRadius() {
        return this.fData.z;
    }

    @Override
    public Vector3 getCoordData() {
        return new Vector3(this.fData);
    }

    public double[] getConicEquation() {
        double[] res = new double[]{1.0, 0.0, 1.0, -this.fData.x, -this.fData.y, MyMath.sqr(this.fData.x) + MyMath.sqr(this.fData.y) - MyMath.sqr(this.getRadius())};
        return res;
    }

    @Override
    public double getValue(int select) {
        if (select == 4) {
            return this.getRadius();
        }
        if (select == 5) {
            return MyMath.sqr(this.getRadius()) * Math.PI;
        }
        if (select == 3) {
            return this.getRadius() * 2.0 * Math.PI;
        }
        if (select == 1) {
            return this.fData.x;
        }
        if (select == 2) {
            return this.fData.y;
        }
        return 0.0;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawEllipse(this.fData.x, this.fData.y, this.getRadius(), this.getRadius(), this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
        }
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            return Math.abs(MyMath.hypot(mx - this.fData.x, my - this.fData.y) - this.getRadius());
        }
        return 1.0E20;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushDouble(this.fData.x);
        this.stack.pushDouble(this.fData.y);
        this.stack.pushDouble(this.fData.z);
        this.stack.pushInt(this.fData.tag);
    }

    @Override
    public void restoreState() {
        int oTag = this.stack.popInt();
        double oZ = this.stack.popDouble();
        double oY = this.stack.popDouble();
        double oX = this.stack.popDouble();
        this.fData.assign(oX, oY, oZ, oTag);
        super.restoreState();
    }

    public boolean setLinePosition(double p) {
        if (p >= 0.0 && p <= 1.0) {
            double[] co = this.getCoordsFromParam(p);
            this.x = co[0];
            this.y = co[1];
            return true;
        }
        return false;
    }

    public double getLinePosition() {
        return this.getParamFromCoords(this.x, this.y);
    }
}

