/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.Options;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GLineObj;
import geoobj.GMappedCircle;
import geoobj.GMapping;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GCircle3P
extends GMappedCircle {
    public GCircle3P(GeoObjList list, GLineObj sourceLine, GMapping iMap, boolean isVisible) {
        super(list, sourceLine, iMap, isVisible);
    }

    public GCircle3P(GeoObjList list) {
        super(list);
    }

    public GCircle3P(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(false);
        Vector3[] c = new Vector3[]{new Vector3(), new Vector3(), new Vector3()};
        int i = 0;
        while (i < 3) {
            GPoint p = (GPoint)this.parent.get(i);
            c[i].assign(p.x, p.y, 0.0);
            c[i].setValid(p.isValid());
            ++i;
        }
        Vector3 m1 = MyMath.getChordalLineFromCircles(c[0], c[1]);
        Vector3 m2 = MyMath.getChordalLineFromCircles(c[1], c[2]);
        if (m1 != null && m2 != null) {
            Vector3 M = MyMath.intersectLines(m1, m2);
            double rmax = (double)(20 * Options.ori_drawWin_width) / Options.ppcm;
            double r = MyMath.hypot(c[1].x - M.x, c[1].y - M.y);
            if (M.z > 0.5 && r < rmax) {
                this.fData.assign(M.x, M.y, r);
                this.setValid(true);
            } else {
                double dist0 = MyMath.hypot(c[1].x - c[2].x, c[1].y - c[2].y);
                double dist1 = MyMath.hypot(c[0].x - c[2].x, c[0].y - c[2].y);
                double dist2 = MyMath.hypot(c[0].x - c[1].x, c[0].y - c[1].y);
                double[] v = new double[]{0.0, 0.0};
                double[] p = new double[]{0.0, 0.0};
                if (dist0 >= dist1 && dist0 >= dist2) {
                    v[0] = c[1].x - c[2].x;
                    v[1] = c[1].y - c[2].y;
                    p[0] = (c[1].x + c[2].x) / 2.0;
                    p[1] = (c[1].y + c[2].y) / 2.0;
                } else if (dist1 >= dist2 && dist1 >= dist0) {
                    v[0] = c[0].x - c[2].x;
                    v[1] = c[0].y - c[2].y;
                    p[0] = (c[0].x + c[2].x) / 2.0;
                    p[1] = (c[0].y + c[2].y) / 2.0;
                } else {
                    v[0] = c[0].x - c[1].x;
                    v[1] = c[0].y - c[1].y;
                    p[0] = (c[0].x + c[1].x) / 2.0;
                    p[1] = (c[0].y + c[1].y) / 2.0;
                }
                this.fData = MyMath.getHesseEqFromPtAndDir(p, v);
                if (this.fData.getValid()) {
                    this.fData.setValid(false);
                    this.setValid(true);
                }
            }
        }
    }
}

