/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import geoobj.GCircle;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import terms.TermTree;
import xml.Helpers;

public class GCircleWDR
extends GCircle {
    private TermTree rTerm;
    private String rStr;

    public GCircleWDR(GeoObjList list) {
        super(list);
    }

    public GCircleWDR(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element childNode = Helpers.getChildElementByName("radius", objElem);
        if (childNode != null) {
            this.rStr = childNode.getTextContent().trim();
            if (this.rStr == null || this.rStr.length() == 0) {
                Node rt = childNode.getAttributes().getNamedItem("r_term");
                if (rt != null) {
                    this.rStr = rt.getNodeValue().trim();
                }
                if (this.rStr == null || this.rStr.length() == 0) {
                    this.rStr = "1";
                    System.err.println("Default radius (= 1.0) added to " + this.name + "!");
                }
            }
        }
    }

    public GCircleWDR(GeoObjList list, GeoObj ip1, String iRad, boolean iIsVisible) {
        super(list, ip1, null, iIsVisible);
        this.setRadiusTerm(iRad);
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.rTerm = new TermTree(this.rStr, 0.0, this.drawing, TermTree.isRadMode);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element rds = Helpers.getChildElementByName("radius", domData);
        rds.setTextContent(this.getRadiusTerm());
        return domData;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        boolean res = super.hasSameDataAs(o);
        if (res) {
            res = this.rTerm != null && ((GCircleWDR)o).rTerm != null ? this.rTerm.hasSameDataAs(((GCircleWDR)o).rTerm) : this.rStr.equals(((GCircleWDR)o).rStr);
        }
        return res;
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        menu.add2List(new JMenuItem(Messages.getString("GCircleWDR.menu_editradius")), 65);
    }

    public String getRadiusTerm() {
        return this.rTerm.getTermString();
    }

    public void setRadiusTerm(String s) {
        if (this.rTerm == null) {
            this.rTerm = new TermTree(s, 0.0, this.drawing, TermTree.isDegMode);
        } else {
            this.rTerm.unregisterTermParentsIn(this);
            this.rTerm.buildTermTree(s, 0.0);
        }
        this.rTerm.registerTermParentsIn(this);
        this.updateParams(null, 0.0, 0.0);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(false);
        GPoint MP = (GPoint)this.parent.get(0);
        if (MP.isValid()) {
            double rVal = this.rTerm.getValue(0.0);
            if (this.rTerm.isOkay() && rVal >= 0.0) {
                this.fData.assign(MP.x, MP.y, rVal, 1);
                this.setValid(true);
            }
        }
    }
}

