/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCurve;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GConic
extends GCurve {
    protected double[][] rotmat = null;
    protected double[] params = new double[17];
    protected double[] eq = new double[6];

    public GConic(GeoObjList list, GeoObj[] ipts, boolean iIsVisible) {
        super(list);
        this.ccMask = 8208;
        int i = 0;
        while (i < ipts.length) {
            this.becomesChildOf(ipts[i]);
            ++i;
        }
        this.updateParams(null, 0.0, 0.0);
    }

    public GConic(GeoObjList list) {
        super(list);
        this.ccMask = 8208;
    }

    public GConic(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 8208;
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element prms = domDoc.createElement("params");
        prms.setAttribute("a", new Double(this.eq[0]).toString());
        prms.setAttribute("b", new Double(this.eq[1]).toString());
        prms.setAttribute("c", new Double(this.eq[2]).toString());
        prms.setAttribute("d", new Double(this.eq[3]).toString());
        prms.setAttribute("e", new Double(this.eq[4]).toString());
        prms.setAttribute("f", new Double(this.eq[5]).toString());
        domData.appendChild(prms);
        return domData;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.updateParams(null, 0.0, 0.0);
        this.fillPointList(canvas);
    }

    @Override
    public double[] getTangentDirIn(double xp, double yp) {
        double[] res = new double[]{-this.eq[1] * xp - this.eq[2] * yp - this.eq[4], this.eq[0] * xp + this.eq[1] * yp + this.eq[3]};
        double len = MyMath.hypot(res[0], res[1]);
        res[0] = res[0] / len;
        res[1] = res[1] / len;
        return res;
    }

    @Override
    public double[] getNormalDirIn(double xp, double yp) {
        double[] res = new double[]{this.eq[0] * xp + this.eq[1] * yp + this.eq[3], this.eq[1] * xp + this.eq[2] * yp + this.eq[4]};
        double len = MyMath.hypot(res[0], res[1]);
        res[0] = res[0] / len;
        res[1] = res[1] / len;
        return res;
    }

    @Override
    public boolean includes(GPoint pt) {
        if (this.getClass().equals(GConic.class)) {
            return this.parent.indexOf(pt) >= 0 || pt.parent.indexOf(this) >= 0;
        }
        return Math.abs(this.eq[0] * MyMath.sqr(pt.x) + 2.0 * this.eq[1] * pt.x * pt.y + this.eq[2] * MyMath.sqr(pt.y) + 2.0 * this.eq[3] * pt.x + 2.0 * this.eq[4] * pt.y + this.eq[5]) < 1.0E-6;
    }

    public boolean isEllipse() {
        return this.get_conicType() == 7;
    }

    public boolean isParabel() {
        return this.get_conicType() == 1;
    }

    public boolean isHyperbel() {
        return this.get_conicType() == 5 || this.get_conicType() == 4 || this.get_conicType() == 3;
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            switch (this.get_conicType()) {
                case 1: 
                case 5: 
                case 7: {
                    this.lastDist = super.dist(mx, my);
                    break;
                }
                case 2: 
                case 4: {
                    this.lastDist = Math.min(MyMath.distPt2Line(this.getG(1), mx, my), MyMath.distPt2Line(this.getG(2), mx, my));
                    break;
                }
                case 3: {
                    this.lastDist = MyMath.distPt2Line(this.getG(1), mx, my);
                    break;
                }
                case 6: {
                    this.lastDist = MyMath.hypot(mx - this.getX_m(), my - this.getY_m());
                    break;
                }
                default: {
                    this.lastDist = 1.0E20;
                    break;
                }
            }
        } else {
            this.lastDist = 1.0E20;
        }
        return this.lastDist;
    }

    public boolean containsPt(double px, double py) {
        return this.dist(px, py) < Math.sqrt(1.0E-6);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        if (this.ptList != null) {
            double[] ppts = new double[10];
            int i = 0;
            while (i < 5) {
                GPoint pp = (GPoint)this.parent.get(i);
                ppts[2 * i] = pp.getx(0);
                ppts[2 * i + 1] = pp.gety(0);
                ++i;
            }
            this.eq = MyMath.getConicCoeffFromPoints(ppts);
            this.params = MyMath.getConicParamsFromCoeff(this.eq, this.get_alpha());
            this.rotmat = MyMath.initRotMat(-this.get_alpha());
            super.updateParams(mousedObj, mx, my);
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            switch (this.get_conicType()) {
                case 0: {
                    break;
                }
                case 2: 
                case 4: {
                    int i = 1;
                    while (i < 3) {
                        canvas.drawLongLine(this.getG(i), this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
                        ++i;
                    }
                    break;
                }
                case 3: {
                    canvas.drawLongLine(this.getG(1), this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
                    break;
                }
                case 6: {
                    canvas.drawPoint(this.getX_m(), this.getY_m(), this.appearance.getLineWidth(), this.appearance.getShape(), this.appearance.getPointSize(), this.appearance.getColor());
                    break;
                }
                default: {
                    super.draw(canvas);
                }
            }
        }
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        double[] res = null;
        switch (this.get_conicType()) {
            case 2: 
            case 4: {
                if (Double.isNaN(param)) {
                    return res;
                }
                if (param > 0.5) {
                    double s = MyMath.ui2gt(4.0 * param - 3.0);
                    res = MyMath.getLinePtFromParam(this.getG(2), s, this.getX_n(), this.getY_n());
                    break;
                }
                double s = MyMath.ui2gt(4.0 * param - 1.0);
                res = MyMath.getLinePtFromParam(this.getG(1), s, this.getX_m(), this.getY_m());
                break;
            }
            case 3: {
                if (Double.isNaN(param)) {
                    return res;
                }
                double s = MyMath.ui2gt(2.0 * param - 1.0);
                res = MyMath.getLinePtFromParam(this.getG(1), s, this.getY_m(), this.getY_m());
                break;
            }
            case 6: {
                res = new double[]{this.getX_m(), this.getY_m()};
                break;
            }
            default: {
                double tx;
                double p = 0.0;
                double p2 = 0.0;
                double ty = 0.0;
                boolean pValid = false;
                if (!Double.isNaN(param) && param > 1.0E-12 && param < 0.999999999999) {
                    p = Math.tan(Math.PI * (param - 0.5));
                    p2 = MyMath.sqr(p);
                    pValid = true;
                }
                switch (this.get_conicType()) {
                    case 1: {
                        if (pValid) {
                            tx = this.get_eccen() * p;
                            ty = this.get_eccen() / 2.0 * p2;
                            break;
                        }
                        tx = 0.0;
                        ty = 0.0;
                        break;
                    }
                    case 5: {
                        if (pValid) {
                            if (Math.abs(1.0 - p2) > 1.0E-12) {
                                tx = this.get_a() * (1.0 + p2) / (1.0 - p2);
                                ty = 2.0 * this.get_b() * p / (1.0 - p2);
                                break;
                            }
                            tx = this.get_a();
                            ty = 0.0;
                            break;
                        }
                        tx = -this.get_a();
                        ty = 0.0;
                        break;
                    }
                    case 7: {
                        if (pValid) {
                            tx = this.get_a() * (1.0 - p2) / (1.0 + p2);
                            ty = 2.0 * this.get_b() * p / (1.0 + p2);
                            break;
                        }
                        tx = -this.get_a();
                        ty = 0.0;
                        break;
                    }
                    default: {
                        tx = 0.0;
                        ty = 0.0;
                    }
                }
                res = new double[]{this.rotmat[0][0] * (tx += this.get_hdx()) + this.rotmat[1][0] * (ty += this.get_hdy()), this.rotmat[0][1] * tx + this.rotmat[1][1] * ty};
            }
        }
        return res;
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        Vector3 res = new Vector3();
        Vector3 t = new Vector3();
        Vector3 t2 = new Vector3();
        double[] p = new double[]{px, py};
        switch (this.get_conicType()) {
            case 2: 
            case 4: {
                t = MyMath.getPedalPoint(this.getG(1), p);
                t2 = MyMath.getPedalPoint(this.getG(2), p);
                if (MyMath.sqr(px - t.x) + MyMath.sqr(py - t.y) <= MyMath.sqr(px - t2.x) + MyMath.sqr(py - t2.y)) {
                    res = MyMath.getLineParamFromPt(this.getG(1), this.getM());
                    res.z = (MyMath.gt2ui(res.z) + 1.0) / 4.0;
                    break;
                }
                res = MyMath.getLineParamFromPt(this.getG(2), this.getN());
                res.z = (MyMath.gt2ui(res.z) + 3.0) / 4.0;
                break;
            }
            case 3: {
                t = MyMath.getPedalPoint(this.getG(1), p);
                res = MyMath.getLineParamFromPt(this.getG(1), this.getM());
                res.z = (MyMath.gt2ui(res.z) + 1.0) / 2.0;
                break;
            }
            case 6: {
                res = new Vector3(this.getX_m(), this.getY_m(), 0.5);
                break;
            }
            default: {
                res = this.getCurvePtNextTo(px, py);
            }
        }
        if (res != null) {
            return res.z;
        }
        return -1.0;
    }

    @Override
    public double getValue(int select) {
        double res = 0.0;
        switch (select) {
            case 5: {
                if (this.get_conicType() != 7) break;
                res = Math.PI * this.get_a() * this.get_b();
                break;
            }
            case 3: {
                if (this.get_conicType() != 7) break;
                res = this.getEllipticCircumference();
                break;
            }
            case 1: {
                res = this.getX_m();
            }
            case 2: {
                res = this.getY_m();
            }
            default: {
                res = super.getValue(select);
            }
        }
        return res;
    }

    public double[] getEq() {
        double[] res = new double[6];
        System.arraycopy(this.eq, 0, res, 0, 6);
        return res;
    }

    @Override
    public void saveState() {
        super.saveState();
        int i = 0;
        while (i <= 5) {
            this.stack.pushDouble(this.eq[i]);
            ++i;
        }
        int j = 0;
        while (j <= 16) {
            this.stack.pushDouble(this.params[j]);
            ++j;
        }
    }

    @Override
    public void restoreState() {
        int j = 16;
        while (j >= 0) {
            this.params[j] = this.stack.popDouble();
            --j;
        }
        this.rotmat = MyMath.initRotMat(-this.get_alpha());
        int i = 5;
        while (i >= 0) {
            this.eq[i] = this.stack.popDouble();
            --i;
        }
        super.restoreState();
    }

    @Override
    protected void fillPointList(CoordsCanvas canvas) {
        this.ptList.clear();
        switch (this.get_conicType()) {
            case 1: {
                double f_p = 0.025;
                double l_p = 1.0 - f_p;
                this.addPoints2List(f_p, l_p, 75);
                this.stretch2border(canvas, f_p, 0.0);
                this.stretch2border(canvas, l_p, 1.0);
                this.addSmoothingPts();
                break;
            }
            case 5: {
                double fp = 0.0;
                double lp = 0.225;
                this.addPoints2List(fp, lp, 20);
                this.stretch2border(canvas, lp, 0.25);
                fp = 0.275;
                this.stretch2border(canvas, fp, 0.25);
                lp = 0.725;
                this.addPoints2List(fp, lp, 40);
                this.stretch2border(canvas, lp, 0.75);
                fp = 0.775;
                this.stretch2border(canvas, fp, 0.75);
                this.addPoints2List(fp, 1.0, 20);
                this.addSmoothingPts();
                this.addLineBreakAt(0.25);
                this.addLineBreakAt(0.75);
                break;
            }
            case 7: {
                this.addPoints2List(0.0, 1.0, 100);
                this.addSmoothingPts();
            }
        }
    }

    private void stretch2border(CoordsCanvas canvas, double p, double bp) {
        Vector3 v;
        double dp = p - bp;
        do {
            try {
                p = bp + dp;
                double[] buf = this.getCoordsFromParam(p);
                v = new Vector3(buf[0], buf[1], p);
                this.ptList.insert(v);
            }
            catch (Exception e) {
                return;
            }
        } while (Math.abs(dp /= 2.0) > 1.0E-12 && canvas.containsPt(v.x, v.y));
    }

    private void addLineBreakAt(double p) {
        int i = -1;
        while (++i < this.ptList.count() && (this.ptList.get(i) == null || this.ptList.get((int)i).z < p)) {
        }
        this.ptList.insertAt(i, null);
    }

    protected int get_conicType() {
        return (int)Math.rint(this.params[0]);
    }

    protected double getX_m() {
        return this.params[1];
    }

    protected double getY_m() {
        return this.params[2];
    }

    protected double[] getM() {
        double[] res = new double[2];
        System.arraycopy(this.params, 1, res, 0, 2);
        return res;
    }

    protected double getX_n() {
        return this.params[3];
    }

    protected double getY_n() {
        return this.params[4];
    }

    protected double[] getN() {
        double[] res = new double[2];
        System.arraycopy(this.params, 3, res, 0, 2);
        return res;
    }

    protected double get_hdx() {
        return this.params[5];
    }

    protected double get_hdy() {
        return this.params[6];
    }

    protected double get_alpha() {
        return this.params[7];
    }

    protected double get_a() {
        return this.params[8];
    }

    protected double get_b() {
        return this.params[9];
    }

    protected double get_eccen() {
        return this.params[10];
    }

    protected double[] getG(int n) {
        double[] res = new double[3];
        switch (n) {
            case 1: {
                System.arraycopy(this.params, 11, res, 0, 3);
                break;
            }
            case 2: {
                System.arraycopy(this.params, 14, res, 0, 3);
                break;
            }
            default: {
                res = null;
            }
        }
        return res;
    }

    protected double getEllipticCircumference() {
        double res = 0.0;
        double a = this.params[8];
        double b = this.params[9];
        if (a + b > 0.0) {
            double k = (a - b) / (a + b);
            k = 3.0 * k * k;
            res = (a + b) * Math.PI * (1.0 + k / (10.0 + Math.sqrt(4.0 - k)));
        }
        return res;
    }

    private int addPoint2List(double z) {
        double[] buf = this.getCoordsFromParam(z);
        return this.ptList.insert(new Vector3(buf[0], buf[1], z));
    }

    private void check4bending(Vector3 v0, Vector3 v1, Vector3 v2) {
        if (MyMath.tooMuchBending(v0, v1, v2)) {
            int n;
            double zp;
            if (v0.tag > 0 || v1.tag > 0) {
                zp = (v0.z + v1.z) / 2.0;
                n = this.addPoint2List(zp);
                this.check4bending(v0, this.ptList.get(n), v1);
            }
            if (v1.tag > 0 || v2.tag > 0) {
                zp = (v1.z + v2.z) / 2.0;
                n = this.addPoint2List(zp);
                this.check4bending(v1, this.ptList.get(n), v2);
            }
        }
    }

    protected void addSmoothingPts() {
        Vector3 pe;
        if (this.ptList.count() < 3) {
            return;
        }
        int n = 1;
        do {
            Vector3 pa = this.ptList.get(n - 1);
            Vector3 pm = this.ptList.get(n);
            pe = this.ptList.get(n + 1);
            this.check4bending(pa, pm, pe);
        } while ((n = this.ptList.getPtIndexNextToZ(pe.z) + 1) <= this.ptList.count() - 2);
    }
}

