/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GLineObj;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class GCurve
extends GLineObj {
    protected V3List ptList = new V3List();
    protected GeneralPath curve = null;

    public GCurve(GeoObjList list) {
        super(list);
        this.ccMask = 16;
    }

    public GCurve(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 16;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.fillPointList(canvas);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pts = domDoc.createElement("points");
        String ptsStr = this.ptList.toString();
        pts.setTextContent(ptsStr);
        domData.appendChild(pts);
        return domData;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.curve = null;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            if (this.curve == null) {
                this.fillPointList(canvas);
                this.curve = this.ptList.getSegmentedCurve(canvas);
            }
            if (this.curve != null) {
                canvas.drawCurve(this.curve, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
            } else {
                int i = 0;
                while (i < this.ptList.count()) {
                    Vector3 v = this.ptList.get(i);
                    if (v != null && v.getValid()) {
                        canvas.drawPoint(v.x, v.y, 1, 2, 2, this.appearance.getColor());
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void resize(CoordsCanvas canvas) {
        this.updateParams(null, 0.0, 0.0);
    }

    @Override
    public Shape getBorder(CoordsCanvas canvas) {
        if (this.curve == null) {
            this.curve = this.ptList.getSegmentedCurve(canvas);
        }
        return this.curve;
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        ptList.reset2zList(20, 0.0, 1.0);
    }

    @Override
    public double dist(double xm, double ym) {
        if (this.isValid()) {
            int n = this.ptList.getPtIndexNextToXY(xm, ym);
            if (n >= 0 && this.ptList.get(n) != null) {
                double dn;
                double dv;
                double dp = MyMath.hypot(this.ptList.get((int)n).x - xm, this.ptList.get((int)n).y - ym);
                if (n > 0 && this.ptList.get(n - 1) != null && (dv = MyMath.distPt2ShortLn(this.ptList.get((int)(n - 1)).x, this.ptList.get((int)(n - 1)).y, this.ptList.get((int)n).x, this.ptList.get((int)n).y, xm, ym)) < dp) {
                    dp = dv;
                }
                if (n < this.ptList.count() - 1 && this.ptList.get(n + 1) != null && (dn = MyMath.distPt2ShortLn(this.ptList.get((int)n).x, this.ptList.get((int)n).y, this.ptList.get((int)(n + 1)).x, this.ptList.get((int)(n + 1)).y, xm, ym)) < dp) {
                    dp = dn;
                }
                this.lastDist = dp;
            } else {
                this.lastDist = 1.0E20;
            }
        }
        return this.lastDist;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushObj(new V3List(this.ptList));
    }

    @Override
    public void restoreState() {
        this.ptList = (V3List)this.stack.popObj();
        super.restoreState();
    }

    @Override
    protected String defName() {
        return "c_";
    }

    protected abstract void fillPointList(CoordsCanvas var1);

    protected void addPoints2List(double zmin, double zmax, int n) {
        double dz = (zmax - zmin) / (double)(n - 1);
        double z = zmin;
        int i = 1;
        while (i < n) {
            double[] buf = this.getCoordsFromParam(z);
            this.ptList.insert(new Vector3(buf[0], buf[1], z));
            z += dz;
            ++i;
        }
        double[] buf = this.getCoordsFromParam(zmax);
        this.ptList.insert(new Vector3(buf[0], buf[1], zmax));
    }

    protected Vector3 getCurvePtNextTo(double mx, double my) {
        int i = -1;
        int k = -1;
        int j = this.ptList.getPtIndexNextToXY(mx, my);
        if (j >= 0) {
            double xp = this.ptList.get((int)j).x;
            double yp = this.ptList.get((int)j).y;
            double t = this.ptList.get((int)j).z;
            if (j > 0) {
                i = j - 1;
            } else if (this.ptList.isClosed()) {
                i = this.ptList.count() - 2;
            }
            if (j < this.ptList.count() - 1) {
                k = j + 1;
            }
            if (i >= 0 && k >= 0) {
                double dt = Math.abs(this.ptList.get((int)k).z - this.ptList.get((int)i).z);
                if (dt > 0.5) {
                    dt = Math.abs(1.0 - dt);
                }
                dt /= 3.0;
                double lsd = MyMath.hypot(xp - mx, yp - my);
                while (dt > 1.0E-6) {
                    double tn = t + dt;
                    double[] q = this.getCoordsFromParam(tn);
                    double nsd = MyMath.hypot(q[0] - mx, q[1] - my);
                    if (nsd > lsd) {
                        tn = t - dt;
                        q = this.getCoordsFromParam(tn);
                        nsd = MyMath.hypot(q[0] - mx, q[1] - my);
                    }
                    if (nsd < lsd) {
                        lsd = nsd;
                        t = tn;
                        xp = q[0];
                        yp = q[1];
                    }
                    dt /= 2.0;
                }
            }
            return new Vector3(xp, yp, t);
        }
        return null;
    }
}

