/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCircle;
import geoobj.GConic;
import geoobj.GLine;
import geoobj.GLineObj;
import geoobj.GPoint;
import geoobj.GRay;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GDoubleIntersection
extends GeoObj {
    protected Point2D.Double[] pointList = new Point2D.Double[2];
    protected boolean[] validList;

    public GDoubleIntersection(GeoObjList list) {
        super(list);
        this.validList = new boolean[2];
    }

    public GDoubleIntersection(GeoObjList list, GeoObj ip1, GeoObj ip2) {
        super(list);
        this.pointList[0] = new Point2D.Double(0.0, 0.0);
        this.pointList[1] = new Point2D.Double(0.0, 0.0);
        this.validList = new boolean[2];
        if (ip2.isCompatibleTo(32) || ip1.isCompatibleTo(8192)) {
            this.becomesChildOf(ip2);
            this.becomesChildOf(ip1);
        } else {
            this.becomesChildOf(ip1);
            this.becomesChildOf(ip2);
        }
        this.updateParams(null, 0.0, 0.0);
    }

    public GDoubleIntersection(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.pointList[0] = new Point2D.Double(0.0, 0.0);
        this.pointList[1] = new Point2D.Double(0.0, 0.0);
        Element objPtList = Helpers.getChildElementByName("pointlist", objElem);
        String strPList = objPtList.getTextContent();
        String[] strPts = strPList.split(" ");
        int i = 0;
        while (i < strPts.length) {
            String[] strCoord = strPts[i].split(";");
            this.pointList[i].x = Double.parseDouble(strCoord[0]);
            this.pointList[i].y = Double.parseDouble(strCoord[1]);
            ++i;
        }
        this.validList = new boolean[2];
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element ptlist = domDoc.createElement("pointlist");
        String res = "";
        int i = 0;
        while (i < this.pointList.length) {
            if (this.pointList[i] != null) {
                if (res.length() > 0) {
                    res = String.valueOf(res) + " ";
                }
                res = String.valueOf(res) + new Double(this.pointList[i].x).toString() + ";" + new Double(this.pointList[i].y).toString();
            }
            ++i;
        }
        ptlist.setTextContent(res);
        domData.appendChild(ptlist);
        return domData;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.hasSameParentsAs(o, true);
    }

    @Override
    public double dist(double mx, double my) {
        return 1.0E20;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        double[] res;
        this.setValid(true);
        if (this.parent.get(0).isCompatibleTo(32)) {
            Object c;
            Vector3 g;
            if (this.parent.get(1).isCompatibleTo(4096)) {
                g = ((GLine)this.parent.get(0)).getEq();
                c = ((GCircle)this.parent.get(1)).getCoordData();
                res = MyMath.intersectLineAndCircle(g, (Vector3)c);
            } else {
                g = ((GLine)this.parent.get(0)).getEq();
                c = ((GConic)this.parent.get((int)1)).eq;
                res = MyMath.intersectLineAndConic(g, (double[])c);
            }
        } else {
            Vector3 c1 = ((GCircle)this.parent.get(0)).getCoordData();
            Vector3 c2 = ((GCircle)this.parent.get(1)).getCoordData();
            res = MyMath.intersectCircles(c1, c2);
        }
        if (res[2] > 0.5 && res[5] > 0.5) {
            Double dr = Math.hypot(res[0] - this.pointList[0].x, res[1] - this.pointList[0].y) + Math.hypot(res[3] - this.pointList[1].x, res[4] - this.pointList[1].y);
            Double df = Math.hypot(res[0] - this.pointList[1].x, res[1] - this.pointList[1].y) + Math.hypot(res[3] - this.pointList[0].x, res[4] - this.pointList[0].y);
            if (dr > df) {
                double p = res[0];
                res[0] = res[3];
                res[3] = p;
                double q = res[1];
                res[1] = res[4];
                res[4] = q;
                double f = res[2];
                res[2] = res[5];
                res[5] = f;
            }
        }
        if (res[2] > 0.5) {
            this.validList[0] = ((GLineObj)this.parent.get(0)).containsPoint(res[0], res[1]) && (((GLineObj)this.parent.get(1)).containsPoint(res[0], res[1]) || this.parent.get(1) instanceof GConic);
            this.pointList[0].setLocation(res[0], res[1]);
        } else {
            this.validList[0] = false;
        }
        if (res[5] > 0.5) {
            this.validList[1] = ((GLineObj)this.parent.get(0)).containsPoint(res[3], res[4]) && (((GLineObj)this.parent.get(1)).containsPoint(res[3], res[4]) || this.parent.get(1) instanceof GConic);
            this.pointList[1].setLocation(res[3], res[4]);
        } else {
            this.validList[1] = false;
        }
        if (this.parent.get(0) instanceof GRay && this.validList[0] && !this.validList[1]) {
            this.pointList[1].setLocation(this.pointList[0]);
            this.validList[0] = false;
            this.validList[1] = true;
        }
        if (this.validList[0] && this.validList[1] && this.parent.size() == 3) {
            this.check4Parent3();
        }
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
    }

    public double[] getCoords(int n) {
        double[] res = new double[3];
        if (n >= 0 && n < this.pointList.length && this.validList[n]) {
            res[0] = this.pointList[n].x;
            res[1] = this.pointList[n].y;
            res[2] = 1.0;
        } else {
            res[2] = 0.0;
        }
        return res;
    }

    @Override
    public void saveState() {
        super.saveState();
        int i = 0;
        while (i < this.pointList.length) {
            this.stack.pushDouble(this.pointList[i].x);
            this.stack.pushDouble(this.pointList[i].y);
            this.stack.pushBool(this.validList[i]);
            ++i;
        }
    }

    @Override
    public void restoreState() {
        int i = this.pointList.length - 1;
        while (i >= 0) {
            this.validList[i] = this.stack.popBool();
            this.pointList[i].y = this.stack.popDouble();
            this.pointList[i].x = this.stack.popDouble();
            --i;
        }
        super.restoreState();
    }

    @Override
    protected String defName() {
        return "DI";
    }

    protected void check4Parent3() {
        double d1;
        GPoint p3 = (GPoint)this.parent.get(2);
        double d0 = MyMath.hypot(this.pointList[0].x - p3.x, this.pointList[0].y - p3.y);
        if (d0 < (d1 = MyMath.hypot(this.pointList[1].x - p3.x, this.pointList[1].y - p3.y))) {
            Point2D.Double buf = this.pointList[0];
            this.pointList[0] = this.pointList[1];
            this.pointList[1] = buf;
        }
    }
}

