/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import geoobj.GEllipseF;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GEllipseK
extends GEllipseF {
    public GEllipseK(GeoObjList list) {
        super(list);
    }

    public GEllipseK(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    public GEllipseK(GeoObjList list, GeoObj[] ipts, boolean isVisible) {
        super(list, ipts, isVisible);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        if (this.ptList != null) {
            this.setValid(false);
            GPoint mp = (GPoint)this.parent.get(0);
            GPoint k1 = (GPoint)this.parent.get(1);
            GPoint k2 = (GPoint)this.parent.get(2);
            if (mp.isValid() & k1.isValid() & k2.isValid()) {
                double gk = mp.x - k1.x;
                double gm = mp.x - k2.x;
                double hl = mp.y - k1.y;
                double hn = mp.y - k2.y;
                if (Math.abs(gk * gm + hl * hn) > 1.0E-12) {
                    double u = gk - hn;
                    double v = hl + gm;
                    double d = MyMath.hypot(u, v);
                    if (d > 1.0E-12) {
                        u /= d;
                        v /= d;
                        double rx = 0.5 * (k1.x + mp.x - hn);
                        double ry = 0.5 * (k1.y + mp.y + gm);
                        double t = 0.5 * MyMath.hypot(gk + hn, hl - gm);
                        d = MyMath.hypot(k1.x - rx, k1.y - ry);
                        double a = t + d;
                        double b = t - d;
                        double c = Math.sqrt(Math.abs(MyMath.sqr(a) - MyMath.sqr(b)));
                        double mtx = rx - mp.x - t * u;
                        double mty = ry - mp.y - t * v;
                        d = MyMath.hypot(mtx, mty);
                        if (d > 1.0E-12) {
                            d = c / d;
                            double[] ppts = new double[]{mp.x + (mtx *= d), mp.y + (mty *= d), mp.x - mtx, mp.y - mty, k1.x, k1.y};
                            this.eq = MyMath.getConicCoeffFromFFP(ppts, true);
                            this.params = MyMath.getConicParamsFromCoeff(this.eq, this.get_alpha());
                            this.rotmat = MyMath.initRotMat(-this.get_alpha());
                            this.setValid(this.isEllipse());
                            this.curve = null;
                        }
                    }
                } else {
                    double mty;
                    double mtx;
                    double b;
                    double a;
                    double b1;
                    double a1 = MyMath.hypot(gk, hl);
                    if (a1 > (b1 = MyMath.hypot(gm, hn))) {
                        a = a1;
                        b = b1;
                        mtx = gk;
                        mty = hl;
                    } else {
                        a = b1;
                        b = a1;
                        mtx = gm;
                        mty = hn;
                    }
                    double c = Math.sqrt(Math.abs(MyMath.sqr(a) - MyMath.sqr(b)));
                    if (a > 1.0E-12) {
                        double d = c / a;
                        double[] ppts = new double[]{mp.x + (mtx *= d), mp.y + (mty *= d), mp.x - mtx, mp.y - mty, k2.x, k2.y};
                        this.eq = MyMath.getConicCoeffFromFFP(ppts, true);
                        this.params = MyMath.getConicParamsFromCoeff(this.eq, this.get_alpha());
                        this.rotmat = MyMath.initRotMat(-this.get_alpha());
                        this.setValid(this.isEllipse());
                        this.curve = null;
                    }
                }
            }
        }
    }
}

