/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GLine;
import geoobj.GNumber;
import geoobj.GPoint;
import geoobj.GTrace;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.LocLineController;
import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GEnvelope
extends GTrace {
    protected V3List lines = null;

    public GEnvelope(GeoObjList list) {
        super(list);
    }

    public GEnvelope(GeoObjList list, GeoObj iGeneratorLn, GeoObj iDraggedObj) {
        super(list);
        this.ccMask |= 0x8000;
        this.appearance.setLineWidth(3);
        this.appearance.setColor(Color.red);
        this.becomesChildOf(iDraggedObj);
        this.becomesChildOf(iGeneratorLn);
        this.lines = new V3List();
        this.setIsDynamic(iDraggedObj.getClass().equals(GPoint.class) && iDraggedObj.parent.size() > 0 || iDraggedObj.getClass().equals(GNumber.class));
        this.resetParentList();
        this.olStatus = -1;
    }

    public GEnvelope(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element lns = domDoc.createElement("lines");
        String lnsStr = this.lines.toString();
        lns.setTextContent(lnsStr);
        domData.appendChild(lns);
        return domData;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.myCanvas = canvas;
        if (this.lines == null) {
            this.lines = new V3List();
        }
        this.resetParentList();
    }

    @Override
    public void stopRecording(CoordsCanvas canvas) {
        this.myCanvas = canvas;
        this.olStatus = 15;
        this.updateParams(null, 0.0, 0.0);
    }

    public boolean showEnvelope() {
        return (this.olStatus & 4) > 0;
    }

    public void setShowEnvelope(boolean isShowEnv) {
        this.olStatus = isShowEnv ? (this.olStatus |= 4) : (this.olStatus &= 0xFFFFFFFB);
    }

    public boolean showLines() {
        return (this.olStatus & 8) > 0;
    }

    public void setShowLines(boolean isShowLines) {
        this.olStatus = isShowLines ? (this.olStatus |= 8) : (this.olStatus &= 0xFFFFFFF7);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        if (this.olStatus < 0 && mousedObj instanceof LocLineController) {
            int n;
            Vector3 ve;
            GeoObj contrObj = this.parent.first();
            if (contrObj.equals(this.parent.last())) {
                this.setIsDynamic(false);
            } else {
                this.setIsDynamic(contrObj.getClass().equals(GPoint.class) && contrObj.parent.size() > 0 || contrObj.getClass().equals(GNumber.class));
            }
            double lpos = ((LocLineController)((Object)mousedObj)).getLinePosition();
            Vector3 epv = new Vector3(0.0, 0.0, lpos);
            this.calculateOLPoint(epv);
            if (epv.getValid() && ((ve = this.ptList.get(n = this.ptList.getPtIndexNextToXY(epv.x, epv.y))) == null || MyMath.hypot(epv.x - ve.x, epv.y - ve.y) > 0.5)) {
                Vector3 vn = ((GLine)this.parent.last()).getEq();
                if (this.isDynamic()) {
                    int m = this.ptList.insert(epv);
                    this.lines.insertAt(m, vn);
                } else {
                    this.ptList.add(vn);
                    this.lines.add(vn);
                }
            }
        } else if (this.isDynamic()) {
            this.lines.clear();
            this.fillPointList(this.myCanvas);
            if (this.isValid()) {
                this.curve = null;
            }
        } else {
            this.setValid(true);
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        block10: {
            Vector3 v;
            int i;
            block9: {
                if (this.myCanvas == null) {
                    this.myCanvas = canvas;
                }
                if (this.olStatus >= 0) break block9;
                int i2 = 0;
                while (i2 < this.lines.count()) {
                    Vector3 v2 = this.lines.get(i2);
                    double[] ld = new double[]{v2.x, v2.y, v2.z};
                    canvas.drawLongLine(ld, 10, 1, this.appearance.getColor());
                    ++i2;
                }
                break block10;
            }
            if (!this.isVisible()) break block10;
            if (this.curve == null) {
                this.curve = this.ptList.getSegmentedCurve(canvas);
            }
            if (this.showLines()) {
                i = 0;
                while (i < this.lines.count()) {
                    v = this.lines.get(i);
                    double[] ld = new double[]{v.x, v.y, v.z};
                    canvas.drawLongLine(ld, 10, 1, this.appearance.getColor());
                    ++i;
                }
            }
            if (this.showEnvelope()) {
                if (this.curve != null && this.isSpline()) {
                    canvas.drawCurve(this.curve, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
                } else {
                    i = 0;
                    while (i < this.ptList.count()) {
                        v = this.ptList.get(i);
                        canvas.drawPoint(v.x, v.y, 1, 2, 2, this.appearance.getColor());
                        ++i;
                    }
                }
            }
        }
    }

    private Vector3 getGenLineEq(double param) {
        Vector3 v = null;
        GeoObj dp = this.parent.first();
        if (((LocLineController)((Object)dp)).setLinePosition(param)) {
            int i = 1;
            while (i < this.parent.size()) {
                try {
                    this.parent.get(i).updateParams(dp, 0.0, 0.0);
                }
                catch (Exception e) {
                    v = new Vector3();
                    v.setValid(false);
                    return v;
                }
                ++i;
            }
            if (this.parent.last().isValid()) {
                v = ((GLine)this.parent.last()).getEq();
            }
        }
        if (v == null) {
            v = new Vector3();
            v.setValid(false);
        }
        return v;
    }

    @Override
    protected void calculateOLPoint(Vector3 v) {
        Vector3 g0 = this.getGenLineEq(v.z - 1.0E-6);
        Vector3 g1 = this.getGenLineEq(v.z);
        Vector3 g2 = this.getGenLineEq(v.z + 1.0E-6);
        Vector3 p1 = g0.getValid() && g1.getValid() ? MyMath.intersectLines(g0, g1) : new Vector3(0.0, 0.0, 0.0);
        Vector3 p2 = g1.getValid() && g2.getValid() ? MyMath.intersectLines(g1, g2) : new Vector3(0.0, 0.0, 0.0);
        if (p1.getValid() && p2.getValid()) {
            v.x = (p1.x + p2.x) / 2.0;
            v.y = (p1.y + p2.y) / 2.0;
        } else if (p1.getValid()) {
            v.x = p1.x;
            v.y = p1.y;
        } else if (p2.getValid()) {
            v.x = p2.x;
            v.y = p2.y;
        }
        if (p1.getValid() || p2.getValid()) {
            v.tag = this.myCanvas != null ? (this.myCanvas.containsPt(v.x, v.y) ? 1 : (this.myCanvas.knowsPt(v.x, v.y) ? 0 : -2)) : 0;
        }
    }

    @Override
    protected void addLines(V3List pList) {
        int i = 0;
        while (i < pList.count()) {
            Vector3 vp = pList.get(i);
            Vector3 vl = this.getGenLineEq(vp.z);
            if (vl.getValid()) {
                this.lines.add(vl);
            }
            ++i;
        }
    }

    @Override
    protected String defName() {
        return "Env";
    }
}

