/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCurve;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import terms.TermTree;

public class GGraph
extends GCurve {
    protected TermTree term = null;
    private CoordsCanvas canvas = null;

    public GGraph(GeoObjList list, String iTerm, boolean isVisible) {
        super(list);
        this.term = new TermTree(iTerm, 0.0, list, TermTree.isRadMode);
        this.term.registerTermParentsIn(this);
        this.appearance.setVisible(isVisible);
        this.updateParams(null, 0.0, 0.0);
    }

    public GGraph(Element objElem, GeoObjList list) {
        super(objElem, list);
        NamedNodeMap attributes = objElem.getAttributes();
        String ts = attributes.getNamedItem("term").getNodeValue();
        this.term = new TermTree(ts, 0.0, list, TermTree.isRadMode);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        domData.setAttribute("term", this.getTermString());
        return domData;
    }

    @Override
    public boolean includes(GPoint pt) {
        double fy = this.term.getValue(pt.x);
        return Math.abs(fy - pt.y) < 1.0E-6;
    }

    @Override
    public double[] getTangentDirIn(double xp, double yp) {
        double df = this.term.getDiffValue(xp);
        double[] res = new double[]{1.0, df};
        double len = MyMath.hypot(1.0, df);
        res[0] = res[0] / len;
        res[1] = res[1] / len;
        return res;
    }

    @Override
    public double[] getNormalDirIn(double xp, double yp) {
        double df = this.term.getDiffValue(xp);
        double[] res = new double[]{-df, 1.0};
        double len = MyMath.hypot(1.0, df);
        res[0] = res[0] / len;
        res[1] = res[1] / len;
        return res;
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        double[] res = new double[]{param, this.term.getValue(param)};
        if (!this.term.isOkay()) {
            res[1] = 0.0;
        }
        return res;
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        Vector3 v = this.getCurvePtNextTo(px, py);
        return v.z;
    }

    public TermTree getTerm() {
        return this.term;
    }

    public String getTermString() {
        return this.term.getTermString();
    }

    public void setTermString(String ts) {
        this.term.unregisterTermParentsIn(this);
        this.term.buildTermTree(ts, 0.0);
        this.term.registerTermParentsIn(this);
        this.updateParams(null, 0.0, 0.0);
    }

    public double[] getPosFromParams(double[] pa) {
        double[] po = new double[]{pa[0], this.term.getValue(pa[0]) + pa[1]};
        return po;
    }

    public double[] getParamsFromPos(double pox, double poy) {
        double[] pa = new double[]{pox, poy - this.term.getValue(pox)};
        return pa;
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        menu.add2List(new JMenuItem(Messages.getString("GGraph.menu_editterm")), 76);
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        this.curve = null;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.term.hasSameDataAs(((GGraph)o).getTerm());
    }

    public double getMinValIn(double xmin, double xmax, double ppcm) {
        double dx;
        double y_min = 1.0E20;
        boolean res = true;
        if (xmax < xmin) {
            dx = xmin;
            xmin = xmax;
            xmax = dx;
        }
        dx = 0.2 / ppcm;
        double rx = xmin;
        do {
            double ry = this.term.getValue(rx);
            if (this.term.isOkay()) {
                if (!(ry < y_min)) continue;
                y_min = ry;
                continue;
            }
            res = false;
        } while ((rx += dx) <= xmax && res);
        if (res) {
            return y_min;
        }
        return 0.0;
    }

    public double getMaxValIn(double xmin, double xmax, double ppcm) {
        double dx;
        double y_max = -1.0E20;
        boolean res = true;
        if (xmax < xmin) {
            dx = xmin;
            xmin = xmax;
            xmax = dx;
        }
        dx = 0.2 / ppcm;
        double rx = xmin;
        do {
            double ry = this.term.getValue(rx);
            if (this.term.isOkay()) {
                if (!(ry > y_max)) continue;
                y_max = ry;
                continue;
            }
            res = false;
        } while ((rx += dx) <= xmax && res);
        if (res) {
            return y_max;
        }
        return 0.0;
    }

    private int addPoint2List(double iz) {
        double xp = iz;
        double yp = this.term.getValue(xp);
        int iTag = this.term.isOkay() ? (this.canvas.containsPt(xp, yp) ? 1 : 0) : -2;
        Vector3 vi = new Vector3(xp, yp, iz, iTag);
        return this.ptList.insert(vi);
    }

    @Override
    protected void addPoints2List(double xmin, double xmax, int n) {
        double dx = (xmax - xmin) / (double)(n - 1);
        double x = xmin;
        int i = 1;
        while (i <= n) {
            this.addPoint2List(x);
            x += dx;
            ++i;
        }
    }

    private void check4bending(Vector3 v0, Vector3 v1, Vector3 v2) {
        if (MyMath.tooMuchBending(v0, v1, v2)) {
            int n;
            double zp;
            if (v0.tag > 0 || v1.tag > 0) {
                zp = (v0.z + v1.z) / 2.0;
                if (Math.abs(v1.z - v0.z) > 1.0E-6) {
                    n = this.addPoint2List(zp);
                    this.check4bending(v0, this.ptList.get(n), v1);
                }
            }
            if (v1.tag > 0 || v2.tag > 0) {
                zp = (v1.z + v2.z) / 2.0;
                if (Math.abs(v2.z - v1.z) > 1.0E-6) {
                    n = this.addPoint2List(zp);
                    this.check4bending(v1, this.ptList.get(n), v2);
                }
            }
        }
    }

    private void addCuttingPts() {
        int i = 1;
        while (i < this.ptList.count()) {
            Vector3 v0 = this.ptList.get(i - 1);
            Vector3 v1 = this.ptList.get(i);
            if (v0 != null && v1 != null && v0.getValid() && v1.getValid() && Math.abs((v1.y - v0.y) / (v1.z - v0.z)) > 1000.0) {
                double np = (v0.z + v1.z) / 2.0;
                this.ptList.insert(new Vector3(0.0, 0.0, np, -2));
            }
            ++i;
        }
    }

    protected void addSmoothingPts() {
        Vector3 pe;
        if (this.ptList.count() < 3) {
            return;
        }
        int n = 1;
        do {
            Vector3 pa = this.ptList.get(n - 1);
            Vector3 pm = this.ptList.get(n);
            pe = this.ptList.get(n + 1);
            if (!pa.getValid() || !pm.getValid() || !pe.getValid()) continue;
            this.check4bending(pa, pm, pe);
        } while ((n = this.ptList.getPtIndexNextToZ(pe.z) + 1) <= this.ptList.count() - 2);
    }

    private void insertBorderPt(Vector3 v_in, Vector3 v_out, double minDist) {
        double dz = Math.abs(v_in.z - v_out.z);
        if (dz > 1.0E-6) {
            double nz = (v_in.z + v_out.z) / 2.0;
            int n = this.addPoint2List(nz);
            Vector3 v_m = this.ptList.get(n);
            if (v_m.tag == 1) {
                double dr = MyMath.hypot(v_m.x - v_out.x, v_m.y - v_out.y);
                if (dr > minDist) {
                    this.insertBorderPt(v_m, v_out, minDist);
                }
            } else {
                double dr = MyMath.hypot(v_m.x - v_in.x, v_m.y - v_in.y);
                if (dr > minDist) {
                    this.insertBorderPt(v_in, v_m, minDist);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void addBorderPts() {
        rangeWin = this.canvas.getCoordsRange();
        minDist = (rangeWin[3] - rangeWin[1]) / 20.0;
        i = 0;
        ** GOTO lbl16
        {
            ++i;
            do {
                if (i < this.ptList.count() - 1 && this.ptList.get((int)i).tag == this.ptList.get((int)(i + 1)).tag) continue block0;
                if (i >= this.ptList.count() - 1) continue;
                old_zmax = this.ptList.get((int)(i + 1)).z;
                if (this.ptList.get((int)i).tag == 1) {
                    this.insertBorderPt(this.ptList.get(i), this.ptList.get(i + 1), minDist);
                } else if (this.ptList.get((int)(i + 1)).tag == 1) {
                    this.insertBorderPt(this.ptList.get(i + 1), this.ptList.get(i), minDist);
                }
                i = Math.max(i, this.ptList.getPtIndexNextToZ(old_zmax)) + 1;
lbl16:
                // 3 sources

            } while (i < this.ptList.count() - 1);
        }
    }

    protected void completeRuns() {
        int i = 0;
        int rc = 0;
        while (i < this.ptList.count()) {
            double nz;
            rc = 0;
            while (i < this.ptList.count() && this.ptList.get((int)i).tag == 1) {
                ++i;
                ++rc;
            }
            if (rc > 0) {
                while (rc < 3) {
                    nz = (this.ptList.get((int)(i - 1)).z + this.ptList.get((int)i).z) / 2.0;
                    this.addPoint2List(nz);
                    if (this.ptList.get((int)i).tag <= 0) continue;
                    ++i;
                    ++rc;
                }
            }
            rc = 0;
            while (i < this.ptList.count() && this.ptList.get((int)i).tag <= 0 && this.ptList.get((int)i).tag > -2) {
                ++rc;
                ++i;
            }
            if (i < this.ptList.count() && rc > 0) {
                while (rc < 2) {
                    nz = (this.ptList.get((int)(i - 1)).z + this.ptList.get((int)i).z) / 2.0;
                    this.addPoint2List(nz);
                    if (this.ptList.get((int)i).tag > 0) continue;
                    ++i;
                    ++rc;
                }
                while (rc > 2) {
                    this.ptList.remove(i - 2);
                    --i;
                    --rc;
                }
            }
            while (i < this.ptList.count() && this.ptList.get((int)i).tag == -2) {
                ++i;
            }
        }
    }

    protected void cutInRuns() {
        int i = 0;
        while (i < this.ptList.count() - 1) {
            if (this.ptList.get((int)i).tag == 0 && this.ptList.get((int)(i + 1)).tag == 0) {
                this.ptList.insertAt(i + 1, null);
                ++i;
            } else if (this.ptList.get((int)i).tag == -2) {
                this.ptList.remove(i);
                this.ptList.insertAt(i, null);
            }
            ++i;
        }
    }

    @Override
    protected void fillPointList(CoordsCanvas iCanvas) {
        this.ptList.clear();
        this.canvas = iCanvas;
        double[] range = this.canvas.getCoordsRange();
        this.addPoints2List(range[0], range[2], 400);
        this.addSmoothingPts();
        this.addCuttingPts();
        this.addBorderPts();
        this.completeRuns();
        this.cutInRuns();
    }
}

