/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.Options;
import canvas.CoordsCanvas;
import geoobj.GArea;
import geoobj.GGraph;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.w3c.dom.Element;
import terms.TermTree;

public class GIntArea
extends GArea {
    protected GeneralPath myPath = new GeneralPath(0);
    protected double x1;
    protected double x2;
    protected double y1u;
    protected double y1d;
    protected double y2u;
    protected double y2d;
    protected double areaVal;
    protected TermTree f1 = null;
    protected TermTree f2 = null;

    public GIntArea(GeoObjList list, GGraph iBF1, GPoint iP1, GPoint iP2, GGraph iBF2, boolean iIsVisible) {
        super(list);
        this.becomesChildOf(iP1);
        this.becomesChildOf(iP2);
        this.becomesChildOf(iBF1);
        this.becomesChildOf(iBF2);
        this.updateParams(null, 0.0, 0.0);
        this.setVisible(iIsVisible);
    }

    public GIntArea(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public double getValue(int select) {
        switch (select) {
            case 1: {
                return this.x;
            }
            case 2: {
                return this.y;
            }
            case 5: {
                return this.areaVal;
            }
        }
        return super.getValue(select);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(true);
        this.x1 = this.parent.get(0).getx(0);
        this.x2 = this.parent.get(1).getx(0);
        this.f1 = ((GGraph)this.parent.get((int)2)).term;
        this.f2 = this.parent.size() > 3 ? ((GGraph)this.parent.get((int)3)).term : null;
        this.y1u = this.f1.getValue(this.x1);
        this.y2u = this.f1.getValue(this.x2);
        if (this.f2 == null) {
            this.y1d = 0.0;
            this.y2d = 0.0;
        } else {
            this.y1d = this.f2.getValue(this.x1);
            this.y2d = this.f2.getValue(this.x2);
        }
        if (!this.f1.isOkay() || this.f2 != null && !this.f2.isOkay()) {
            this.setValid(false);
        } else {
            this.areaVal = this.f1.integrate(this.x1, this.x2);
            if (!this.f1.isOkay()) {
                this.setValid(false);
            } else if (this.f2 != null) {
                this.areaVal -= this.f2.integrate(this.x1, this.x2);
                if (!this.f2.isOkay()) {
                    this.setValid(false);
                }
            }
        }
        if (this.isValid()) {
            this.x = (this.x1 + this.x2) / 2.0;
            this.y = this.f1.getValue(this.x);
            if (this.f2 != null) {
                this.y += this.f2.getValue(this.x);
            }
            this.y /= 2.0;
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            this.myCanvas = canvas;
            Point2D.Double p = new Point2D.Double();
            this.myPath.reset();
            canvas.getScreenPtCoords(this.x1, this.y1u, p);
            this.myPath.moveTo((float)p.x, (float)p.y);
            this.addCurve(this.f1, this.x1, this.x2);
            canvas.getScreenPtCoords(this.x2, this.y2u, p);
            this.myPath.lineTo((float)p.x, (float)p.y);
            canvas.getScreenPtCoords(this.x2, this.y2d, p);
            this.myPath.lineTo((float)p.x, (float)p.y);
            if (this.f2 != null) {
                this.addCurve(this.f2, this.x2, this.x1);
            }
            canvas.getScreenPtCoords(this.x1, this.y1d, p);
            this.myPath.lineTo((float)p.x, (float)p.y);
            this.myPath.closePath();
            this.areaComp = new Area(this.myPath);
            canvas.fillShape(this.areaComp, this.appearance.getBrushStyle(), this.appearance.getFillColor());
            this.drawBorder(canvas);
        }
    }

    public void drawBorder(CoordsCanvas canvas) {
        if (Math.signum(this.y1u) == Math.signum(this.y1d)) {
            canvas.drawSegment(this.x1, 0.0, this.x1, this.y1d, 2, this.appearance.getLineWidth(), this.appearance.getColor());
        }
        if (Math.signum(this.y2u) == Math.signum(this.y2d)) {
            canvas.drawSegment(this.x2, 0.0, this.x2, this.y2d, 2, this.appearance.getLineWidth(), this.appearance.getColor());
        }
        canvas.drawSegment(this.x1, this.y1u, this.x1, this.y1d, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
        canvas.drawSegment(this.x2, this.y2u, this.x2, this.y2d, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
    }

    protected void addCurve(TermTree f, double xa, double xz) {
        Point2D.Double p = new Point2D.Double();
        double dx = 10.0 / Options.ppcm;
        if (xz >= xa) {
            double _x = xa + dx;
            while (_x < xz) {
                double _y = f.getValue(_x);
                this.myCanvas.getScreenPtCoords(_x, _y, p);
                this.myPath.lineTo((float)p.x, (float)p.y);
                _x += dx;
            }
        } else {
            double _x = xa - dx;
            while (_x > xz) {
                double _y = f.getValue(_x);
                this.myCanvas.getScreenPtCoords(_x, _y, p);
                this.myPath.lineTo((float)p.x, (float)p.y);
                _x -= dx;
            }
        }
    }
}

