/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import geoobj.GDoubleIntersection;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GIntersectPoint
extends GPoint {
    protected int index = -1;

    public GIntersectPoint(GeoObjList list, GeoObj mi, int _n, boolean iIsVisible) {
        super(list);
        this.becomesChildOf(mi);
        this.index = _n;
        this.appearance.setShape(0);
        this.updateParams(null, 0.0, 0.0);
        this.ccMask = 2;
    }

    public GIntersectPoint(GeoObjList list) {
        super(list);
        this.ccMask = 2;
    }

    public GIntersectPoint(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 2;
        String indexStr = objElem.getAttributes().getNamedItem("plist_index").getNodeValue();
        this.index = Integer.parseInt(indexStr);
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.index == ((GIntersectPoint)o).index;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        GDoubleIntersection ISO = (GDoubleIntersection)this.parent.get(0);
        double[] res = ISO.getCoords(this.index);
        this.setValid(res[2] > 0.5);
        if (this.isValid()) {
            this.x = res[0];
            this.y = res[1];
        }
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushInt(this.index);
    }

    @Override
    public void restoreState() {
        this.index = this.stack.popInt();
        super.restoreState();
    }
}

