/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCircle;
import geoobj.GMapping;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GInversion
extends GMapping {
    Vector3 fData = new Vector3();

    public GInversion(GeoObjList list) {
        super(list);
    }

    public GInversion(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    public GInversion(GeoObjList list, GeoObj defC) {
        super(list);
        this.mapType = 20;
        this.becomesChildOf(defC);
        this.updateParams(null, 0.0, 0.0);
    }

    @Override
    public boolean getMappedPoint(double[] pt, double[] bpt) {
        if (this.isValid()) {
            double dx1 = pt[0] - this.fData.x;
            double dy1 = pt[1] - this.fData.y;
            double d1 = MyMath.hypot(dx1, dy1);
            if (d1 <= 1.0E-12) {
                return false;
            }
            double d2 = MyMath.sqr(this.fData.z / d1);
            bpt[0] = this.fData.x + dx1 * d2;
            bpt[1] = this.fData.y + dy1 * d2;
            return true;
        }
        return false;
    }

    @Override
    public boolean getMappedLine(Vector3 lineEq, Vector3 res) {
        if (lineEq.tag == 1) {
            return this.getMappedCircle(lineEq, res);
        }
        boolean ok = false;
        if (this.isValid()) {
            double d = lineEq.x * this.fData.x + lineEq.y * this.fData.y + lineEq.z;
            if (Math.abs(d) < 1.0E-12) {
                res.assign(lineEq);
                res.tag = 0;
                ok = true;
            } else {
                double[] centre = new double[]{this.fData.x, this.fData.y, 0.0};
                Vector3 fp = MyMath.getPedalPoint(lineEq, centre);
                double[] np = new double[]{fp.x, fp.y, 0.0};
                double[] mp = new double[]{0.0, 0.0};
                if (this.getMappedPoint(np, mp)) {
                    res.x = (this.fData.x + mp[0]) / 2.0;
                    res.y = (this.fData.y + mp[1]) / 2.0;
                    res.z = MyMath.hypot(this.fData.x - mp[0], this.fData.y - mp[1]) / 2.0;
                    res.tag = 1;
                    ok = true;
                }
            }
        }
        return ok;
    }

    @Override
    public boolean getMappedCircle(Vector3 circ, Vector3 res) {
        if (circ.tag == 0) {
            return this.getMappedLine(circ, res);
        }
        if (this.isValid()) {
            Vector3 g;
            double[] ip;
            double[] p = new double[]{this.fData.x, this.fData.y, 0.0};
            Vector3 v = new Vector3(circ.x - this.fData.x, circ.y - this.fData.y, 0.0);
            if (MyMath.hypot(v.x, v.y) < 1.0E-12) {
                v.assign(1.0, 0.0, 0.0);
            }
            if ((ip = MyMath.intersectLineAndCircle(g = MyMath.getHesseEqFromPtAndDir(p, v), circ))[2] > 0.5 && ip[5] > 0.5) {
                double[] ip1 = new double[]{ip[0], ip[1], 0.0};
                double[] ip2 = new double[]{ip[3], ip[4], 0.0};
                double[] mip1 = new double[]{0.0, 0.0, 0.0};
                double[] mip2 = new double[]{0.0, 0.0, 0.0};
                boolean v1 = this.getMappedPoint(ip1, mip1);
                boolean v2 = this.getMappedPoint(ip2, mip2);
                if (v1 && v2) {
                    res.assign((mip1[0] + mip2[0]) / 2.0, (mip1[1] + mip2[1]) / 2.0, MyMath.hypot(mip1[0] - mip2[0], mip1[1] - mip2[1]) / 2.0, 1);
                    return true;
                }
                double[] dir = new double[]{v.y, -v.x, 0.0};
                if (v1) {
                    Vector3 r1 = MyMath.getHesseEqFromPtAndDir(mip1, dir);
                    res.assign(r1);
                    return r1.getValid();
                }
                if (v2) {
                    Vector3 r2 = MyMath.getHesseEqFromPtAndDir(mip2, dir);
                    res.assign(r2);
                    return r2.getValid();
                }
            }
        }
        return false;
    }

    @Override
    public boolean getMappedConic(double[] cnc, double[] res) {
        return false;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(false);
        GCircle ic = (GCircle)this.parent.get(0);
        if (ic != null && ic.isValid()) {
            this.fData.assign(ic.fData);
            this.setValid(this.fData.getValid() && Math.abs(this.fData.z) > 1.0E-12);
        }
    }
}

