/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GLineObj;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GLine
extends GLineObj {
    protected double x1;
    protected double x2;
    protected double y1;
    protected double y2;
    protected double[] eq;
    protected String fLabel = "";
    CornerStone[] csList = new CornerStone[4];
    private double xmin = -5.0;
    private double ymin = -4.0;
    private double xmax = 5.0;
    private double ymax = 4.0;

    public GLine(GeoObjList list, GeoObj ip1, GeoObj ip2, boolean iIsVisible) {
        super(list);
        this.eq = new double[3];
        this.becomesChildOf(ip1);
        this.becomesChildOf(ip2);
        this.setVisible(iIsVisible);
        this.ccMask = 560;
        this.updateParams(null, 0.0, 0.0);
    }

    public GLine(GeoObjList list) {
        super(list);
        this.eq = new double[3];
        this.ccMask = 560;
    }

    public GLine(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element child;
        this.eq = new double[3];
        this.ccMask = 560;
        if (objElem.getAttributes().getNamedItem("label") != null) {
            this.fLabel = objElem.getAttributes().getNamedItem("label").getNodeValue();
        }
        if ((child = Helpers.getChildElementByName("position", objElem)) != null) {
            this.x1 = Double.parseDouble(child.getAttribute("x1"));
            this.y1 = Double.parseDouble(child.getAttribute("y1"));
            if (child.hasAttribute("x2")) {
                this.x2 = Double.parseDouble(child.getAttribute("x2"));
            }
            if (child.hasAttribute("y2")) {
                this.y2 = Double.parseDouble(child.getAttribute("y2"));
            }
        }
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.updateParams(null, 0.0, 0.0);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = domDoc.createElement("position");
        pos.setAttribute("x1", new Double(this.x1).toString());
        pos.setAttribute("y1", new Double(this.y1).toString());
        pos.setAttribute("x2", new Double(this.x2).toString());
        pos.setAttribute("y2", new Double(this.y2).toString());
        domData.appendChild(pos);
        if (this.fLabel.length() > 0) {
            domData.setAttribute("label", this.fLabel);
        }
        return domData;
    }

    @Override
    public Vector3 getCoordData() {
        return this.getEq();
    }

    @Override
    public boolean includes(GPoint pt) {
        return this.dist(pt.x, pt.y) < 1.0E-6;
    }

    public boolean isOrthogonal(GLine g2) {
        double d = this.eq[0] * g2.eq[0] + this.eq[1] * g2.eq[1];
        return Math.abs(d) < 1.0E-6;
    }

    public boolean isOrthogonal(GPoint p1, GPoint p2) {
        double dd;
        double d;
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return Math.abs(d = this.eq[0] * -(dy /= (dd = Math.hypot(dx, dy))) + this.eq[1] * (dx /= dd)) < 1.0E-6;
    }

    @Override
    public double[] getTangentDirIn(double xp, double yp) {
        double[] res = new double[]{this.eq[0], this.eq[1]};
        return res;
    }

    @Override
    public double[] getNormalDirIn(double xp, double yp) {
        double[] res = new double[]{-this.eq[1], this.eq[0]};
        return res;
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        double[] pts = new double[]{px, py, this.x1, this.y1, this.x2, this.y2};
        double[] fpt = MyMath.getSegmentParamFromPt(this.getEq(), pts);
        return MyMath.gt2ui(fpt[2]) / 2.0 + 0.5;
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        double[] pts = new double[]{this.x1, this.y1, this.x2, this.y2};
        double[] res = MyMath.getSegmentPtFromParam(pts, MyMath.ui2gt(2.0 * param - 1.0));
        return res;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawLongLine(this.eq, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
        }
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        if (canvas != null) {
            double[] range = canvas.getCoordsRange();
            double w = range[2] - range[0];
            double h = range[3] - range[1];
            range[0] = range[0] - w;
            range[1] = range[1] - h;
            range[2] = range[2] + w;
            range[3] = range[3] + h;
            double[] ip = MyMath.intersectLineAndRectangle(this.getEq(), range);
            if (ip[2] + ip[5] > 1.5 && MyMath.hypot(ip[0] - ip[3], ip[1] - ip[4]) > 1.0) {
                double p1 = this.getParamFromCoords(ip[0], ip[1]);
                double p2 = this.getParamFromCoords(ip[3], ip[4]);
                if (p2 > p1) {
                    ptList.reset2zList(40, p1, p2);
                } else {
                    ptList.reset2zList(40, p2, p1);
                }
            } else {
                ptList.reset2zList(20, -5.0, 5.0);
            }
        } else if (ptList.count() > 5) {
            ptList.reset2zList(ptList.count() - 1, ptList.get((int)0).z, ptList.get((int)(ptList.count() - 1)).z);
        } else {
            ptList.reset2zList(50, 0.0, 1.0);
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.setValid(false);
        GPoint p1 = (GPoint)this.parent.get(0);
        GPoint p2 = (GPoint)this.parent.get(1);
        if (p1.isValid() && p2.isValid()) {
            this.x1 = p1.x;
            this.y1 = p1.y;
            this.x2 = p2.x;
            this.y2 = p2.y;
            this.eq[0] = this.y1 - this.y2;
            this.eq[1] = this.x2 - this.x1;
            double c = MyMath.hypot(this.eq[0], this.eq[1]);
            if (Math.abs(c) > 1.0E-12) {
                this.eq[0] = this.eq[0] / c;
                this.eq[1] = this.eq[1] / c;
                this.eq[2] = this.eq[0] * this.x1 + this.eq[1] * this.y1;
                this.setValid(true);
            }
        }
        if (!this.isValid()) {
            System.err.println("(" + this.name + ").updateParams error ==> invalid data!");
        }
    }

    @Override
    public double[] getNameParamsFromCoords(double pox, double poy) {
        double[] pts = new double[]{pox, poy, this.x1, this.y1, this.x2, this.y2};
        double[] fpt = MyMath.getSegmentParamFromPt(this.getEq(), pts);
        double[] res = new double[]{fpt[2], MyMath.oriDistPt2Line(this.eq, pox, poy)};
        return res;
    }

    @Override
    public double[] getNameCoordsFromParams(double[] np) {
        double[] pts = new double[]{this.x1, this.y1, this.x2, this.y2};
        double[] fpt = MyMath.getSegmentPtFromParam(pts, np[0]);
        double[] res = new double[]{fpt[0] + np[1] * this.eq[0], fpt[1] + np[1] * this.eq[1]};
        return res;
    }

    @Override
    public double[] getDefaultNameParams() {
        double[] res = new double[]{0.5, 0.2};
        return res;
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        menu.add2List(new JMenuItem(Messages.getString("GLine.menu_linestyle")), 63);
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            return MyMath.distPt2Line(this.eq, mx, my);
        }
        return 1.0E20;
    }

    @Override
    public boolean containsPoint(double px, double py) {
        return this.dist(px, py) <= 1.0E-6;
    }

    public Vector3 getEq() {
        Vector3 res = new Vector3(this.eq[0], this.eq[1], this.eq[2], 0);
        return res;
    }

    public void setEq(Vector3 veq) {
        if (veq != null) {
            this.eq[0] = veq.x;
            this.eq[1] = veq.y;
            this.eq[2] = veq.z;
        }
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushDouble(this.x1);
        this.stack.pushDouble(this.y1);
        this.stack.pushDouble(this.x2);
        this.stack.pushDouble(this.y2);
        int i = 0;
        while (i <= 2) {
            this.stack.pushDouble(this.eq[i]);
            ++i;
        }
    }

    @Override
    public void restoreState() {
        int i = 2;
        while (i >= 0) {
            this.eq[i] = this.stack.popDouble();
            --i;
        }
        this.y2 = this.stack.popDouble();
        this.x2 = this.stack.popDouble();
        this.y1 = this.stack.popDouble();
        this.x1 = this.stack.popDouble();
        super.restoreState();
    }

    @Override
    public Shape getBorder(CoordsCanvas canvas) {
        Polygon p = this.getBorderPolygon(!this.isReversed(), canvas);
        return p;
    }

    @Override
    protected String defName() {
        return "g";
    }

    private Polygon getBorderPolygon(boolean ori, CoordsCanvas canvas) {
        double[] ccs = canvas.getCoordsRange();
        this.xmin = ccs[0];
        this.ymin = ccs[1];
        this.xmax = ccs[2];
        this.ymax = ccs[3];
        Point2D.Double[] vList = ori ? this.getLeftSideWindowPolygon(this.x1, this.y1, this.x2, this.y2) : this.getLeftSideWindowPolygon(this.x2, this.y2, this.x1, this.y1);
        int n = vList.length;
        if (n > 0) {
            Polygon poly = new Polygon();
            Point2D.Double scrPt = new Point2D.Double(0.0, 0.0);
            int i = 0;
            while (i < n) {
                canvas.getScreenPtCoords(vList[i].x, vList[i].y, scrPt);
                poly.addPoint((int)Math.round(scrPt.x), (int)Math.round(scrPt.y));
                ++i;
            }
            return poly;
        }
        return null;
    }

    private CornerStone cs(int j) {
        return this.csList[j % 4];
    }

    private Point2D.Double[] getLeftSideWindowPolygon(double ax, double ay, double bx, double by) {
        Point2D.Double[] ptList;
        double dx = bx - ax;
        double dy = by - ay;
        double mx = (ax + bx) / 2.0;
        double my = (ay + by) / 2.0;
        double nx = -dy;
        double ny = dx;
        this.csList[0] = new CornerStone(this.xmin, this.ymin);
        this.csList[1] = new CornerStone(this.xmax, this.ymin);
        this.csList[2] = new CornerStone(this.xmax, this.ymax);
        this.csList[3] = new CornerStone(this.xmin, this.ymax);
        int plusCount = 0;
        int i = 0;
        while (i < 4) {
            boolean bl = this.csList[i].isLeft = (this.csList[i].corner.x - mx) * nx + (this.csList[i].corner.y - my) * ny > 0.0;
            if (this.csList[i].isLeft) {
                ++plusCount;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (this.csList[i].isLeft != this.cs((int)(i + 1)).isLeft) {
                Vector3 ip = MyMath.intersectLines(this.cs((int)i).corner.x, this.cs((int)i).corner.y, this.cs((int)(i + 1)).corner.x, this.cs((int)(i + 1)).corner.y, ax, ay, bx, by);
                this.csList[i].section.x = ip.x;
                this.csList[i].section.y = ip.y;
                this.csList[i].isValid = ip.getValid();
            } else {
                this.csList[i].isValid = false;
            }
            ++i;
        }
        if (plusCount > 0) {
            if (plusCount < 4) {
                ptList = new Point2D.Double[plusCount + 2];
                int i2 = 0;
                while (!this.cs((int)i2).isLeft || !this.cs((int)i2).isValid) {
                    ++i2;
                }
                ptList[0] = new Point2D.Double(this.cs((int)i2).section.x, this.cs((int)i2).section.y);
                while (!this.cs((int)(++i2)).isValid) {
                }
                ptList[1] = new Point2D.Double(this.cs((int)i2).section.x, this.cs((int)i2).section.y);
                ++i2;
                int k = 2;
                while (this.cs((int)i2).isLeft) {
                    ptList[k] = new Point2D.Double(this.cs((int)i2).corner.x, this.cs((int)i2).corner.y);
                    ++i2;
                    ++k;
                }
            } else {
                ptList = new Point2D.Double[4];
                int i3 = 0;
                while (i3 < 4) {
                    ptList[i3] = new Point2D.Double(this.csList[i3].corner.x, this.csList[i3].corner.y);
                    ++i3;
                }
            }
        } else {
            ptList = new Point2D.Double[]{};
        }
        return ptList;
    }

    private class CornerStone {
        public Point2D.Double corner;
        public boolean isLeft = false;
        public Point2D.Double section;
        public boolean isValid = false;

        public CornerStone(double ix, double iy) {
            this.corner = new Point2D.Double(ix, iy);
            this.section = new Point2D.Double(0.0, 0.0);
        }
    }
}

