/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import geoobj.GLine;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import terms.TermTree;
import xml.Helpers;

public class GLineWDD
extends GLine {
    protected String angleStr = "";
    protected TermTree angleTree = null;

    public GLineWDD(GeoObjList list, GeoObj ip1, GeoObj ip2, String iAngleStr, boolean iisVisible) {
        super(list, ip1, ip2, false);
        this.angleStr = iAngleStr;
        this.angleTree = new TermTree(this.angleStr, 0.0, this.drawing, TermTree.isRadMode);
        this.angleTree.registerTermParentsIn(this);
        this.updateParams(null, 0.0, 0.0);
        this.setVisible(iisVisible);
    }

    public GLineWDD(GeoObjList list) {
        super(list);
    }

    public GLineWDD(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element termNode = Helpers.getChildElementByName("term", objElem);
        if (termNode != null) {
            this.angleStr = termNode.getTextContent().trim();
        }
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.angleTree = new TermTree(this.angleStr, 0.0, this.drawing, TermTree.isRadMode);
        this.angleTree.registerTermParentsIn(this);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element term = domDoc.createElement("term");
        term.setTextContent(this.angleTree.getTermString());
        domData.appendChild(term);
        return domData;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.angleStr.equals(((GLineWDD)o).angleStr);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.setValid(false);
        GPoint p1 = (GPoint)this.parent.get(0);
        GPoint p2 = (GPoint)this.parent.get(1);
        if (p1 != null && p2 != null && p1.isValid() && p2.isValid() && this.angleTree != null && this.angleTree.isOkay()) {
            this.x1 = p2.x;
            this.y1 = p2.y;
            double angle = this.angleTree.getValue(0.0);
            double[] dArray = new double[]{p1.x - p2.x, p1.y - p2.y};
            double[] od = dArray;
            double[] rd = MyMath.rotateVector2(od, angle);
            double rdlen = MyMath.hypot(rd[0], rd[1]);
            if (Math.abs(rdlen) > 1.0E-12) {
                rd[0] = rd[0] / rdlen;
                rd[1] = rd[1] / rdlen;
                this.x2 = this.x1 + rd[0];
                this.y2 = this.y1 + rd[1];
                this.eq[0] = -rd[1];
                this.eq[1] = rd[0];
                this.eq[2] = this.eq[0] * this.x1 + this.eq[1] * this.y1;
                this.setValid(true);
            }
        }
    }
}

