/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCircle;
import geoobj.GLineObj;
import geoobj.GMapping;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GMappedCircle
extends GCircle {
    private boolean fIsReversed = false;

    public GMappedCircle(GeoObjList list, GLineObj sourceLine, GMapping iMap, boolean isVisible) {
        super(list, sourceLine, iMap, isVisible);
        this.ccMask = 4112;
        this.updateParams(null, 0.0, 0.0);
    }

    public GMappedCircle(GeoObjList list) {
        super(list);
    }

    public GMappedCircle(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    public boolean isDegenerated() {
        return this.fData.tag <= -2;
    }

    @Override
    public boolean isReversed() {
        return this.fIsReversed;
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            if (this.isDegenerated()) {
                double[] g = new double[]{this.fData.x, this.fData.y, this.fData.z};
                return MyMath.distPt2Line(g, mx, my);
            }
            return super.dist(mx, my);
        }
        return 1.0E20;
    }

    @Override
    public Vector3 getCoordData() {
        Vector3 res = this.isDegenerated() ? new Vector3() : new Vector3(this.fData);
        return res;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(false);
        GLineObj source = (GLineObj)this.parent.get(0);
        GMapping map = (GMapping)this.parent.get(1);
        if (source != null && map != null && source.isValid() && map.isValid()) {
            Vector3 oriC = source.getCoordData();
            this.setValid(oriC.getValid() && map.getMappedCircle(oriC, this.fData));
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isDegenerated()) {
            if (this.isVisible()) {
                double[] data = new double[]{this.fData.x, this.fData.y, this.fData.z};
                canvas.drawLongLine(data, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
            }
        } else {
            super.draw(canvas);
        }
    }
}

