/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import geoobj.GMapping;
import geoobj.GPicture;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xml.Helpers;

public class GMappedPicture
extends GPicture {
    public GMappedPicture(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element childElem = Helpers.getChildElementByName("position", objElem);
        if (childElem != null) {
            String s = childElem.getAttribute("leftbottom");
            String[] sd = s.split(";");
            this.x1 = Double.parseDouble(sd[0]);
            this.y1 = Double.parseDouble(sd[1]);
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        NodeList list = domData.getElementsByTagName("position");
        if (list.getLength() > 0) {
            Element position = (Element)list.item(0);
            position.setAttribute("leftbottom", String.valueOf(Double.toString(this.x1)) + ';' + Double.toString(this.y1));
        }
        return domData;
    }

    @Override
    public double dist(double mx, double my) {
        return 1.0E20;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        GPicture source = (GPicture)this.parent.get(0);
        while (source.getClass() == GMappedPicture.class) {
            source = (GPicture)source.parent.get(0);
        }
        GMapping map = (GMapping)this.parent.get(1);
        if (map.isValid() && source.isValid()) {
            double[] pt = new double[]{source.x, source.y};
            double[] bpt = new double[]{0.0, 0.0};
            map.getMappedPoint(pt, bpt);
            this.x = bpt[0];
            this.y = bpt[1];
            pt[0] = source.x1;
            pt[1] = source.y1;
            map.getMappedPoint(pt, bpt);
            this.x1 = bpt[0];
            this.y1 = bpt[1];
            pt[0] = source.x2;
            pt[1] = source.y2;
            map.getMappedPoint(pt, bpt);
            this.x2 = bpt[0];
            this.y2 = bpt[1];
            this.img = source.img;
            this.setValid(true);
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawMappedImage(this.img, this.x, this.y, this.x1, this.y1, this.x2, this.y2);
        }
    }
}

