/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GMapping;
import geoobj.GRegPoly;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GMappedRegPoly
extends GRegPoly {
    public GMappedRegPoly(GeoObjList list, GRegPoly pp, GMapping map) {
        super(list, pp, map, pp.vcount);
    }

    public GMappedRegPoly(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.setValid(true);
        this.fillPointList(null);
        if (this.isValid()) {
            double det = ((GMapping)this.parent.get((int)1)).detM;
            this.circum = this.parent.get(0).getValue(3) * Math.abs(det);
            this.polyArea = this.parent.get(0).getValue(5) * MyMath.sqr(det);
        }
    }

    @Override
    protected void initPointList() {
        int i = 0;
        while (i < this.vcount) {
            this.ptList.insertAt(i, new Vector3(0.0, 0.0, i));
            ++i;
        }
    }

    @Override
    protected void fillPointList(CoordsCanvas canvas) {
        GRegPoly pp = (GRegPoly)this.parent.get(0);
        GMapping map = (GMapping)this.parent.get(1);
        this.setValid(pp != null && pp.isValid() && map != null && map.isValid());
        if (this.isValid()) {
            this.reversed = pp.reversed ^ map.isReversing();
            double[] pt = new double[]{0.0, 0.0};
            double[] bpt = new double[]{0.0, 0.0};
            int i = 0;
            while (i < this.vcount) {
                pt[0] = pp.ptList.get((int)i).x;
                pt[1] = pp.ptList.get((int)i).y;
                if (map.getMappedPoint(pt, bpt)) {
                    this.ptList.get((int)i).x = bpt[0];
                    this.ptList.get((int)i).y = bpt[1];
                } else {
                    this.setValid(false);
                }
                ++i;
            }
        }
    }
}

