/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public abstract class GMapping
extends GeoObj {
    public static final int mapReflectionLine = 1;
    public static final int mapReflectionPoint = 2;
    public static final int mapTranslation = 3;
    public static final int mapRotation = 4;
    public static final int mapCongruency = 5;
    public static final int mapDilation = 7;
    public static final int mapSimilarity = 8;
    public static final int mapSheer = 10;
    public static final int mapOrthAxDilation = 11;
    public static final int mapSheerReflection = 12;
    public static final int mapAxAffinMapping = 13;
    public static final int mapEulerMapping = 14;
    public static final int mapAffRotation = 15;
    public static final int mapAffineMap3PP = 18;
    public static final int mapAffineMapMat = 19;
    public static final int mapInversion = 20;
    protected int mapType = 0;
    protected String a11;
    protected String a21;
    protected String a31;
    protected String a12;
    protected String a22;
    protected String a32;
    protected double[][] mat = new double[3][2];
    protected double detM = 1.0;

    public GMapping(GeoObjList list) {
        super(list);
        this.ccMask = 0x20000000;
    }

    public GMapping(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 0x20000000;
        this.mapType = Integer.parseInt(objElem.getAttribute("map_type"));
        Element childElem = Helpers.getChildElementByName("matrix", objElem);
        if (childElem != null) {
            this.a11 = childElem.getAttribute("a11");
            this.a21 = childElem.getAttribute("a21");
            this.a31 = childElem.getAttribute("a31");
            this.a12 = childElem.getAttribute("a12");
            this.a22 = childElem.getAttribute("a22");
            this.a32 = childElem.getAttribute("a32");
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        domData.setAttribute("map_type", new Integer(this.getMapType()).toString());
        if (this.getMapType() != 20) {
            Element matrix = domDoc.createElement("matrix");
            matrix.setAttribute("a11", new Double(this.mat[0][0]).toString());
            matrix.setAttribute("a12", new Double(this.mat[0][1]).toString());
            matrix.setAttribute("a21", new Double(this.mat[1][0]).toString());
            matrix.setAttribute("a22", new Double(this.mat[1][1]).toString());
            matrix.setAttribute("a31", new Double(this.mat[2][0]).toString());
            matrix.setAttribute("a32", new Double(this.mat[2][1]).toString());
            domData.appendChild(matrix);
        }
        return domData;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.mapType == ((GMapping)o).mapType && this.hasSameParentsAs(o, true);
    }

    @Override
    public double dist(double mx, double my) {
        return 1.0E20;
    }

    public int getMapType() {
        return this.mapType;
    }

    public boolean isReversing() {
        return this.mapType == 20 || this.detM < 0.0;
    }

    public boolean getMappedVector(Vector3 v, Vector3 mv) {
        if (this.isValid()) {
            mv.x = this.mat[0][0] * v.x + this.mat[1][0] * v.y;
            mv.y = this.mat[0][1] * v.x + this.mat[1][1] * v.y;
            mv.z = 0.0;
            return true;
        }
        return false;
    }

    public boolean getMappedPoint(double[] pt, double[] bpt) {
        if (this.isValid()) {
            bpt[0] = this.mat[0][0] * pt[0] + this.mat[1][0] * pt[1] + this.mat[2][0];
            bpt[1] = this.mat[0][1] * pt[0] + this.mat[1][1] * pt[1] + this.mat[2][1];
            return true;
        }
        return false;
    }

    public boolean getInvMapPoint(double[] pt, double[] bpt) {
        if (this.mapType == 1 || this.mapType == 2 || this.mapType == 20) {
            return this.getMappedPoint(pt, bpt);
        }
        if (this.isValid() && Math.abs(this.detM) > 1.0E-12) {
            double[][] invmat = this.getInvMap();
            bpt[0] = invmat[0][0] * pt[0] + invmat[1][0] * pt[1] + invmat[2][0];
            bpt[1] = invmat[0][1] * pt[0] + invmat[1][1] * pt[1] + invmat[2][1];
            return true;
        }
        return false;
    }

    public boolean getMappedLine(Vector3 lineEq, Vector3 res) {
        Vector3 meq;
        Vector3 mdir;
        Vector3 dir;
        boolean result = false;
        double[] pt = new double[]{0.0, 0.0};
        Vector3 foot = MyMath.getPedalPoint(lineEq, pt);
        double[] ori = new double[]{foot.x, foot.y};
        double[] mpt = new double[2];
        if (this.getMappedPoint(ori, mpt) && this.getMappedVector(dir = MyMath.getDirectionFromHesseEq(lineEq), mdir = new Vector3()) && (meq = MyMath.getHesseEqFromPtAndDir(mpt, mdir)).getValid()) {
            res.assign(meq);
            result = true;
        }
        return result;
    }

    public boolean getMappedCircle(Vector3 circ, Vector3 res) {
        if (this.mapType <= 8) {
            double[] p = new double[]{circ.x, circ.y};
            double[] q = new double[2];
            if (this.getMappedPoint(p, q)) {
                res.x = q[0];
                res.y = q[1];
                res.z = this.mapType == 7 ? circ.z * Math.abs(this.mat[0][0]) : circ.z;
                res.tag = circ.tag;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean getMappedConic(double[] cnc, double[] res) {
        if (this.isValid() && Math.abs(this.detM) > 1.0E-12) {
            double[][] invmat = this.getInvMap();
            res[0] = cnc[0] * MyMath.sqr(invmat[0][0]) + 2.0 * cnc[1] * invmat[0][0] * invmat[0][1] + cnc[2] * MyMath.sqr(invmat[0][1]);
            res[1] = cnc[0] * invmat[0][0] * invmat[1][0] + cnc[1] * (invmat[0][0] * invmat[1][1] + invmat[1][0] * invmat[0][1]) + cnc[2] * invmat[0][1] * invmat[1][1];
            res[2] = cnc[0] * MyMath.sqr(invmat[1][0]) + 2.0 * cnc[1] * invmat[1][0] * invmat[1][1] + cnc[2] * MyMath.sqr(invmat[1][1]);
            double m = cnc[0] * invmat[2][0] + cnc[1] * invmat[2][1] + cnc[3];
            double n = cnc[1] * invmat[2][0] + cnc[2] * invmat[2][1] + cnc[4];
            res[3] = m * invmat[0][0] + n * invmat[0][1];
            res[4] = m * invmat[1][0] + n * invmat[1][1];
            res[5] = cnc[0] * MyMath.sqr(invmat[2][0]) + 2.0 * cnc[1] * invmat[2][0] * invmat[2][1] + cnc[2] * MyMath.sqr(invmat[2][1]) + 2.0 * (cnc[3] * invmat[2][0] + cnc[4] * invmat[2][1]) + cnc[5];
            return true;
        }
        return false;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
    }

    @Override
    protected String defName() {
        return "Map";
    }

    protected double[][] getInvMap() {
        double[][] res = new double[3][2];
        res[0][0] = this.mat[1][1] / this.detM;
        res[1][0] = -this.mat[1][0] / this.detM;
        res[0][1] = -this.mat[0][1] / this.detM;
        res[1][1] = this.mat[0][0] / this.detM;
        res[2][0] = -res[0][0] * this.mat[2][0] - res[1][0] * this.mat[2][1];
        res[2][1] = -res[0][1] * this.mat[2][0] - res[1][1] * this.mat[2][1];
        return res;
    }
}

