/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.Options;
import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GAngle;
import geoobj.GMeasureDistance;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.RelationList;
import java.awt.geom.Point2D;
import org.w3c.dom.Element;

public class GMeasureAngle
extends GMeasureDistance {
    private double angleVal = 0.0;

    public GMeasureAngle(GeoObjList list, GeoObj iAngle, boolean iisVisible) {
        super(list, iAngle, null, iisVisible);
    }

    public GMeasureAngle(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.dx = this.x1 - this.x;
        this.dy = this.y1 - this.y;
    }

    @Override
    public double getValue(int select) {
        return this.angleVal;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawSegment(this.x1, this.y1, this.xn, this.yn, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.getColor());
            Point2D.Float bounds = new Point2D.Float();
            canvas.drawText(this.htmlText, this.x, this.y, true, this.getColor(), bounds);
            this.width = Math.abs(((Point2D)bounds).getX());
            this.height = Math.abs(((Point2D)bounds).getY());
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        GAngle pAngle = (GAngle)this.parent.get(0);
        if (pAngle.isValid()) {
            this.x1 = pAngle.getValue(1);
            this.y1 = pAngle.getValue(2);
            this.x = this.x1 + this.dx;
            this.y = this.y1 + this.dy;
            this.angleVal = pAngle.getValue(9);
            Object[] v = new Object[]{MyMath.rad2deg(this.angleVal), Options.angleUnit};
            String fs = "%." + Integer.toString(Options.angleDecimals) + "f%s";
            this.htmlText = String.format(fs, v);
            this.calculateLine();
            this.setValid(true);
        } else {
            this.setValid(false);
        }
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        this.dx += dx;
        this.dy += dy;
        this.x += dx;
        this.y += dy;
        this.calculateLine();
    }

    @Override
    public void saveState() {
        super.saveState();
        if (this.getClass() == GMeasureAngle.class) {
            this.stack.pushString(this.htmlText);
            this.stack.pushDouble(this.angleVal);
            this.stack.pushDouble(this.xm);
            this.stack.pushDouble(this.ym);
            this.stack.pushDouble(this.xn);
            this.stack.pushDouble(this.yn);
        }
    }

    @Override
    public void restoreState() {
        if (this.getClass() == GMeasureAngle.class) {
            this.yn = this.stack.popDouble();
            this.xn = this.stack.popDouble();
            this.ym = this.stack.popDouble();
            this.xm = this.stack.popDouble();
            this.angleVal = this.stack.popDouble();
            this.htmlText = this.stack.popString();
        }
        super.restoreState();
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder("w(");
        RelationList p = null;
        p = this.parent.size() >= 3 ? this.parent : this.parent.get((int)0).parent;
        sb.append(p.get((int)0).name);
        sb.append(";");
        sb.append(p.get((int)1).name);
        sb.append(";");
        sb.append(p.get((int)2).name);
        sb.append(")");
        this.name = new String(sb.toString());
        return this.name;
    }

    private void calculateLine() {
        this.xn = this.x1;
        this.yn = this.y1;
        if (this.width > 0.0 && this.height > 0.0) {
            double ds = 2.0 / Options.ppcm;
            double w2 = this.width / 2.0 + ds;
            double h2 = this.height / 2.0 + ds;
            double[] rect = new double[]{this.x - w2, this.y - h2, this.x + w2, this.y + h2};
            Vector3 dir = new Vector3(this.x - this.x1, this.y - this.y1, 0.0);
            double[] dArray = new double[]{this.x1, this.y1, 0.0};
            double[] pt = dArray;
            Vector3 line = MyMath.getHesseEqFromPtAndDir(pt, dir);
            double[] pts = MyMath.intersectLineAndRectangle(line, rect);
            if (pts[2] > 0.5 && pts[5] > 0.5) {
                double d2;
                double d1 = Math.hypot(pts[0] - this.x1, pts[1] - this.y1);
                if (d1 <= (d2 = Math.hypot(pts[3] - this.x1, pts[4] - this.y1))) {
                    this.xn = pts[0];
                    this.yn = pts[1];
                } else {
                    this.xn = pts[3];
                    this.yn = pts[4];
                }
            }
        }
    }
}

