/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.Options;
import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCircle;
import geoobj.GLine;
import geoobj.GPoint;
import geoobj.GTextObj;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GMeasureDistance
extends GTextObj {
    protected double x1 = 0.0;
    protected double y1 = 0.0;
    protected double x2 = 0.0;
    protected double y2 = 0.0;
    protected double xm;
    protected double ym;
    protected double xn;
    protected double yn;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected double distVal = 0.0;

    public GMeasureDistance(GeoObjList list, GeoObj iP1, GeoObj iP2, boolean iisVisible) {
        super(list);
        this.becomesChildOf(iP1);
        this.becomesChildOf(iP2);
        this.appearance.setPenStyle(2);
        this.setVisible(iisVisible);
        this.updateParams(null, 0.0, 0.0);
    }

    public GMeasureDistance(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element childElem = Helpers.getChildElementByName("line", objElem);
        if (childElem != null) {
            this.x1 = Double.parseDouble(childElem.getAttribute("x1"));
            this.y1 = Double.parseDouble(childElem.getAttribute("y1"));
            this.x2 = Double.parseDouble(childElem.getAttribute("x2"));
            this.y2 = Double.parseDouble(childElem.getAttribute("y2"));
            this.dx = Double.parseDouble(childElem.getAttribute("dx"));
            this.dy = Double.parseDouble(childElem.getAttribute("dy"));
        }
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.dx = canvas.screenToUserW((int)this.dx);
        this.dy = canvas.screenToUserH((int)this.dy);
        this.calculateSecondLine();
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element nLine = domDoc.createElement("line");
        nLine.setAttribute("x1", new Double(this.x1).toString());
        nLine.setAttribute("y1", new Double(this.y1).toString());
        nLine.setAttribute("x2", new Double(this.x2).toString());
        nLine.setAttribute("y2", new Double(this.y2).toString());
        int idx = new Double(this.dx * Options.ppcm).intValue();
        int idy = new Double(-this.dy * Options.ppcm).intValue();
        nLine.setAttribute("dx", new Integer(idx).toString());
        nLine.setAttribute("dy", new Integer(idy).toString());
        domData.appendChild(nLine);
        return domData;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return super.hasSameDataAs(o) && this.parent.hasSameDataAs(o.parent, false);
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            Rectangle2D.Double r = new Rectangle2D.Double(this.x - this.width / 2.0, this.y - this.height / 2.0, this.width, this.height);
            if (r.contains(mx, my)) {
                return 0.0;
            }
            return MyMath.hypot(this.x - mx, this.y - my);
        }
        return 1.0E20;
    }

    @Override
    public double getValue(int select) {
        return this.distVal;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawSegment(this.x1, this.y1, this.x2, this.y2, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.getColor());
            Point2D.Float bounds = new Point2D.Float();
            canvas.drawText(this.htmlText, this.x, this.y, true, this.getColor(), bounds);
            this.width = Math.abs(((Point2D)bounds).getX());
            this.height = Math.abs(((Point2D)bounds).getY());
            canvas.drawSegment(this.xm, this.ym, this.xn, this.yn, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.getColor());
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(true);
        GeoObj p0 = this.parent.get(0);
        GeoObj p1 = this.parent.get(1);
        if (p0 instanceof GPoint) {
            this.x1 = ((GPoint)p0).x;
            this.y1 = ((GPoint)p0).y;
            if (p1 instanceof GPoint) {
                this.x2 = ((GPoint)p1).x;
                this.y2 = ((GPoint)p1).y;
                this.distVal = MyMath.hypot(this.x2 - this.x1, this.y2 - this.y1);
                this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                this.y = (this.y1 + this.y2) / 2.0 + this.dy;
            } else if (p1 instanceof GLine) {
                double[] pt = new double[]{this.x1, this.y1};
                Vector3 vpt = MyMath.getPedalPoint(((GLine)p1).getEq(), pt);
                this.x2 = vpt.x;
                this.y2 = vpt.y;
                this.distVal = MyMath.hypot(this.x2 - this.x1, this.y2 - this.y1);
                this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                this.y = (this.y1 + this.y2) / 2.0 + this.dy;
            } else if (p1 instanceof GCircle) {
                Vector3 c = ((GCircle)p1).getCoordData();
                double[] pt = new double[]{c.x, c.y};
                double[] dArray = new double[]{pt[0] - this.x1, pt[1] - this.y1};
                double[] dir = dArray;
                Vector3 hl = MyMath.getHesseEqFromPtAndDir(pt, dir);
                double[] pts = MyMath.intersectLineAndCircle(hl, c);
                if (pts[2] > 0.5 && pts[5] > 0.5) {
                    double d2;
                    double d1 = MyMath.hypot(pts[0] - this.x1, pts[1] - this.y1);
                    if (d1 < (d2 = MyMath.hypot(pts[3] - this.x1, pts[4] - this.y1))) {
                        this.x2 = pts[0];
                        this.y2 = pts[1];
                        this.distVal = d1;
                    } else {
                        this.x2 = pts[3];
                        this.y2 = pts[4];
                        this.distVal = d2;
                    }
                    this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                    this.y = (this.y1 + this.y2) / 2.0 + this.dy;
                } else {
                    this.setValid(false);
                }
            } else {
                this.setValid(false);
            }
            this.setValid(p0.isValid() && p1.isValid());
        } else if (p0 instanceof GLine) {
            if (p1 instanceof GLine) {
                Vector3 le0 = ((GLine)p0).getEq();
                Vector3 le1 = ((GLine)p1).getEq();
                Vector3 pts = MyMath.intersectLines(le0, le1);
                if (pts.z < 0.5) {
                    double[] ori = new double[]{0.0, 0.0};
                    Vector3 fp1 = MyMath.getPedalPoint(le0, ori);
                    Vector3 fp2 = MyMath.getPedalPoint(le1, ori);
                    this.x1 = fp1.x;
                    this.y1 = fp1.y;
                    this.x2 = fp2.x;
                    this.y2 = fp2.y;
                    this.distVal = MyMath.hypot(this.x2 - this.x1, this.y2 - this.y1);
                    this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                    this.y = (this.y1 + this.y2) / 2.0 + this.dy;
                } else {
                    this.setValid(false);
                }
            } else if (p1 instanceof GCircle) {
                Vector3 c;
                Vector3 g = ((GLine)p0).getEq();
                double[] pts = MyMath.intersectLineAndCircle(g, c = ((GCircle)p1).getCoordData());
                if (pts[2] < 0.5 && pts[5] < 0.5) {
                    Vector3 pp = MyMath.getPedalPoint(g, c);
                    double[] dir = new double[]{pp.x - c.x, pp.y - c.y};
                    double ld = MyMath.hypot(dir[0], dir[1]);
                    this.x1 = pp.x;
                    this.y1 = pp.y;
                    this.x2 = c.x + dir[0] / ld * c.z;
                    this.y2 = c.y + dir[1] / ld * c.z;
                    this.distVal = MyMath.hypot(this.x2 - this.x1, this.y2 - this.y1);
                    this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                    this.y = (this.y1 + this.y2) / 2.0 + this.dy;
                } else {
                    this.setValid(false);
                }
            } else {
                this.setValid(false);
            }
        } else if (p0 instanceof GCircle && p1 instanceof GCircle) {
            Vector3 c1 = ((GCircle)p0).getCoordData();
            Vector3 c2 = ((GCircle)p1).getCoordData();
            double[] dArray = new double[]{c2.x - c1.x, c2.y - c1.y};
            double[] dir = dArray;
            double dm1m2 = MyMath.hypot(dir[0], dir[1]);
            if (dm1m2 > c1.z + c2.z) {
                double sf = c1.z / dm1m2;
                this.x1 = c1.x + dir[0] * sf;
                this.y1 = c1.y + dir[1] * sf;
                sf = c2.z / dm1m2;
                this.x2 = c2.x - dir[0] * sf;
                this.y2 = c2.y - dir[1] * sf;
                this.distVal = dm1m2 - c1.z - c2.z;
                this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                this.y = (this.y1 + this.y2) / 2.0 + this.dy;
            } else if (dm1m2 < Math.abs(c2.z - c1.z)) {
                if (dm1m2 > 1.0E-6) {
                    double sf1 = c1.z / dm1m2;
                    double sf2 = c2.z / dm1m2;
                    if (c2.z > c1.z) {
                        this.x1 = c1.x - dir[0] * sf1;
                        this.y1 = c1.y - dir[1] * sf1;
                        this.x2 = c2.x - dir[0] * sf2;
                        this.y2 = c2.y - dir[1] * sf2;
                    } else {
                        this.x1 = c1.x + dir[0] * sf1;
                        this.y1 = c1.y + dir[1] * sf1;
                        this.x2 = c2.x + dir[0] * sf2;
                        this.y2 = c2.y + dir[1] * sf2;
                    }
                    this.distVal = Math.abs(c1.z - c2.z) - dm1m2;
                    this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                    this.y = (this.y1 + this.y2) / 2.0 + this.dy;
                } else {
                    this.x1 = c1.x + c1.z;
                    this.y1 = c1.y;
                    this.x2 = c2.x + c2.z;
                    this.y2 = c2.y;
                    this.distVal = Math.abs(c1.z - c2.z);
                    this.x = (this.x1 + this.x2) / 2.0 + this.dx;
                    this.y = (this.y1 + this.y2) / 2.0 + this.dy;
                }
            } else {
                this.setValid(false);
            }
        } else {
            this.setValid(false);
        }
        if (this.isValid()) {
            this.setValid(p0.isValid() && p1.isValid());
        }
        if (this.isValid()) {
            this.calculateSecondLine();
        }
        Object[] objs = new Object[]{this.distVal, Options.lengthUnit};
        String fs = "%." + Integer.toString(Options.lengthDecimals) + "f%s";
        this.htmlText = String.format(fs, objs);
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        this.dx += dx;
        this.dy += dy;
        this.x += dx;
        this.y += dy;
        this.calculateSecondLine();
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushDouble(this.dx);
        this.stack.pushDouble(this.dy);
        this.stack.pushDouble(this.x1);
        this.stack.pushDouble(this.y1);
        this.stack.pushDouble(this.x2);
        this.stack.pushDouble(this.y2);
        if (this.getClass() == GMeasureDistance.class) {
            this.stack.pushDouble(this.distVal);
        }
    }

    @Override
    public void restoreState() {
        if (this.getClass() == GMeasureDistance.class) {
            this.distVal = this.stack.popDouble();
        }
        this.y2 = this.stack.popDouble();
        this.x2 = this.stack.popDouble();
        this.y1 = this.stack.popDouble();
        this.x1 = this.stack.popDouble();
        this.dy = this.stack.popDouble();
        this.dx = this.stack.popDouble();
        super.restoreState();
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder("d(");
        sb.append(this.parent.get((int)0).name);
        sb.append(";");
        sb.append(this.parent.get((int)1).name);
        sb.append(")");
        this.name = new String(sb.toString());
        return this.name;
    }

    @Override
    protected String defName() {
        return "MO";
    }

    protected void calculateSecondLine() {
        this.xm = (this.x1 + this.x2) / 2.0;
        this.ym = (this.y1 + this.y2) / 2.0;
        this.xn = this.xm;
        this.yn = this.ym;
        if (this.width > 0.0 && this.height > 0.0) {
            double ds = 2.0 / Options.ppcm;
            double w2 = this.width / 2.0 + ds;
            double h2 = this.height / 2.0 + ds;
            double[] rect = new double[]{this.x - w2, this.y - h2, this.x + w2, this.y + h2};
            Vector3 dir = new Vector3(this.x2 - this.x1, this.y2 - this.y1, 0.0);
            double[] dArray = new double[]{this.xm, this.ym, 0.0};
            double[] pt = dArray;
            Vector3 line = MyMath.getHesseEqFromPtAndDir(pt, dir);
            double[] pts = MyMath.intersectLineAndRectangle(line, rect);
            if (pts[2] < 0.5 && pts[5] < 0.5 || Math.hypot(this.x - this.xm, this.y - this.ym) > Math.hypot(this.x1 - this.xm, this.y1 - this.ym)) {
                dir.x = this.x - this.xm;
                dir.y = this.y - this.ym;
                line = MyMath.getHesseEqFromPtAndDir(pt, dir);
                pts = MyMath.intersectLineAndRectangle(line, rect);
                if (pts[2] > 0.5 && pts[5] > 0.5) {
                    double d2;
                    double d1 = Math.hypot(pts[0] - this.xm, pts[1] - this.ym);
                    if (d1 <= (d2 = Math.hypot(pts[3] - this.xm, pts[4] - this.ym))) {
                        this.xn = pts[0];
                        this.yn = pts[1];
                    } else {
                        this.xn = pts[3];
                        this.yn = pts[4];
                    }
                }
            }
        }
    }
}

