/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.LocLineController;
import geoobj.Messages;
import java.awt.Color;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GNumber
extends GeoObj
implements LocLineController {
    public static final int defNumSliderWidth = 250;
    public static final int defNumSliderHeight = 33;
    public static final int defNumCounterWidth = 80;
    public static final int defNumCounterHeight = 18;
    protected boolean showsName = false;
    protected double x2 = 0.0;
    protected double y2 = 0.0;
    protected double actVal = 1.0;
    private double xp = 0.0;
    private double yp = 0.0;
    private double xpmin = 0.0;
    private double xpmax = 0.0;
    private double minVal = -3.0;
    private double maxVal = 5.0;
    private double quant = 0.0;
    private double ani_step = 0.0;
    private double lastDist = 0.0;

    public GNumber(GeoObjList list, double[] iVal, double[] iPos, boolean iisVisible) {
        super(list);
        this.ccMask = 0x10100001;
        if (iVal != null) {
            this.minVal = iVal[0];
            this.actVal = iVal[1];
            this.maxVal = iVal[2];
        }
        this.appearance.setColor(Color.gray);
        this.appearance.setShape(1);
        this.x = iPos[0];
        this.y = iPos[1];
        this.x2 = iPos[2];
        this.y2 = iPos[3];
        this.updateParams(null, 0.0, 0.0);
    }

    public GNumber(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element childElem;
        Element appearElem;
        this.ccMask = 0x10100001;
        if (objElem.getAttribute("show_name").length() > 0) {
            Boolean sn = Boolean.parseBoolean(objElem.getAttribute("show_name"));
            this.showsName = sn;
        }
        if ((appearElem = Helpers.getChildElementByName("attributes", objElem)) != null) {
            int sh = Integer.parseInt(appearElem.getAttribute("shape"));
            if (sh == 2) {
                this.appearance.setShape(2);
            } else {
                this.appearance.setShape(1);
            }
        }
        if ((childElem = Helpers.getChildElementByName("position", objElem)) != null) {
            this.x = Double.parseDouble(childElem.getAttribute("x"));
            this.y = Double.parseDouble(childElem.getAttribute("y"));
        }
        if ((childElem = Helpers.getChildElementByName("value", objElem)) != null && this.getClass() == GNumber.class) {
            this.actVal = Double.parseDouble(childElem.getAttribute("actual"));
            this.minVal = Double.parseDouble(childElem.getAttribute("min"));
            this.maxVal = Double.parseDouble(childElem.getAttribute("max"));
            String quantAttr = childElem.getAttribute("quant");
            this.quant = quantAttr.length() > 0 ? Double.parseDouble(quantAttr) : 0.0;
            String aniStepAttr = childElem.getAttribute("ani_step");
            if (aniStepAttr.length() > 0) {
                this.ani_step = Double.parseDouble(aniStepAttr);
            }
        }
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        Point2D.Double scr = new Point2D.Double();
        canvas.getScreenPtCoords(this.x, this.y, scr);
        scr.setLocation(scr.getX() + (double)this.getWidth(), scr.getY() + (double)this.getHeight());
        Point2D.Double usr = new Point2D.Double();
        canvas.getUserPtCoords(scr.x, scr.y, usr);
        this.x2 = usr.getX();
        this.y2 = usr.getY();
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = domDoc.createElement("position");
        pos.setAttribute("x", new Double(this.x).toString());
        pos.setAttribute("y", new Double(this.y).toString());
        pos.setAttribute("width", new Integer(this.getWidth()).toString());
        pos.setAttribute("height", new Integer(this.getHeight()).toString());
        domData.appendChild(pos);
        if (this.getClass() == GNumber.class) {
            if (this.showsName) {
                domData.setAttribute("show_name", "true");
            }
            Element val = domDoc.createElement("value");
            val.setAttribute("actual", new Double(this.actVal).toString());
            val.setAttribute("min", new Double(this.minVal).toString());
            val.setAttribute("max", new Double(this.maxVal).toString());
            if (Math.abs(this.quant) > 1.0E-12) {
                val.setAttribute("quant", new Double(this.quant).toString());
            }
            if (Math.abs(this.ani_step) > 1.0E-12) {
                val.setAttribute("ani_step", new Double(this.ani_step).toString());
            }
            domData.appendChild(val);
        }
        return domData;
    }

    @Override
    public int setName(String nn) {
        this.name = nn;
        return 0;
    }

    public boolean getShowsName() {
        return this.showsName;
    }

    public void setShowsName(boolean nv) {
        this.showsName = nv;
    }

    @Override
    public boolean hasNameObj() {
        return true;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        return false;
    }

    public int getWidth() {
        if (this.appearance.getShape() != 2) {
            return 250;
        }
        return 80;
    }

    public int getHeight() {
        if (this.appearance.getShape() != 2) {
            return 33;
        }
        return 18;
    }

    @Override
    public double getValue(int selector) {
        switch (selector) {
            case 6: {
                return this.minVal;
            }
            case 7: {
                return this.maxVal;
            }
            case 8: {
                return this.quant;
            }
        }
        return this.actVal;
    }

    public void setAllValues(double iMin, double iVal, double iMax, double iQuant) {
        this.minVal = iMin;
        this.actVal = iVal;
        this.maxVal = iMax;
        this.quant = iQuant;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushDouble(this.actVal);
    }

    @Override
    public void restoreState() {
        this.actVal = this.stack.popDouble();
        super.restoreState();
    }

    @Override
    public double dist(double mx, double my) {
        this.lastDist = this.isValid() && MyMath.ptInRect(mx, my, this.x, this.y, this.x2, this.y2) ? (this.appearance.getShape() != 2 ? (my > (this.y + this.y2) / 2.0 ? -1000.0 : MyMath.hypot(mx - this.xp, my - this.yp)) : (mx > this.x + (this.y - this.y2) * 0.9 ? -1000.0 : (my > (this.y + this.y2) / 2.0 ? -1.0E-10 : -2.0E-10))) : 1.0E20;
        return this.lastDist;
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        if (this.getClass() == GNumber.class) {
            menu.add2List(new JMenuItem(Messages.getString("GNumber.menu_editrange")), 73);
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            double[] pos = new double[]{this.x, this.y, this.x2, this.y2};
            if (this.appearance.getShape() != 2) {
                double[] val = new double[]{this.minVal, this.actVal, this.maxVal};
                canvas.drawNumberBox(pos, val, this.name, this.appearance.getColor());
                this.xp = pos[0];
                this.yp = pos[1];
                this.xpmin = pos[2];
                this.xpmax = pos[3];
            } else {
                canvas.drawCounterBox(pos, this.actVal, this.name, this.appearance.getColor());
            }
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        if (this == mousedObj) {
            if (lmx < this.xpmin) {
                lmx = this.xpmin;
            }
            if (lmx > this.xpmax) {
                lmx = this.xpmax;
            }
            this.actVal = this.minVal + (lmx - this.xpmin) / (this.xpmax - this.xpmin) * (this.maxVal - this.minVal);
            if (this.quant > 0.0) {
                this.actVal = Math.rint(this.actVal / this.quant) * this.quant;
            }
        }
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        this.x += dx;
        this.y += dy;
        this.resize(canvas);
    }

    @Override
    public void resize(CoordsCanvas canvas) {
        Point2D.Double pt = new Point2D.Double();
        canvas.getScreenPtCoords(this.x, this.y, pt);
        canvas.getUserPtCoords(pt.x + (double)this.getWidth(), pt.y + (double)this.getHeight(), pt);
        this.x2 = pt.x;
        this.y2 = pt.y;
    }

    public double getLastDist() {
        return this.lastDist;
    }

    public void incrementVal() {
        double nv;
        double step = 1.0;
        if (this.quant > 1.0E-12) {
            step = this.quant;
        }
        this.actVal = (nv = this.actVal + step) <= this.maxVal ? nv : this.maxVal;
    }

    public void decrementVal() {
        double nv;
        double step = 1.0;
        if (this.quant > 1.0E-12) {
            step = this.quant;
        }
        this.actVal = (nv = this.actVal - step) >= this.minVal ? nv : this.minVal;
    }

    @Override
    public boolean setLinePosition(double p) {
        if (p >= 0.0 && p <= 1.0) {
            this.actVal = this.minVal + p * (this.maxVal - this.minVal);
            return true;
        }
        this.actVal = p > 1.0 ? this.maxVal : this.minVal;
        return false;
    }

    @Override
    public double getLinePosition() {
        return (this.actVal - this.minVal) / (this.maxVal - this.minVal);
    }

    @Override
    public void startAnimation() {
        if (this.ani_step > 0.0) {
            if (Math.abs(this.maxVal - this.actVal) < 1.0E-6) {
                this.setLinePosition(this.minVal);
            }
        } else if (Math.abs(this.actVal - this.minVal) < 1.0E-6) {
            this.setLinePosition(this.maxVal);
        }
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        ptList.clear();
        double p = 0.0;
        double dp = 0.023255813953488372;
        int i = 0;
        while (i <= 43) {
            if (ptList.get(i) == null) {
                ptList.insertAt(i, new Vector3(0.0, 0.0, p));
            }
            p += dp;
            ++i;
        }
        ptList.get((int)43).z = 1.0;
    }

    @Override
    protected String defName() {
        return "Z";
    }
}

