/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GOrigin
extends GPoint {
    private int cosysType = -1;
    private int gridMarks = 0;
    private boolean showNumbers = true;

    public GOrigin(GeoObjList list, int iCosysType) {
        super(list, 0.0, 0.0, iCosysType >= 0);
        this.name = "O";
        this.appearance.setColor(Color.lightGray);
        this.appearance.setShape(2);
        this.cosysType = iCosysType;
        ++this.ccMask;
    }

    public GOrigin(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.cosysType = Integer.parseInt(objElem.getAttributes().getNamedItem("cosys_type").getNodeValue());
        Node sn_attr = objElem.getAttributes().getNamedItem("show_numbers");
        this.showNumbers = sn_attr != null ? sn_attr.getNodeValue().equalsIgnoreCase("true") : true;
        this.gridMarks = objElem.getAttributes().getNamedItem("grid_marks") != null ? Integer.parseInt(objElem.getAttributes().getNamedItem("grid_marks").getNodeValue()) : 0;
        ++this.ccMask;
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        domData.setAttribute("cosys_type", new Integer(this.cosysType).toString());
        if (this.gridMarks != 0) {
            domData.setAttribute("grid_marks", new Integer(this.gridMarks).toString());
        }
        if (!this.showNumbers) {
            domData.setAttribute("show_numbers", "false");
        }
        return domData;
    }

    @Override
    public void resize(CoordsCanvas canvas) {
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawOrigin(this.appearance.getShape(), 3, this.cosysType, this.gridMarks, this.showNumbers, this.appearance.getColor());
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.x = 0.0;
        this.y = 0.0;
    }
}

