/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GConic;
import geoobj.GLine;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GParabelF
extends GConic {
    public GParabelF(GeoObjList list) {
        super(list);
    }

    public GParabelF(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    public GParabelF(GeoObjList list, GeoObj[] ipts, boolean isVisible) {
        super(list, ipts, isVisible);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        if (this.ptList != null) {
            this.setValid(false);
            GPoint F = (GPoint)this.parent.get(0);
            GLine L = (GLine)this.parent.get(1);
            if (F.isValid() && L.isValid()) {
                Vector3 lv = L.getEq();
                this.eq[0] = 1.0 - MyMath.sqr(lv.x);
                this.eq[1] = -lv.x * lv.y;
                this.eq[2] = 1.0 - MyMath.sqr(lv.y);
                this.eq[3] = -F.getx(0) + lv.x * lv.z;
                this.eq[4] = -F.gety(0) + lv.y * lv.z;
                this.eq[5] = MyMath.sqr(F.getx(0)) + MyMath.sqr(F.gety(0)) - MyMath.sqr(lv.z);
                double norm = MyMath.getNormingValue(this.eq[0], this.eq[1], this.eq[2], 0.001);
                if (this.eq[0] < 0.0) {
                    norm = -norm;
                }
                if (Math.abs(norm) > 1.0E-12) {
                    int i = 0;
                    while (i <= 5) {
                        this.eq[i] = this.eq[i] / norm;
                        ++i;
                    }
                }
                this.params = MyMath.getConicParamsFromCoeff(this.eq, this.get_alpha());
                this.rotmat = MyMath.initRotMat(-this.get_alpha());
                this.setValid(this.isParabel());
                this.curve = null;
            }
        }
    }
}

