/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import geoobj.GLine;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GPerpBisector
extends GLine {
    public GPerpBisector(GeoObjList list, GeoObj ip1, GeoObj ip2, boolean iIsVisible) {
        super(list, ip1, ip2, iIsVisible);
    }

    public GPerpBisector(GeoObjList list) {
        super(list);
    }

    public GPerpBisector(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.setValid(false);
        GPoint p1 = (GPoint)this.parent.get(0);
        GPoint p2 = (GPoint)this.parent.get(1);
        if (p1.isValid() && p2.isValid()) {
            this.x1 = (p1.x + p2.x) * 0.5;
            this.y1 = (p1.y + p2.y) * 0.5;
            this.eq[0] = p2.x - p1.x;
            this.eq[1] = p2.y - p1.y;
            double c = MyMath.hypot(this.eq[0], this.eq[1]);
            if (Math.abs(c) > 1.0E-12) {
                this.eq[0] = this.eq[0] / c;
                this.eq[1] = this.eq[1] / c;
                this.eq[2] = this.eq[0] * this.x1 + this.eq[1] * this.y1;
                this.x2 = this.x1 + this.eq[1];
                this.y2 = this.y1 - this.eq[0];
                this.setValid(true);
            }
        }
    }
}

