/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GPicture
extends GeoObj {
    protected double x1 = 0.0;
    protected double y1 = 0.0;
    protected double x2 = 0.0;
    protected double y2 = 0.0;
    protected String imgDataStr = null;
    protected BufferedImage img = null;

    public GPicture(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 0x200000;
        Element childElem = Helpers.getChildElementByName("position", objElem);
        if (childElem != null) {
            String s = childElem.getAttribute("lefttop");
            String[] sd = s.split(";");
            this.x = Double.parseDouble(sd[0]);
            this.y = Double.parseDouble(sd[1]);
            s = childElem.getAttribute("rightbottom");
            sd = s.split(";");
            this.x2 = Double.parseDouble(sd[0]);
            this.y2 = Double.parseDouble(sd[1]);
        }
        if ((childElem = Helpers.getChildElementByName("data", objElem)) != null) {
            this.imgDataStr = childElem.getTextContent().trim();
            this.img = this.loadImageFromStr(this.imgDataStr);
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element position = domDoc.createElement("position");
        position.setAttribute("lefttop", String.valueOf(Double.toString(this.x)) + ';' + Double.toString(this.y));
        position.setAttribute("rightbottom", String.valueOf(Double.toString(this.x2)) + ';' + Double.toString(this.y2));
        domData.appendChild(position);
        if (this.getClass() == GPicture.class) {
            Element data = domDoc.createElement("data");
            if (this.imgDataStr == null || this.imgDataStr.length() == 0) {
                this.imgDataStr = this.saveImageToStr(this.img);
            }
            CDATASection cdata = domDoc.createCDATASection(this.imgDataStr);
            data.appendChild(cdata);
            domData.appendChild(data);
        }
        return domData;
    }

    @Override
    public double dist(double mx, double my) {
        if (this.x < mx && mx < this.x2 && this.y > my && my > this.y2) {
            return 0.0;
        }
        return 1.0E20;
    }

    @Override
    public double getx(int sel) {
        double res = 0.0;
        switch (sel) {
            case 0: {
                res = this.x;
            }
            case 1: {
                res = this.x1;
            }
            case 2: {
                res = this.x2;
            }
        }
        return res;
    }

    @Override
    public double gety(int sel) {
        double res = 0.0;
        switch (sel) {
            case 0: {
                res = this.y;
            }
            case 1: {
                res = this.y1;
            }
            case 2: {
                res = this.y2;
            }
        }
        return res;
    }

    public void center() {
        double dx2 = (this.x2 - this.x) / 2.0;
        double dy2 = (this.y - this.y2) / 2.0;
        this.x = -dx2;
        this.y = dy2;
        this.x1 = -dx2;
        this.y1 = -dy2;
        this.x2 = dx2;
        this.y2 = -dy2;
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        this.x += dx;
        this.y += dy;
        this.x1 += dx;
        this.y1 += dy;
        this.x2 += dx;
        this.y2 += dy;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.x1 = this.x;
        this.y1 = this.y2;
        this.setValid(this.img != null);
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawMappedImage(this.img, this.x, this.y, this.x1, this.y1, this.x2, this.y2);
        }
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        menu.add2List(new JMenuItem(Messages.getString("GPicture.menu_hidepic")), 112);
    }

    protected BufferedImage loadImageFromStr(String data) {
        BufferedImage res = null;
        byte[] buf = Helpers.b64_string2bytes(data);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            res = ImageIO.read(is);
        }
        catch (IOException e) {
            System.err.println("Error reading image from string.");
            e.printStackTrace();
        }
        return res;
    }

    protected String saveImageToStr(BufferedImage image) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        catch (IOException e) {
            System.err.println("Error writing image to string.");
            e.printStackTrace();
        }
        String ds = Helpers.b64_bytes2string(os.toByteArray());
        return ds;
    }
}

