/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GCircle;
import geoobj.GConic;
import geoobj.GLine;
import geoobj.GLineObj;
import geoobj.GStick;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.LocLineController;
import geoobj.Messages;
import geoobj.RelationList;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GPoint
extends GeoObj
implements LocLineController {
    protected double fQuant = 0.0;
    protected double fAniStep = 0.0;
    protected double fParam;
    protected int fPListIndex = -1;
    protected RelationList friends = new RelationList();

    public GPoint(GeoObjList list, double ix, double iy, boolean iIsVisible) {
        super(list);
        this.ccMask = 2;
        if (this.getClass().equals(GPoint.class)) {
            this.ccMask |= 1;
            this.appearance.setPointStyle(31);
        } else {
            this.appearance.setPointStyle(30);
        }
        this.setPoint(ix, iy);
        this.setVisible(iIsVisible);
    }

    public GPoint(GeoObjList list) {
        super(list);
        this.ccMask = 3;
    }

    public GPoint(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element childElem;
        if (this.getClass() == GPoint.class) {
            this.ccMask = 3;
            if (this.parent.size() > 0) {
                this.ccMask |= 4;
            }
        } else {
            this.ccMask = 2;
        }
        if (objElem.getAttribute("quant").length() > 0) {
            this.fQuant = Double.parseDouble(objElem.getAttribute("quant"));
        }
        if (objElem.getAttribute("ani_step").length() > 0) {
            this.fAniStep = Double.parseDouble(objElem.getAttribute("ani_step"));
        }
        if (objElem.getAttribute("plist_index").length() > 0) {
            this.fPListIndex = Integer.parseInt(objElem.getAttribute("plist_index"));
        }
        if ((childElem = Helpers.getChildElementByName("position", objElem)) != null) {
            this.x = Double.parseDouble(childElem.getAttribute("x"));
            this.y = Double.parseDouble(childElem.getAttribute("y"));
        }
        if ((childElem = Helpers.getChildElementByName("friends", objElem)) != null) {
            String friendsInfo = childElem.getTextContent();
            String[] fis = friendsInfo.split(";");
            int i = 0;
            while (i < fis.length) {
                this.becomesFriendOf((GPoint)this.drawing.getObjectById(Integer.parseInt(fis[i].trim())));
                ++i;
            }
        }
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        if (this.parent.size() > 0 && this.parent.get(0) instanceof GLineObj) {
            GLineObj cl = (GLineObj)this.parent.get(0);
            this.fParam = cl.getParamFromCoords(this.x, this.y);
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        if (this.fQuant != 0.0) {
            domData.setAttribute("quant", new Double(this.fQuant).toString());
        }
        if (this.fAniStep != 0.0) {
            domData.setAttribute("ani_step", new Double(this.fAniStep).toString());
        }
        if (this.fPListIndex != -1) {
            domData.setAttribute("plist_index", new Integer(this.fPListIndex).toString());
        }
        Element pos = domDoc.createElement("position");
        pos.setAttribute("x", new Double(this.x).toString());
        pos.setAttribute("y", new Double(this.y).toString());
        domData.appendChild(pos);
        if (this.friends.size() > 0) {
            Element frli = domDoc.createElement("friends");
            frli.setTextContent(this.parent.getIdStr());
            domData.appendChild(frli);
        }
        return domData;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        if (this.getClass().equals(GPoint.class)) {
            return false;
        }
        return super.hasSameDataAs(o) && this.hasSameParentsAs(o, false);
    }

    @Override
    public double getValue(int select) {
        if (select == 1) {
            return this.x;
        }
        if (select == 2) {
            return this.y;
        }
        return 0.0;
    }

    @Override
    public boolean canMoveFree() {
        return this.parent.size() == 0;
    }

    public final void setPoint(double px, double py) {
        this.x = px;
        this.y = py;
    }

    public void bindToLine(GLineObj cl) {
        if (this.parent.size() > 0) {
            this.unbindFromLine();
        }
        this.becomesChildOf(cl);
        this.ccMask |= 4;
    }

    public void unbindFromLine() {
        GeoObj p1 = this.parent.get(0);
        if (p1 != null) {
            this.stopsToBeChildOf(p1);
            this.ccMask &= 0xFFFFFFFB;
        }
    }

    public boolean isLineBound() {
        return this.isCompatibleTo(4);
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawPoint(this.x, this.y, this.appearance.getLineWidth(), this.appearance.getShape(), this.appearance.getPointSize(), this.appearance.getColor());
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(true);
        if (this.parent.size() == 0) {
            if (this == mousedObj) {
                if (this.fQuant > 1.0E-12) {
                    this.x = this.fQuant * Math.rint(lmx / this.fQuant);
                    this.y = this.fQuant * Math.rint(lmy / this.fQuant);
                } else {
                    this.x = lmx;
                    this.y = lmy;
                }
            }
        } else if (this.parent.get(0) instanceof GLineObj) {
            GLineObj cl = (GLineObj)this.parent.get(0);
            if (this == mousedObj) {
                this.fParam = cl.getParamFromCoords(lmx, lmy);
                double[] res = cl.getCoordsFromParam(this.fParam);
                this.x = res[0];
                this.y = res[1];
            } else if (this.parent.size() == 1) {
                double[] res = cl.getCoordsFromParam(this.fParam);
                this.x = res[0];
                this.y = res[1];
            } else if (this.parent.get(1) instanceof GPoint) {
                double[] ip = this.getNearestPossiblePositionOn(cl);
                if (ip != null) {
                    this.x = ip[0];
                    this.y = ip[1];
                    this.setValid(true);
                } else {
                    this.setValid(false);
                }
            } else {
                this.setValid(false);
            }
        } else if (this.parent.get(0) instanceof GPoint) {
            GPoint leader = (GPoint)this.parent.get(0);
            double len = this.getLenOfStick(leader);
            Vector3 v = new Vector3(this.x - leader.x, this.y - leader.y, 0.0);
            v = MyMath.getNormalizedVector(v);
            v.multBy(len);
            this.x = leader.x + v.x;
            this.y = leader.y + v.y;
        } else {
            this.setValid(false);
        }
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            return MyMath.hypot(this.x - mx, this.y - my);
        }
        return 1.0E20;
    }

    @Override
    public double[] getDefaultNameParams() {
        double[] res = new double[]{0.2, -0.1};
        return res;
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        menu.add2List(new JMenuItem(Messages.getString("GPoint.menu_shape")), 62);
        if (this.isCompatibleTo(1)) {
            menu.add2List(null, 0);
            if (this.parent.size() == 0) {
                menu.add2List(new JMenuItem(Messages.getString("GPoint.menu_bind")), 152);
            } else {
                menu.add2List(new JMenuItem(Messages.getString("GPoint.menu_unbind")), 153);
            }
        }
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushDouble(this.fParam);
        this.stack.pushInt(this.fPListIndex);
    }

    @Override
    public void restoreState() {
        this.fPListIndex = this.stack.popInt();
        this.fParam = this.stack.popDouble();
        super.restoreState();
    }

    public void setPointStyle(int ps) {
        this.appearance.setPointStyle(ps);
    }

    @Override
    public boolean setLinePosition(double p) {
        if (this.getClass().equals(GPoint.class) && this.parent.size() > 0) {
            GLineObj carrier = (GLineObj)this.parent.get(0);
            this.fParam = p;
            double[] co = carrier.getCoordsFromParam(this.fParam);
            this.x = co[0];
            this.y = co[1];
            return true;
        }
        return false;
    }

    @Override
    public double getLinePosition() {
        if (this.getClass().equals(GPoint.class) && this.parent.size() > 0) {
            GLineObj carrier = (GLineObj)this.parent.get(0);
            return carrier.getParamFromCoords(this.x, this.y);
        }
        return 0.0;
    }

    @Override
    public void startAnimation() {
        if (this.getClass().equals(GPoint.class) && this.parent.size() > 0) {
            GLineObj carrier = (GLineObj)this.parent.get(0);
            double[] pr = carrier.getParamRange();
            if (this.fAniStep > 0.0 && Math.abs(pr[1] - this.fParam) < 1.0E-6) {
                this.setLinePosition(pr[0]);
            } else if (this.fAniStep < 0.0 && Math.abs(this.fParam - pr[0]) < 1.0E-6) {
                this.setLinePosition(pr[1]);
            }
        }
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        if (this.getClass().equals(GPoint.class) && this.parent.size() > 0) {
            GLineObj carrier = (GLineObj)this.parent.get(0);
            carrier.resetOLCPList(canvas, ptList);
        }
    }

    public void becomesFriendOf(GPoint iFriend) {
        if (iFriend != null) {
            if (!this.hasFriend(this, iFriend)) {
                this.friends.add(iFriend);
            }
            if (!this.hasFriend(iFriend, this)) {
                iFriend.friends.add(this);
            }
        }
    }

    public boolean hasFriend(GPoint iTest, GPoint iFriend) {
        if (iTest != null && iFriend != null) {
            int i = 0;
            while (i < iTest.friends.size()) {
                if (iFriend.id == iTest.friends.get((int)i).id) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void stopsToBeFriendOf(GPoint iFriend) {
        if (iFriend != null) {
            this.friends.remove(iFriend);
            iFriend.friends.remove(this);
        }
    }

    @Override
    public void breakRelations() {
        while (!this.friends.isEmpty()) {
            this.stopsToBeFriendOf((GPoint)this.friends.get(0));
        }
        super.breakRelations();
    }

    @Override
    protected String defName() {
        return "P";
    }

    protected double getLenOfStick(GPoint p) {
        int i = 0;
        GStick stick = null;
        while (i < this.child.size() && stick == null) {
            if (this.getChild(i) instanceof GStick && p.child.indexOf(this.getChild(i)) >= 0) {
                stick = (GStick)this.getChild(i);
                continue;
            }
            ++i;
        }
        if (stick != null) {
            return stick.getLength();
        }
        return 0.0;
    }

    protected double[] getNearestPossiblePositionOn(GLineObj cl) {
        Vector3 le;
        double[] ip = null;
        GPoint leader = (GPoint)this.parent.get(1);
        double len = this.getLenOfStick(leader);
        Vector3 ce = new Vector3(leader.x, leader.y, len);
        if (cl instanceof GLine) {
            le = cl.getCoordData();
            ip = MyMath.intersectLineAndCircle(le, ce);
        } else if (cl instanceof GCircle) {
            le = cl.getCoordData();
            ip = MyMath.intersectCircles(ce, le);
        } else if (cl instanceof GConic) {
            double[] ece = new double[]{1.0, 0.0, 1.0, -ce.x, -ce.y, MyMath.sqr(ce.x) + MyMath.sqr(ce.y) - MyMath.sqr(ce.z)};
            double[] le2 = ((GConic)cl).getEq();
            ip = MyMath.intersectConics(ece, le2);
        } else {
            this.setValid(false);
        }
        int n = 2;
        double[] lip = new double[]{1.0E10, 1.0E10, 1.42E10};
        while (n < ip.length) {
            double d;
            if (ip[n] > 0.5 && (d = Math.hypot(ip[n - 2] - this.x, ip[n - 1] - this.y)) < lip[2]) {
                lip[0] = ip[n - 2];
                lip[1] = ip[n - 1];
                lip[2] = d;
            }
            n += 3;
        }
        if (lip[2] < 1.0E10) {
            return lip;
        }
        return null;
    }
}

